/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import java.nio.ByteBuffer;
import jpcsp.HLE.modules.sceAudio;
import jpcsp.sound.SoundBufferManager;
import org.apache.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class SoundChannel {
    private static Logger log = sceAudio.log;
    private static volatile boolean isExit = false;
    public static final int FORMAT_MONO = 16;
    public static final int FORMAT_STEREO = 0;
    private static final int BUFFER_SIZE_IN_MILLIS = 100;
    public static final int MAX_VOLUME = 32768;
    private static final int DEFAULT_VOLUME = 32768;
    private static final int DEFAULT_SAMPLE_RATE = 44100;
    private SoundBufferManager soundBufferManager = SoundBufferManager.getInstance();
    private int index;
    private boolean reserved;
    private int leftVolume;
    private int rightVolume;
    private int alSource;
    private int sampleRate;
    private int sampleLength;
    private int format;
    private int numberBlockingBuffers;

    public static void init() {
        if (!AL.isCreated()) {
            try {
                AL.create();
                isExit = false;
            }
            catch (LWJGLException e) {
                log.error((Object)e);
            }
        }
    }

    public static void exit() {
        if (AL.isCreated()) {
            isExit = true;
            AL.destroy();
        }
    }

    public SoundChannel(int index) {
        this.index = index;
        this.reserved = false;
        this.leftVolume = 32768;
        this.rightVolume = 32768;
        this.alSource = AL10.alGenSources();
        this.sampleRate = 44100;
        this.updateNumberBlockingBuffers();
        AL10.alSourcei(this.alSource, 4103, 0);
    }

    private void updateNumberBlockingBuffers() {
        if (this.getSampleLength() > 0) {
            float bufferSizeInSamples = (float)(this.getSampleRate() * 100) / 1000.0f;
            this.numberBlockingBuffers = Math.round(bufferSizeInSamples / (float)this.getSampleLength());
            this.numberBlockingBuffers = Math.max(this.numberBlockingBuffers, 1);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    public int getLeftVolume() {
        return this.leftVolume;
    }

    public void setLeftVolume(int leftVolume) {
        this.leftVolume = leftVolume;
    }

    public int getRightVolume() {
        return this.rightVolume;
    }

    public void setRightVolume(int rightVolume) {
        this.rightVolume = rightVolume;
    }

    public int getSampleLength() {
        return this.sampleLength;
    }

    public void setSampleLength(int sampleLength) {
        if (this.sampleLength != sampleLength) {
            this.sampleLength = sampleLength;
            this.updateNumberBlockingBuffers();
        }
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public boolean isFormatStereo() {
        return (this.format & 0x10) == 0;
    }

    public boolean isFormatMono() {
        return (this.format & 0x10) == 16;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        if (this.sampleRate != sampleRate) {
            this.sampleRate = sampleRate;
            this.updateNumberBlockingBuffers();
        }
    }

    private void alSourcePlay() {
        int state = AL10.alGetSourcei(this.alSource, 4112);
        if (state != 4114) {
            AL10.alSourcePlay(this.alSource);
        }
    }

    private void alSourceQueueBuffer(byte[] buffer) {
        int alBuffer = this.soundBufferManager.getBuffer();
        ByteBuffer directBuffer = this.soundBufferManager.getDirectBuffer(buffer.length);
        directBuffer.clear();
        directBuffer.limit(buffer.length);
        directBuffer.put(buffer);
        directBuffer.rewind();
        int alFormat = this.isFormatStereo() ? 4355 : 4353;
        AL10.alBufferData(alBuffer, alFormat, directBuffer, this.getSampleRate());
        AL10.alSourceQueueBuffers(this.alSource, alBuffer);
        this.soundBufferManager.releaseDirectBuffer(directBuffer);
        this.alSourcePlay();
        this.checkFreeBuffers();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("alSourceQueueBuffer buffer=%d, %s", alBuffer, this.toString()));
        }
    }

    public void checkFreeBuffers() {
        this.soundBufferManager.checkFreeBuffers(this.alSource);
    }

    public void release() {
        AL10.alSourceStop(this.alSource);
        this.checkFreeBuffers();
    }

    public void play(byte[] buffer) {
        this.alSourceQueueBuffer(buffer);
    }

    private int getWaitingBuffers() {
        this.checkFreeBuffers();
        return AL10.alGetSourcei(this.alSource, 4117);
    }

    private int getSourceSampleOffset() {
        int sampleOffset = AL10.alGetSourcei(this.alSource, 4133);
        if (this.isFormatStereo()) {
            sampleOffset /= 2;
        }
        return sampleOffset;
    }

    public boolean isOutputBlocking() {
        if (isExit) {
            return true;
        }
        return this.getWaitingBuffers() >= this.numberBlockingBuffers;
    }

    public boolean isDrained() {
        if (this.isEnded()) {
            return true;
        }
        return this.getWaitingBuffers() <= 1;
    }

    public int getUnblockOutputDelayMicros(boolean waitForCompleteDrain) {
        if (isExit || this.isEnded()) {
            return 0;
        }
        int samples = waitForCompleteDrain ? this.getDrainLength() : this.getSampleLength() - this.getSourceSampleOffset();
        float delaySecs = (float)samples / (float)this.getSampleRate();
        int delayMicros = (int)(delaySecs * 1000000.0f);
        return delayMicros;
    }

    public int getDrainLength() {
        int waitingBuffers = this.getWaitingBuffers();
        if (waitingBuffers > 0) {
            --waitingBuffers;
        }
        int restLength = waitingBuffers * this.getSampleLength();
        return restLength;
    }

    public int getRestLength() {
        int restLength = this.getDrainLength();
        if (!this.isEnded()) {
            restLength += this.getSampleLength() - this.getSourceSampleOffset();
        }
        return restLength;
    }

    public boolean isEnded() {
        this.checkFreeBuffers();
        int state = AL10.alGetSourcei(this.alSource, 4112);
        return state != 4114;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("SoundChannel[%d](", this.index));
        if (!isExit) {
            s.append(String.format("sourceSampleOffset=%d", this.getSourceSampleOffset()));
            s.append(String.format(", restLength=%d", this.getRestLength()));
            s.append(String.format(", buffers queued=%d", this.getWaitingBuffers()));
            s.append(String.format(", isOutputBlock=%b", this.isOutputBlocking()));
            s.append(String.format(", %s", this.isFormatStereo() ? "Stereo" : "Mono"));
            s.append(String.format(", reserved=%b", this.reserved));
            s.append(String.format(", sampleLength=%d", this.getSampleLength()));
            s.append(String.format(", sampleRate=%d", this.getSampleRate()));
        }
        s.append(")");
        return s.toString();
    }

    public static short adjustSample(short sample, int volume) {
        return (short)(sample * volume >> 15);
    }

    public static void storeSample(short sample, byte[] data, int index) {
        data[index] = (byte)sample;
        data[index + 1] = (byte)(sample >> 8);
    }
}

