/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;

public class FastMemory
extends Memory {
    private int[] all;
    private static final boolean traceRead = false;
    private static final boolean traceWrite = false;

    @Override
    public boolean allocate() {
        this.all = null;
        int allSize = (MemoryMap.END_RAM + 1) / 4;
        try {
            this.all = new int[allSize];
        }
        catch (OutOfMemoryError e) {
            Memory.log.warn((Object)"Cannot allocate FastMemory: add the option '-Xmx256m' to the Java Virtual Machine startup command to improve Performance");
            Memory.log.info((Object)("The current Java Virtual Machine has been started using '-Xmx" + Runtime.getRuntime().maxMemory() / 0x100000L + "m'"));
            return false;
        }
        return super.allocate();
    }

    @Override
    public void Initialise() {
        Arrays.fill(this.all, 0);
    }

    @Override
    public int read8(int address) {
        try {
            int data = this.all[(address &= 0x3FFFFFFF) >> 2];
            switch (address & 3) {
                case 1: {
                    data >>= 8;
                    break;
                }
                case 2: {
                    data >>= 16;
                    break;
                }
                case 3: {
                    data >>= 24;
                }
            }
            return data & 0xFF;
        }
        catch (Exception e) {
            this.invalidMemoryAddress(address, "read8", 4);
            return 0;
        }
    }

    @Override
    public int read16(int address) {
        try {
            int data = this.all[(address &= 0x3FFFFFFF) >> 2];
            if ((address & 2) != 0) {
                data >>= 16;
            }
            return data & 0xFFFF;
        }
        catch (Exception e) {
            this.invalidMemoryAddress(address, "read16", 4);
            return 0;
        }
    }

    @Override
    public int read32(int address) {
        try {
            return this.all[(address &= 0x3FFFFFFF) >> 2];
        }
        catch (Exception e) {
            if (this.read32AllowedInvalidAddress(address)) {
                return 0;
            }
            this.invalidMemoryAddress(address, "read32", 4);
            return 0;
        }
    }

    @Override
    public long read64(int address) {
        try {
            long data = (long)this.all[(address &= 0x3FFFFFFF) / 4 + 1] << 32 | (long)this.all[address / 4] & 0xFFFFFFFFL;
            return data;
        }
        catch (Exception e) {
            this.invalidMemoryAddress(address, "read64", 4);
            return 0L;
        }
    }

    @Override
    public void write8(int address, byte data) {
        try {
            int memData = this.all[(address &= 0x3FFFFFFF) >> 2];
            switch (address & 3) {
                case 0: {
                    memData = memData & 0xFFFFFF00 | data & 0xFF;
                    break;
                }
                case 1: {
                    memData = memData & 0xFFFF00FF | (data & 0xFF) << 8;
                    break;
                }
                case 2: {
                    memData = memData & 0xFF00FFFF | (data & 0xFF) << 16;
                    break;
                }
                case 3: {
                    memData = memData & 0xFFFFFF | (data & 0xFF) << 24;
                }
            }
            this.all[address >> 2] = memData;
            Modules.sceDisplayModule.write8(address);
        }
        catch (Exception e) {
            this.invalidMemoryAddress(address, "write8", 8);
        }
    }

    @Override
    public void write16(int address, short data) {
        try {
            int memData = this.all[(address &= 0x3FFFFFFF) >> 2];
            memData = (address & 2) == 0 ? memData & 0xFFFF0000 | data & 0xFFFF : memData & 0xFFFF | data << 16;
            this.all[address >> 2] = memData;
            Modules.sceDisplayModule.write16(address);
        }
        catch (Exception e) {
            this.invalidMemoryAddress(address, "write16", 8);
        }
    }

    @Override
    public void write32(int address, int data) {
        try {
            this.all[(address &= 0x3FFFFFFF) >> 2] = data;
            Modules.sceDisplayModule.write32(address);
        }
        catch (Exception e) {
            this.invalidMemoryAddress(address, "write32", 8);
        }
    }

    @Override
    public void write64(int address, long data) {
        try {
            this.all[(address &= 0x3FFFFFFF) / 4] = (int)data;
            this.all[address / 4 + 1] = (int)(data >> 32);
        }
        catch (Exception e) {
            this.invalidMemoryAddress(address, "write64", 8);
        }
    }

    @Override
    public IntBuffer getMainMemoryByteBuffer() {
        return IntBuffer.wrap(this.all, 0x2000000, MemoryMap.SIZE_RAM / 4);
    }

    @Override
    public IntBuffer getBuffer(int address, int length) {
        address = this.normalizeAddress(address);
        IntBuffer buffer = this.getMainMemoryByteBuffer();
        buffer.position(address / 4);
        buffer.limit((address + length + 3) / 4);
        return buffer.slice();
    }

    private boolean isIntAligned(int n) {
        return (n & 3) == 0;
    }

    @Override
    public void memset(int address, byte data, int length) {
        address = this.normalizeAddress(address);
        while (!this.isIntAligned(address) && length > 0) {
            this.write8(address, data);
            ++address;
            --length;
        }
        int count4 = length / 4;
        if (count4 > 0) {
            int data1 = data & 0xFF;
            int data4 = data1 << 24 | data1 << 16 | data1 << 8 | data1;
            Arrays.fill(this.all, address / 4, address / 4 + count4, data4);
            address += count4 * 4;
            length -= count4 * 4;
        }
        while (length > 0) {
            this.write8(address, data);
            ++address;
            --length;
        }
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        while (!this.isIntAligned(address) && length > 0 && source.hasRemaining()) {
            byte b = source.get();
            this.write8(address, b);
            ++address;
            --length;
        }
        int countInt = Math.min(length, source.remaining()) >> 2;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, countInt << 2, 4);
        for (int i = 0; i < countInt; ++i) {
            int data1 = source.get() & 0xFF;
            int data2 = source.get() & 0xFF;
            int data3 = source.get() & 0xFF;
            int data4 = source.get() & 0xFF;
            int data = data4 << 24 | data3 << 16 | data2 << 8 | data1;
            memoryWriter.writeNext(data);
        }
        memoryWriter.flush();
        int copyLength = countInt << 2;
        length -= copyLength;
        address += copyLength;
        while (length > 0 && source.hasRemaining()) {
            byte b = source.get();
            this.write8(address, b);
            ++address;
            --length;
        }
    }

    public int[] getAll() {
        return this.all;
    }

    private void memcpyAligned4(int destination, int source, int length, boolean checkOverlap) {
        if (checkOverlap || !this.areOverlapping(destination, source, length)) {
            System.arraycopy(this.all, source >> 2, this.all, destination >> 2, length >> 2);
        } else {
            IMemoryReader sourceReader = MemoryReader.getMemoryReader(source, length, 4);
            IMemoryWriter destinationWriter = MemoryWriter.getMemoryWriter(destination, length, 4);
            for (int i = 0; i < length; i += 4) {
                destinationWriter.writeNext(sourceReader.readNext());
            }
            destinationWriter.flush();
        }
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        if (length <= 0) {
            return;
        }
        destination = this.normalizeAddress(destination);
        if (this.isIntAligned(source = this.normalizeAddress(source)) && this.isIntAligned(destination) && this.isIntAligned(length)) {
            this.memcpyAligned4(destination, source, length, checkOverlap);
        } else if (!((source & 3) != (destination & 3) || checkOverlap && this.areOverlapping(destination, source, length))) {
            while (!this.isIntAligned(source) && length > 0) {
                this.write8(destination, (byte)this.read8(source));
                ++source;
                ++destination;
                --length;
            }
            int length4 = length & 0xFFFFFFFC;
            if (length4 > 0) {
                this.memcpyAligned4(destination, source, length4, checkOverlap);
                source += length4;
                destination += length4;
                length -= length4;
            }
            while (length > 0) {
                this.write8(destination, (byte)this.read8(source));
                ++destination;
                ++source;
                --length;
            }
        } else if (!checkOverlap || source >= destination || !this.areOverlapping(destination, source, length)) {
            if (this.areOverlapping(destination, source, 4)) {
                for (int i = 0; i < length; ++i) {
                    this.write8(destination + i, (byte)this.read8(source + i));
                }
            } else {
                IMemoryReader sourceReader = MemoryReader.getMemoryReader(source, length, 1);
                for (int i = 0; i < length; ++i) {
                    this.write8(destination + i, (byte)sourceReader.readNext());
                }
            }
        } else {
            for (int i = length - 1; i >= 0; --i) {
                this.write8(destination + i, (byte)this.read8(source + i));
            }
        }
    }
}

