/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.textures.GETexture;

public class FBTexture
extends GETexture {
    private int fboId = -1;
    private int depthRenderBufferId = -1;

    public FBTexture(int address, int bufferWidth, int width, int height, int pixelFormat) {
        super(address, bufferWidth, width, height, pixelFormat, true);
    }

    @Override
    public void bind(IRenderingEngine re, boolean forDrawing) {
        if (forDrawing) {
            re.bindFramebuffer(0, 0);
            super.bind(re, forDrawing);
        } else if (this.fboId == -1) {
            this.fboId = re.genFramebuffer();
            re.bindFramebuffer(0, this.fboId);
            this.depthRenderBufferId = re.genRenderbuffer();
            re.bindRenderbuffer(this.depthRenderBufferId);
            re.setRenderbufferStorage(15, this.getTexImageWidth(), this.getTexImageHeight());
            super.bind(re, forDrawing);
            re.setFramebufferTexture(0, 3, this.textureId, 0);
            re.setFramebufferRenderbuffer(0, 0, this.depthRenderBufferId);
        } else {
            re.bindFramebuffer(0, this.fboId);
        }
    }

    @Override
    public void delete(IRenderingEngine re) {
        if (this.fboId != -1) {
            re.deleteFramebuffer(this.fboId);
            this.fboId = -1;
        }
        if (this.depthRenderBufferId != -1) {
            re.deleteRenderbuffer(this.depthRenderBufferId);
            this.depthRenderBufferId = -1;
        }
        super.delete(re);
    }

    @Override
    public String toString() {
        return String.format("FBTexture[0x%08X-0x%08X, %dx%d, bufferWidth=%d, pixelFormat=%d(%s)]", this.address, this.address + this.length, this.width, this.height, this.bufferWidth, this.pixelFormat, VideoEngine.getPsmName(this.pixelFormat));
    }
}

