/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import jpcsp.graphics.GeCommands;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VideoEngine;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class GEProfiler {
    public static Logger log = Logger.getLogger((String)"profiler");
    private static boolean profilerEnabled = true;
    private static ProfilerEnabledSettingsListerner profilerEnabledSettingsListerner;
    private static final Long zero;
    private static HashMap<Integer, Long> cmdCounts;
    private static HashMap<Integer, Long> primVtypeCounts;
    private static HashMap<Integer, String> vtypeNames;
    private static long geListCount;
    private static long textureLoadCount;
    private static long copyGeToMemoryCount;

    public static void initialise() {
        if (profilerEnabledSettingsListerner == null) {
            profilerEnabledSettingsListerner = new ProfilerEnabledSettingsListerner();
            Settings.getInstance().registerSettingsListener("Profiler", "emu.profiler", profilerEnabledSettingsListerner);
        }
        GEProfiler.reset();
    }

    private static void setProfilerEnabled(boolean enabled) {
        profilerEnabled = enabled;
    }

    public static boolean isProfilerEnabled() {
        return profilerEnabled;
    }

    public static void reset() {
        if (!profilerEnabled) {
            return;
        }
        cmdCounts.clear();
        primVtypeCounts.clear();
        vtypeNames.clear();
        geListCount = 0L;
        textureLoadCount = 0L;
        copyGeToMemoryCount = 0L;
    }

    public static void exit() {
        if (!profilerEnabled) {
            return;
        }
        log.info((Object)"------------------ GEProfiler ----------------------");
        log.info((Object)String.format("GE list count: %d", geListCount));
        log.info((Object)String.format("Texture load count: %d, average %.1f per GE list", textureLoadCount, (double)textureLoadCount / (double)geListCount));
        log.info((Object)String.format("Copy GE to memory: %d, average %.1f per GE list", copyGeToMemoryCount, (double)copyGeToMemoryCount / (double)geListCount));
        GeCommands geCommands = GeCommands.getInstance();
        for (Integer cmd : cmdCounts.keySet()) {
            Long cmdCount = cmdCounts.get(cmd);
            log.info((Object)String.format("%s: called %d times, average %.1f per GE list", geCommands.getCommandString(cmd), (long)cmdCount, (double)cmdCount.longValue() / (double)geListCount));
        }
        ArrayList<Integer> primVtypeSorted = new ArrayList<Integer>(primVtypeCounts.keySet());
        Collections.sort(primVtypeSorted, new Comparator<Integer>(){

            @Override
            public int compare(Integer vtype1, Integer vtype2) {
                return -((Long)primVtypeCounts.get(vtype1)).compareTo((Long)primVtypeCounts.get(vtype2));
            }
        });
        for (Integer vtype : primVtypeSorted) {
            Long vtypeCount = primVtypeCounts.get(vtype);
            log.info((Object)String.format("%s: used %d times in PRIM, average %.1f per GE list", vtypeNames.get(vtype), (long)vtypeCount, (double)vtypeCount.longValue() / (double)geListCount));
        }
    }

    public static void startGeList() {
        ++geListCount;
    }

    public static void startGeCmd(int cmd) {
        Long cmdCount = cmdCounts.get(cmd);
        if (cmdCount == null) {
            cmdCount = zero;
        }
        cmdCounts.put(cmd, cmdCount + 1L);
        if (cmd == 4) {
            VertexInfo vinfo = VideoEngine.getInstance().getContext().vinfo;
            int vtype = vinfo.vtype;
            Long vtypeCount = primVtypeCounts.get(vtype);
            if (vtypeCount == null) {
                vtypeCount = zero;
                vtypeNames.put(vtype, vinfo.toString());
            }
            primVtypeCounts.put(vtype, vtypeCount + 1L);
        }
    }

    public static void loadTexture() {
        ++textureLoadCount;
    }

    public static void copyGeToMemory() {
        ++copyGeToMemoryCount;
    }

    static {
        zero = new Long(0L);
        cmdCounts = new HashMap();
        primVtypeCounts = new HashMap();
        vtypeNames = new HashMap();
    }

    private static class ProfilerEnabledSettingsListerner
    extends AbstractBoolSettingsListener {
        private ProfilerEnabledSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            GEProfiler.setProfilerEnabled(value);
        }
    }
}

