/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.connector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashSet;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceAtrac3plus;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.connector.Connector;
import jpcsp.media.ExternalDecoder;
import jpcsp.media.FileProtocolHandler;
import jpcsp.media.MediaEngine;
import jpcsp.media.PacketChannel;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.Hash;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class AtracCodec {
    protected String id;
    protected static final String atracSuffix = ".at3";
    protected static final String decodedSuffix = ".decoded";
    protected static final String decodedAtracSuffix = ".at3.decoded";
    protected RandomAccessFile decodedStream;
    protected OutputStream atracStream;
    protected int atracEnd;
    protected int atracEndSample;
    protected int atracMaxSamples;
    protected int atracFileSize;
    protected int atracBufferAddress;
    protected int bytesPerFrame;
    protected byte[] atracDecodeBuffer;
    protected static boolean instructionsDisplayed = false;
    protected static boolean commandFileDirty = true;
    public static int waveFactChunkHeader = 1952670054;
    public static int waveDataChunkHeader = 1635017060;
    protected MediaEngine me;
    protected PacketChannel atracChannel;
    protected int currentLoopCount;
    protected boolean useMediaEngine = false;
    protected byte[] samplesBuffer;
    protected ExternalDecoder externalDecoder;
    protected boolean requireAllAtracData;
    private static final String name = "AtracCodec";

    public AtracCodec() {
        Settings.getInstance().registerSettingsListener(name, "emu.useMediaEngine", new EnableMediaEngineSettingsListerner());
        if (this.useMediaEngine()) {
            this.me = new MediaEngine();
            this.atracChannel = new PacketChannel();
            this.currentLoopCount = 0;
        }
        this.externalDecoder = new ExternalDecoder();
        this.generateCommandFile();
    }

    protected boolean checkMediaEngineState() {
        return this.useMediaEngine && this.me != null;
    }

    protected boolean useMediaEngine() {
        return this.useMediaEngine;
    }

    private void setEnableMediaEngine(boolean state) {
        this.useMediaEngine = state;
    }

    public void setAtracMaxSamples(int atracMaxSamples) {
        this.atracMaxSamples = atracMaxSamples;
        if (this.useMediaEngine()) {
            this.me.setAudioSamplesSize(atracMaxSamples);
        }
        this.atracDecodeBuffer = new byte[atracMaxSamples * 4];
        this.samplesBuffer = new byte[atracMaxSamples * 4];
    }

    protected String generateID(int address, int length, int fileSize) {
        int hashCode = Hash.getHashCodeFloatingMemory(0, address, Math.min(length, fileSize));
        return String.format("Atrac-%08X-%08X", fileSize, hashCode);
    }

    public static String getBaseDirectory() {
        return String.format("%s%s%cAtrac%c", Connector.baseDirectory, State.discId, Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar));
    }

    protected String getCompleteFileName(String suffix) {
        String completeFileName = String.format("%s%s%s", AtracCodec.getBaseDirectory(), this.id, suffix);
        return completeFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void generateCommandFile() {
        if (!commandFileDirty) {
            return;
        }
        String baseDirectory = AtracCodec.getBaseDirectory();
        File directory = new File(baseDirectory);
        String[] files = directory.list();
        HashSet<String> atracFiles = new HashSet<String>();
        HashSet<String> decodedFiles = new HashSet<String>();
        if (files != null) {
            for (String fileName : files) {
                if (fileName.endsWith(atracSuffix)) {
                    atracFiles.add(fileName);
                    continue;
                }
                if (!fileName.endsWith(decodedAtracSuffix)) continue;
                decodedFiles.add(fileName);
            }
        }
        PrintWriter command = null;
        try {
            command = new PrintWriter(String.format("%s%s", baseDirectory, "command.txt"));
            for (String atracFileName : atracFiles) {
                if (decodedFiles.contains(atracFileName + decodedSuffix)) continue;
                command.println("DecodeAtrac3");
                command.println("ms0:/tmp/" + atracFileName);
            }
            command.println("Exit");
            commandFileDirty = false;
        }
        catch (FileNotFoundException e) {
            Utilities.close(command);
            catch (Throwable throwable) {
                Utilities.close(command);
                throw throwable;
            }
        }
        Utilities.close(command);
    }

    protected void closeStreams() {
        Utilities.close(this.decodedStream, this.atracStream);
        this.decodedStream = null;
        this.atracStream = null;
        this.requireAllAtracData = false;
    }

    public void setRequireAllAtracData() {
        this.requireAllAtracData = true;
    }

    public void atracSetData(int atracID, int codecType, int address, int length, int atracFileSize) {
        Object decodedFile;
        this.atracFileSize = atracFileSize;
        this.atracBufferAddress = address;
        this.id = this.generateID(address, length, atracFileSize);
        this.closeStreams();
        this.atracEndSample = -1;
        this.requireAllAtracData = false;
        int memoryCodecType = sceAtrac3plus.getCodecType(address);
        if (memoryCodecType != codecType && memoryCodecType != 0) {
            Modules.log.info((Object)String.format("Different CodecType received %d != %d, assuming %d", codecType, memoryCodecType, memoryCodecType));
            codecType = memoryCodecType;
        }
        if (codecType == 4097) {
            Modules.log.info((Object)"Decodable AT3 data detected.");
            if (this.checkMediaEngineState()) {
                this.me.finish();
                this.atracChannel = new PacketChannel();
                this.atracChannel.setTotalStreamSize(atracFileSize);
                this.atracChannel.setFarRewindAllowed(true);
                this.atracChannel.write(address, length);
                this.atracEndSample = 0;
                return;
            }
        } else if (codecType == 4096) {
            if (this.checkMediaEngineState() && ExternalDecoder.isEnabled()) {
                decodedFile = this.externalDecoder.decodeAtrac(address, length, atracFileSize, this);
                if (decodedFile != null) {
                    Modules.log.info((Object)"AT3+ data decoded by the external decoder.");
                    this.me.finish();
                    this.atracChannel = null;
                    this.me.init(new FileProtocolHandler((String)decodedFile), false, true);
                    this.atracEndSample = -1;
                    return;
                }
                if (this.requireAllAtracData) {
                    this.me.finish();
                    this.atracChannel = new PacketChannel();
                    this.atracChannel.setTotalStreamSize(atracFileSize);
                    this.atracChannel.write(address, length);
                    return;
                }
                Modules.log.info((Object)"AT3+ data could not be decoded by the external decoder.");
            } else {
                Modules.log.info((Object)"Undecodable AT3+ data detected.");
            }
        }
        this.me = null;
        decodedFile = new File(this.getCompleteFileName(decodedAtracSuffix));
        if (!((File)decodedFile).canRead()) {
            File alternateDecodedFile;
            int chunkSize;
            int numberOfSamples = 0;
            int data = 0;
            Memory mem = Memory.getInstance();
            int endScanAddress = address + length;
            for (int scanAddress = address + 12; scanAddress < endScanAddress; scanAddress += chunkSize + 8) {
                int chunkHeader = mem.read32(scanAddress);
                chunkSize = mem.read32(scanAddress + 4);
                if (chunkHeader == waveFactChunkHeader) {
                    numberOfSamples = mem.read32(scanAddress + 8);
                    continue;
                }
                if (chunkHeader != waveDataChunkHeader) continue;
                data = mem.read32(scanAddress + 8);
                break;
            }
            if ((alternateDecodedFile = new File(String.format("%sAtrac-%08X-%08X-%08X%s", AtracCodec.getBaseDirectory(), atracFileSize, numberOfSamples, data, decodedAtracSuffix))).canRead()) {
                decodedFile = alternateDecodedFile;
            }
        }
        File atracFile = new File(this.getCompleteFileName(atracSuffix));
        if (((File)decodedFile).canRead()) {
            try {
                this.decodedStream = new RandomAccessFile((File)decodedFile, "r");
                this.atracEndSample = (int)(((File)decodedFile).length() / 4L);
            }
            catch (FileNotFoundException e) {
                Modules.log.warn((Object)e);
            }
        } else if ((!atracFile.canRead() || atracFile.length() != (long)atracFileSize) && sceAtrac3plus.isEnableConnector()) {
            commandFileDirty = true;
            this.displayInstructions();
            new File(AtracCodec.getBaseDirectory()).mkdirs();
            try {
                this.atracStream = new FileOutputStream(this.getCompleteFileName(atracSuffix));
                byte[] buffer = new byte[length];
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
                for (int i = 0; i < length; ++i) {
                    buffer[i] = (byte)memoryReader.readNext();
                }
                this.atracStream.write(buffer);
            }
            catch (IOException e) {
                Modules.log.warn((Object)e);
            }
            this.generateCommandFile();
        }
    }

    public void atracAddStreamData(int address, int length) {
        if (this.checkMediaEngineState()) {
            if (this.atracChannel != null) {
                this.atracChannel.write(address, length);
            }
            return;
        }
        if (this.atracStream != null) {
            try {
                byte[] buffer = new byte[length];
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
                for (int i = 0; i < length; ++i) {
                    buffer[i] = (byte)memoryReader.readNext();
                }
                this.atracStream.write(buffer);
            }
            catch (IOException e) {
                Modules.log.error((Object)e);
            }
        }
    }

    public int atracDecodeData(int atracID, int address) {
        boolean isEnded;
        int samples;
        block22: {
            samples = 0;
            isEnded = false;
            if (this.checkMediaEngineState()) {
                if (this.me.getContainer() == null && this.atracChannel != null) {
                    if (this.requireAllAtracData) {
                        if (this.atracChannel.length() >= this.atracFileSize) {
                            this.requireAllAtracData = false;
                            if (this.checkMediaEngineState() && ExternalDecoder.isEnabled()) {
                                String decodedFile = this.externalDecoder.decodeAtrac(this.atracChannel, this.atracBufferAddress, this.atracFileSize);
                                if (decodedFile != null) {
                                    Modules.log.info((Object)"AT3+ data decoded by the external decoder (all AT3+ data retrieved).");
                                    this.me.finish();
                                    this.atracChannel = null;
                                    this.me.init(new FileProtocolHandler(decodedFile), false, true);
                                    this.atracEndSample = -1;
                                } else {
                                    Modules.log.info((Object)"AT3+ data could not be decoded by the external decoder, even after retrieving all AT3+ data.");
                                    this.me = null;
                                }
                            } else {
                                Modules.log.info((Object)"AT3+ data could not be decoded by the external decoder, even after retrieving all AT3+ data.");
                                this.me = null;
                            }
                            if (this.me == null) {
                                return this.atracDecodeData(atracID, address);
                            }
                        } else {
                            samples = 1;
                            Memory.getInstance().memset(address, (byte)0, samples * 4);
                        }
                    } else if (this.atracChannel.length() >= 98304 || this.atracChannel.length() >= this.atracFileSize) {
                        this.me.init(this.atracChannel, false, true);
                    } else {
                        samples = 1;
                        Memory.getInstance().memset(address, (byte)0, samples * 4);
                    }
                }
                if (this.me.stepAudio(this.atracMaxSamples * 4)) {
                    samples = this.copySamplesToMem(address);
                }
                if (samples == 0) {
                    isEnded = true;
                }
            } else if (this.decodedStream != null) {
                try {
                    int length = this.decodedStream.read(this.atracDecodeBuffer);
                    if (length > 0) {
                        samples = length / 4;
                        Memory.getInstance().copyToMemory(address, ByteBuffer.wrap(this.atracDecodeBuffer, 0, length), length);
                        long restLength = this.decodedStream.length() - this.decodedStream.getFilePointer();
                        if (restLength <= 0L) {
                            isEnded = true;
                        }
                        break block22;
                    }
                    isEnded = true;
                }
                catch (IOException e) {
                    Modules.log.warn((Object)e);
                }
            } else {
                samples = -1;
                isEnded = true;
            }
        }
        this.atracEnd = isEnded ? 1 : 0;
        return samples;
    }

    public void atracResetPlayPosition(int sample) {
        if (this.checkMediaEngineState()) {
            this.me.audioResetPlayPosition(sample);
        }
        if (this.decodedStream != null) {
            try {
                this.decodedStream.seek((long)sample * 4L);
            }
            catch (IOException e) {
                Modules.log.error((Object)e);
            }
        }
    }

    public int getChannelLength() {
        if (this.atracChannel == null) {
            return this.atracFileSize;
        }
        return this.atracChannel.length();
    }

    public int getChannelPosition() {
        if (this.atracChannel == null) {
            return -1;
        }
        return (int)this.atracChannel.getPosition();
    }

    public void resetChannel() {
        if (this.atracChannel == null) {
            return;
        }
        this.atracChannel.clear();
    }

    public int getAtracEnd() {
        return this.atracEnd;
    }

    public int getAtracEndSample() {
        return this.atracEndSample;
    }

    public void setAtracLoopCount(int count) {
        this.currentLoopCount = count;
    }

    protected int copySamplesToMem(int address) {
        Memory mem = Memory.getInstance();
        int bytes = this.me.getCurrentAudioSamples(this.samplesBuffer);
        if (bytes > 0) {
            this.atracEndSample += bytes;
            mem.copyToMemory(address, ByteBuffer.wrap(this.samplesBuffer, 0, bytes), bytes);
        }
        return bytes / 4;
    }

    public void finish() {
        this.closeStreams();
        Settings.getInstance().removeSettingsListener(name);
    }

    public boolean isExternalAudio() {
        return this.atracChannel == null;
    }

    protected void displayInstructions() {
        if (instructionsDisplayed) {
            return;
        }
        Logger log = Modules.log;
        log.info((Object)"The ATRAC3 audio is currently being saved under");
        log.info((Object)("    " + AtracCodec.getBaseDirectory()));
        log.info((Object)"To decode the audio, copy the following file");
        log.info((Object)"    *.at3");
        log.info((Object)"    command.txt");
        log.info((Object)"to your PSP under");
        log.info((Object)"    ms0:/tmp/");
        log.info((Object)"and run the 'Jpcsp Connector 3xx' on your PSP.");
        log.info((Object)"After decoding on the PSP, move the following files");
        log.info((Object)"    ms0:/tmp/.at3.decoded");
        log.info((Object)"back to Jpcsp under");
        log.info((Object)("    " + AtracCodec.getBaseDirectory()));
        log.info((Object)"Afterwards, you can delete the files on the PSP.");
        instructionsDisplayed = true;
    }

    private class EnableMediaEngineSettingsListerner
    extends AbstractBoolSettingsListener {
        private EnableMediaEngineSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            AtracCodec.this.setEnableMediaEngine(value);
        }
    }
}

