/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules200;

import java.util.Calendar;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;

public class sceRtc
extends jpcsp.HLE.modules150.sceRtc {
    @HLEFunction(nid=540863245, version=200)
    public void sceRtcGetLastReincarnatedTime(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int tick_addr = cpu.gpr[4];
        if (Modules.log.isDebugEnabled()) {
            Modules.log.debug((Object)"sceRtcGetLastReincarnatedTime");
        }
        if (Memory.isAddressGood(tick_addr)) {
            mem.write64(tick_addr, this.hleGetCurrentTick());
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1651007128, version=200)
    public void sceRtcGetLastAdjustedTime(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int tick_addr = cpu.gpr[4];
        if (Modules.log.isDebugEnabled()) {
            Modules.log.debug((Object)"sceRtcGetLastAdjustedTime");
        }
        if (Memory.isAddressGood(tick_addr)) {
            mem.write64(tick_addr, this.hleGetCurrentTick());
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=420071835, version=200)
    public void sceRtcSetTime64_t(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int date_addr = cpu.gpr[4];
        long time = Utilities.getRegister64(cpu, cpu.gpr[5]);
        if (Memory.isAddressGood(date_addr)) {
            ScePspDateTime dateTime = ScePspDateTime.fromUnixTime(time);
            dateTime.write(mem, date_addr);
            cpu.gpr[2] = 0;
        } else {
            log.warn((Object)("sceRtcSetTime64_t bad address " + String.format("0x%08X", date_addr)));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-506905017, version=200)
    public void sceRtcGetTime64_t(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int date_addr = cpu.gpr[4];
        int time_addr = cpu.gpr[5];
        if (Memory.isAddressGood(date_addr) && Memory.isAddressGood(time_addr)) {
            ScePspDateTime dateTime = new ScePspDateTime();
            dateTime.read(mem, date_addr);
            Calendar cal = Calendar.getInstance();
            cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
            long unixtime = cal.getTime().getTime() / 1000L;
            log.debug((Object)("sceRtcGetTime64_t psptime:" + dateTime + " unixtime:" + unixtime));
            mem.write64(time_addr, unixtime);
            cpu.gpr[2] = 0;
        } else {
            log.warn((Object)("sceRtcGetTime64_t bad address " + String.format("0x%08X 0x%08X", date_addr, time_addr)));
            cpu.gpr[2] = -1;
        }
    }
}

