/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.Memory;

public class SceIoStat {
    public int mode;
    public int attr;
    public long size;
    public ScePspDateTime ctime;
    public ScePspDateTime atime;
    public ScePspDateTime mtime;
    private int[] reserved = new int[]{0x12121212, 0x34343434, 0x56565656, 0x78787878, -1701143910, -1128481604};

    public SceIoStat() {
    }

    public SceIoStat(int mode, int attr, long size, ScePspDateTime ctime, ScePspDateTime atime, ScePspDateTime mtime) {
        this.init(mode, attr, size, ctime, atime, mtime);
    }

    public void init(int mode, int attr, long size, ScePspDateTime ctime, ScePspDateTime atime, ScePspDateTime mtime) {
        this.mode = mode;
        this.attr = attr;
        this.size = size;
        this.ctime = ctime;
        this.atime = atime;
        this.mtime = mtime;
    }

    public void write(Memory mem, int address) {
        if (!Memory.isAddressGood(address) || !Memory.isAddressGood(address + SceIoStat.sizeof())) {
            Modules.log.warn((Object)("SceIoStat write bad address " + String.format("0x%08X", address)));
        }
        mem.write32(address, this.mode);
        mem.write32(address + 4, this.attr);
        mem.write64(address + 8, this.size);
        this.ctime.write(mem, address + 16);
        this.atime.write(mem, address + 32);
        this.mtime.write(mem, address + 48);
        mem.write32(address + 64, this.reserved[0]);
        mem.write32(address + 68, this.reserved[1]);
        mem.write32(address + 72, this.reserved[2]);
        mem.write32(address + 76, this.reserved[3]);
        mem.write32(address + 80, this.reserved[4]);
        mem.write32(address + 84, this.reserved[5]);
    }

    public void read(Memory mem, int address) {
        if (!Memory.isAddressGood(address) || !Memory.isAddressGood(address + SceIoStat.sizeof())) {
            Modules.log.warn((Object)("SceIoStat read bad address " + String.format("0x%08X", address)));
        }
        this.mode = mem.read32(address);
        this.attr = mem.read32(address + 4);
        this.size = mem.read32(address + 8);
        this.ctime = new ScePspDateTime();
        this.atime = new ScePspDateTime();
        this.mtime = new ScePspDateTime();
        this.ctime.read(mem, address + 16);
        this.atime.read(mem, address + 32);
        this.mtime.read(mem, address + 48);
    }

    public static int sizeof() {
        return 88;
    }

    public void setReserved(int index, int value) {
        this.reserved[index] = value;
    }

    public int getReserved(int index) {
        return this.reserved[index];
    }

    public String toString() {
        return String.format("SceIoStat[mode=0x%X, attr=0x%X, size=%d, ctime=%s, atime=%s, mtime=%s]", this.mode, this.attr, this.size, this.ctime.toString(), this.atime.toString(), this.mtime.toString());
    }
}

