/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import com.jidesoft.swing.FolderChooser;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jpcsp.Emulator;
import jpcsp.Resource;
import jpcsp.settings.Settings;

public class SettingsGUI
extends JFrame {
    private static final long serialVersionUID = -732715495873159718L;
    private Settings settings = Settings.getInstance();
    private JPanel AudioPanel;
    private JRadioButton ClassicOpenDialogumd;
    private JPanel CompilerPanel;
    private JPanel CryptoPanel;
    private JCheckBox DisableSceAudioCheck;
    private JPanel DisplayPanel;
    private JCheckBox IgnoreAudioThreadsCheck;
    private JPanel MemoryPanel;
    private JPanel MiscPanel;
    private JPanel RegionPanel;
    private JPanel VideoPanel;
    private JComboBox adhocChannelBox;
    private JLabel adhocChannelLabel;
    private JLabel antiAliasLabel;
    private JComboBox antiAliasingBox;
    private JComboBox buttonBox;
    private ButtonGroup buttonGroup1;
    private JLabel buttonLabel;
    private JCheckBox cryptoSavedata;
    private JComboBox dateFormatBox;
    private JLabel dateFormatLabel;
    private JComboBox daylightBox;
    private JLabel daylightLabel;
    private JCheckBox disableBlockingAudioCheck;
    private JCheckBox disableOptimizedVertexInfoReading;
    private JCheckBox useSoftwareRenderer;
    private JCheckBox disableUBOCheck;
    private JCheckBox disableVBOCheck;
    private JCheckBox enableDynamicShadersCheck;
    private JCheckBox enableGETextureCheck;
    private JCheckBox enableNativeCLUTCheck;
    private JCheckBox enableShaderColorMaskCheck;
    private JCheckBox enableShaderStencilTestCheck;
    private JCheckBox enableVAOCheck;
    private JCheckBox extractEboot;
    private JCheckBox extractPGD;
    private JCheckBox filelogCheck;
    private JCheckBox loadAndRunCheck;
    private JCheckBox fullscreenCheck;
    private JPanel generalPanel;
    private JCheckBox geometryShaderCheck;
    private JCheckBox ignoreUnmappedImports;
    private JLabel imposeLabel;
    private JLabel imposeLabel1;
    private JCheckBox invalidMemoryCheck;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JComboBox languageBox;
    private JLabel languageLabel;
    private JComboBox methodMaxInstructionsBox;
    private JLabel methodMaxInstructionsLabel;
    private JTextField nicknameTextField;
    private JLabel nicknamelLabel;
    private JCheckBox onlyGEGraphicsCheck;
    private JCheckBox pbpunpackcheck;
    private JCheckBox profilerCheck;
    private JComboBox resolutionBox;
    private JLabel resolutionLabel;
    private JCheckBox saveWindowPosCheck;
    private JCheckBox shadersCheck;
    private JComboBox timeFormatBox;
    private JLabel timeFormatLabel;
    private JLabel timezoneLabel;
    private JSpinner timezoneSpinner;
    private JTextField tmppath;
    private JRadioButton umdBrowser;
    private JTextField umdpath;
    private JCheckBox useCompiler;
    private JCheckBox useConnector;
    private JCheckBox useDebugFont;
    private JCheckBox useExternalDecoder;
    private JCheckBox useMediaEngine;
    private JCheckBox useVertexCache;
    private JComboBox wlanPowerBox;
    private JLabel wlanPowerLabel;

    public SettingsGUI() {
        this.initComponents();
        this.setAllComponentsFromSettings();
    }

    private void setAllComponentsFromSettings() {
        this.setBoolFromSettings(this.pbpunpackcheck, "emu.pbpunpack");
        this.setBoolFromSettings(this.saveWindowPosCheck, "gui.saveWindowPos");
        this.setBoolFromSettings(this.fullscreenCheck, "gui.fullscreen");
        this.setBoolFromSettings(this.useCompiler, "emu.compiler");
        this.setBoolFromSettings(this.profilerCheck, "emu.profiler");
        this.setBoolFromSettings(this.shadersCheck, "emu.useshaders");
        this.setBoolFromSettings(this.geometryShaderCheck, "emu.useGeometryShader");
        this.setBoolFromSettings(this.filelogCheck, "emu.debug.enablefilelogger");
        this.setBoolFromSettings(this.loadAndRunCheck, "emu.loadAndRun");
        this.setIntFromSettings(this.languageBox, "emu.impose.language");
        this.setIntFromSettings(this.buttonBox, "emu.impose.button");
        this.setIntFromSettings(this.daylightBox, "emu.sysparam.daylightsavings");
        this.setIntFromSettings(this.timezoneSpinner, "emu.sysparam.timezone");
        this.setIntFromSettings(this.timeFormatBox, "emu.sysparam.timeformat");
        this.setIntFromSettings(this.dateFormatBox, "emu.sysparam.dateformat");
        this.setIntFromSettings(this.wlanPowerBox, "emu.sysparam.wlanpowersave");
        this.setIntFromSettings(this.adhocChannelBox, "emu.sysparam.adhocchannel");
        this.setStringFromSettings(this.nicknameTextField, "emu.sysparam.nickname");
        this.setBoolFromSettings(this.disableVBOCheck, "emu.disablevbo");
        this.setBoolFromSettings(this.disableUBOCheck, "emu.disableubo");
        this.setBoolFromSettings(this.enableVAOCheck, "emu.enablevao");
        this.setBoolFromSettings(this.enableGETextureCheck, "emu.enablegetexture");
        this.setBoolFromSettings(this.enableNativeCLUTCheck, "emu.enablenativeclut");
        this.setBoolFromSettings(this.enableDynamicShadersCheck, "emu.enabledynamicshaders");
        this.setBoolFromSettings(this.enableShaderStencilTestCheck, "emu.enableshaderstenciltest");
        this.setBoolFromSettings(this.enableShaderColorMaskCheck, "emu.enableshadercolormask");
        this.setBoolFromSettings(this.disableOptimizedVertexInfoReading, "emu.disableoptimizedvertexinforeading");
        this.setBoolFromSettings(this.useSoftwareRenderer, "emu.useSoftwareRenderer");
        this.setBoolFromSettings(this.onlyGEGraphicsCheck, "emu.onlyGEGraphics");
        this.setBoolFromSettings(this.useConnector, "emu.useConnector");
        this.setBoolFromSettings(this.useDebugFont, "emu.useDebugFont");
        this.setBoolFromSettings(this.useExternalDecoder, "emu.useExternalDecoder");
        this.setBoolFromSettings(this.useMediaEngine, "emu.useMediaEngine");
        this.setBoolFromSettings(this.useVertexCache, "emu.useVertexCache");
        this.setBoolFromSettings(this.invalidMemoryCheck, "emu.ignoreInvalidMemoryAccess");
        this.setBoolFromSettings(this.DisableSceAudioCheck, "emu.disablesceAudio");
        this.setBoolFromSettings(this.IgnoreAudioThreadsCheck, "emu.ignoreaudiothreads");
        this.setBoolFromSettings(this.disableBlockingAudioCheck, "emu.disableblockingaudio");
        this.setBoolFromSettings(this.ignoreUnmappedImports, "emu.ignoreUnmappedImports");
        this.setIntAsStringFromSettings(this.methodMaxInstructionsBox, "emu.compiler.methodMaxInstructions", 3000);
        this.setBoolFromSettings(this.extractEboot, "emu.extractEboot");
        this.setBoolFromSettings(this.cryptoSavedata, "emu.cryptoSavedata");
        this.setBoolFromSettings(this.extractPGD, "emu.extractPGD");
        this.setStringFromSettings(this.antiAliasingBox, "emu.graphics.antialias");
        this.setStringFromSettings(this.resolutionBox, "emu.graphics.resolution");
        this.setStringFromSettings(this.umdpath, "emu.umdpath");
        this.setStringFromSettings(this.tmppath, "emu.tmppath");
        this.setBoolFromSettings(this.umdBrowser, this.ClassicOpenDialogumd, "emu.umdbrowser");
    }

    private boolean isEnabledSettings(String settingsOption) {
        return !this.settings.isOptionFromPatch(settingsOption);
    }

    private void setBoolFromSettings(JRadioButton trueButton, JRadioButton falseButton, String settingsOption) {
        boolean value = this.settings.readBool(settingsOption);
        trueButton.setSelected(value);
        falseButton.setSelected(!value);
        trueButton.setEnabled(this.isEnabledSettings(settingsOption));
        falseButton.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setBoolFromSettings(JCheckBox checkBox, String settingsOption) {
        checkBox.setSelected(this.settings.readBool(settingsOption));
        checkBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setIntFromSettings(JComboBox comboBox, String settingsOption) {
        comboBox.setSelectedIndex(this.settings.readInt(settingsOption));
        comboBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setIntAsStringFromSettings(JComboBox comboBox, String settingsOption, int defaultValue) {
        comboBox.setSelectedItem(Integer.toString(this.settings.readInt(settingsOption, defaultValue)));
        comboBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setIntFromSettings(JSpinner spinner, String settingsOption) {
        spinner.setValue(this.settings.readInt(settingsOption));
        spinner.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setStringFromSettings(JComboBox comboBox, String settingsOption) {
        comboBox.setSelectedItem(this.settings.readString(settingsOption));
        comboBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setStringFromSettings(JTextField textField, String settingsOption) {
        textField.setText(this.settings.readString(settingsOption));
        textField.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setAllComponentsToSettings() {
        this.setBoolToSettings(this.pbpunpackcheck, "emu.pbpunpack");
        this.setBoolToSettings(this.saveWindowPosCheck, "gui.saveWindowPos");
        this.setBoolToSettings(this.fullscreenCheck, "gui.fullscreen");
        this.setBoolToSettings(this.useCompiler, "emu.compiler");
        this.setBoolToSettings(this.profilerCheck, "emu.profiler");
        this.setBoolToSettings(this.shadersCheck, "emu.useshaders");
        this.setBoolToSettings(this.geometryShaderCheck, "emu.useGeometryShader");
        this.setBoolToSettings(this.filelogCheck, "emu.debug.enablefilelogger");
        this.setBoolToSettings(this.loadAndRunCheck, "emu.loadAndRun");
        this.setIntToSettings(this.languageBox, "emu.impose.language");
        this.setIntToSettings(this.buttonBox, "emu.impose.button");
        this.setIntToSettings(this.daylightBox, "emu.sysparam.daylightsavings");
        this.setIntToSettings(this.timezoneSpinner, "emu.sysparam.timezone");
        this.setIntToSettings(this.timeFormatBox, "emu.sysparam.timeformat");
        this.setIntToSettings(this.dateFormatBox, "emu.sysparam.dateformat");
        this.setIntToSettings(this.wlanPowerBox, "emu.sysparam.wlanpowersave");
        this.setIntToSettings(this.adhocChannelBox, "emu.sysparam.adhocchannel");
        this.setStringToSettings(this.nicknameTextField, "emu.sysparam.nickname");
        this.setBoolToSettings(this.disableVBOCheck, "emu.disablevbo");
        this.setBoolToSettings(this.disableUBOCheck, "emu.disableubo");
        this.setBoolToSettings(this.enableVAOCheck, "emu.enablevao");
        this.setBoolToSettings(this.enableGETextureCheck, "emu.enablegetexture");
        this.setBoolToSettings(this.enableNativeCLUTCheck, "emu.enablenativeclut");
        this.setBoolToSettings(this.enableDynamicShadersCheck, "emu.enabledynamicshaders");
        this.setBoolToSettings(this.enableShaderStencilTestCheck, "emu.enableshaderstenciltest");
        this.setBoolToSettings(this.enableShaderColorMaskCheck, "emu.enableshadercolormask");
        this.setBoolToSettings(this.disableOptimizedVertexInfoReading, "emu.disableoptimizedvertexinforeading");
        this.setBoolToSettings(this.useSoftwareRenderer, "emu.useSoftwareRenderer");
        this.setBoolToSettings(this.onlyGEGraphicsCheck, "emu.onlyGEGraphics");
        this.setBoolToSettings(this.useConnector, "emu.useConnector");
        this.setBoolToSettings(this.useDebugFont, "emu.useDebugFont");
        this.setBoolToSettings(this.useExternalDecoder, "emu.useExternalDecoder");
        this.setBoolToSettings(this.useMediaEngine, "emu.useMediaEngine");
        this.setBoolToSettings(this.useVertexCache, "emu.useVertexCache");
        this.setBoolToSettings(this.invalidMemoryCheck, "emu.ignoreInvalidMemoryAccess");
        this.setBoolToSettings(this.DisableSceAudioCheck, "emu.disablesceAudio");
        this.setBoolToSettings(this.IgnoreAudioThreadsCheck, "emu.ignoreaudiothreads");
        this.setBoolToSettings(this.disableBlockingAudioCheck, "emu.disableblockingaudio");
        this.setBoolToSettings(this.ignoreUnmappedImports, "emu.ignoreUnmappedImports");
        this.setIntAsStringToSettings(this.methodMaxInstructionsBox, "emu.compiler.methodMaxInstructions", 3000);
        this.setBoolToSettings(this.extractEboot, "emu.extractEboot");
        this.setBoolToSettings(this.cryptoSavedata, "emu.cryptoSavedata");
        this.setBoolToSettings(this.extractPGD, "emu.extractPGD");
        this.setStringToSettings(this.antiAliasingBox, "emu.graphics.antialias");
        this.setStringToSettings(this.resolutionBox, "emu.graphics.resolution");
        this.setStringToSettings(this.umdpath, "emu.umdpath");
        this.setStringToSettings(this.tmppath, "emu.tmppath");
        this.setBoolToSettings(this.umdBrowser, "emu.umdbrowser");
    }

    private void setBoolToSettings(JRadioButton radioButton, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeBool(settingsOption, radioButton.isSelected());
        }
    }

    private void setBoolToSettings(JCheckBox checkBox, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeBool(settingsOption, checkBox.isSelected());
        }
    }

    private void setIntToSettings(JComboBox comboBox, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeInt(settingsOption, comboBox.getSelectedIndex());
        }
    }

    private void setIntAsStringToSettings(JComboBox comboBox, String settingsOption, int defaultValue) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeInt(settingsOption, Integer.parseInt(comboBox.getSelectedItem().toString()));
        }
    }

    private void setIntToSettings(JSpinner spinner, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeInt(settingsOption, Integer.parseInt(spinner.getValue().toString()));
        }
    }

    private void setStringToSettings(JComboBox comboBox, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeString(settingsOption, comboBox.getSelectedItem().toString());
        }
    }

    private void setStringToSettings(JTextField textField, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeString(settingsOption, textField.getText());
        }
    }

    private ComboBoxModel makeLanguageComboBoxModel() {
        DefaultComboBoxModel<String> comboBox = new DefaultComboBoxModel<String>();
        for (String language : SettingsGUI.getImposeLanguages()) {
            comboBox.addElement(language);
        }
        return comboBox;
    }

    public static String[] getImposeLanguages() {
        return new String[]{Resource.getEnglish("japanese"), Resource.getEnglish("english"), Resource.getEnglish("french"), Resource.getEnglish("spanish"), Resource.getEnglish("german"), Resource.getEnglish("italian"), Resource.getEnglish("dutch"), Resource.getEnglish("portuguese"), Resource.getEnglish("russian"), Resource.getEnglish("korean"), Resource.getEnglish("traditionalChinese"), Resource.getEnglish("simplifiedChinese")};
    }

    public static String[] getImposeButtons() {
        return new String[]{"\"O\" for \"Enter\"", "\"X\" for \"Enter\""};
    }

    public static String[] getSysparamDaylightSavings() {
        return new String[]{"Off", "On"};
    }

    public static String[] getSysparamTimeFormats() {
        return new String[]{"24H", "12H"};
    }

    public static String[] getSysparamDateFormats() {
        return new String[]{"YYYY-MM-DD", "MM-DD-YYYY", "DD-MM-YYYY"};
    }

    public static String[] getSysparamWlanPowerSaves() {
        return new String[]{"Off", "On"};
    }

    public static String[] getSysparamAdhocChannels() {
        return new String[]{"Auto", "1", "6", "11"};
    }

    private ComboBoxModel makeMethodMaxInstructions() {
        DefaultComboBoxModel<String> comboBox = new DefaultComboBoxModel<String>();
        comboBox.addElement("50");
        comboBox.addElement("100");
        comboBox.addElement("500");
        comboBox.addElement("1000");
        comboBox.addElement("3000");
        return comboBox;
    }

    private ComboBoxModel makeResolutions() {
        DefaultComboBoxModel<String> comboBox = new DefaultComboBoxModel<String>();
        comboBox.addElement("Native");
        HashSet<String> resolutions = new HashSet<String>();
        GraphicsDevice localDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode[] displayModes = localDevice.getDisplayModes();
        for (int i = 0; displayModes != null && i < displayModes.length; ++i) {
            String resolution;
            DisplayMode displayMode = displayModes[i];
            if (displayMode.getBitDepth() != 32 || resolutions.contains(resolution = String.format("%dx%d", displayMode.getWidth(), displayMode.getHeight()))) continue;
            comboBox.addElement(resolution);
            resolutions.add(resolution);
        }
        return comboBox;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonApply = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.pbpunpackcheck = new JCheckBox();
        this.saveWindowPosCheck = new JCheckBox();
        this.umdBrowser = new JRadioButton();
        this.ClassicOpenDialogumd = new JRadioButton();
        this.umdpath = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.filelogCheck = new JCheckBox();
        this.loadAndRunCheck = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.tmppath = new JTextField();
        this.jButton2 = new JButton();
        this.RegionPanel = new JPanel();
        this.languageLabel = new JLabel();
        this.languageBox = new JComboBox();
        this.buttonLabel = new JLabel();
        this.buttonBox = new JComboBox();
        this.daylightLabel = new JLabel();
        this.daylightBox = new JComboBox();
        this.timeFormatLabel = new JLabel();
        this.timeFormatBox = new JComboBox();
        this.dateFormatLabel = new JLabel();
        this.dateFormatBox = new JComboBox();
        this.wlanPowerLabel = new JLabel();
        this.wlanPowerBox = new JComboBox();
        this.adhocChannelLabel = new JLabel();
        this.adhocChannelBox = new JComboBox();
        this.timezoneLabel = new JLabel();
        this.timezoneSpinner = new JSpinner();
        this.nicknamelLabel = new JLabel();
        this.nicknameTextField = new JTextField();
        this.imposeLabel = new JLabel();
        this.imposeLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.VideoPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.disableVBOCheck = new JCheckBox();
        this.onlyGEGraphicsCheck = new JCheckBox();
        this.useVertexCache = new JCheckBox();
        this.shadersCheck = new JCheckBox();
        this.geometryShaderCheck = new JCheckBox();
        this.disableUBOCheck = new JCheckBox();
        this.enableVAOCheck = new JCheckBox();
        this.enableGETextureCheck = new JCheckBox();
        this.enableNativeCLUTCheck = new JCheckBox();
        this.enableDynamicShadersCheck = new JCheckBox();
        this.enableShaderStencilTestCheck = new JCheckBox();
        this.enableShaderColorMaskCheck = new JCheckBox();
        this.disableOptimizedVertexInfoReading = new JCheckBox();
        this.useSoftwareRenderer = new JCheckBox();
        this.AudioPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.IgnoreAudioThreadsCheck = new JCheckBox();
        this.disableBlockingAudioCheck = new JCheckBox();
        this.DisableSceAudioCheck = new JCheckBox();
        this.MemoryPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.invalidMemoryCheck = new JCheckBox();
        this.ignoreUnmappedImports = new JCheckBox();
        this.MiscPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.useMediaEngine = new JCheckBox();
        this.useConnector = new JCheckBox();
        this.useExternalDecoder = new JCheckBox();
        this.useDebugFont = new JCheckBox();
        this.CompilerPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.useCompiler = new JCheckBox();
        this.methodMaxInstructionsBox = new JComboBox();
        this.profilerCheck = new JCheckBox();
        this.methodMaxInstructionsLabel = new JLabel();
        this.CryptoPanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.extractEboot = new JCheckBox();
        this.cryptoSavedata = new JCheckBox();
        this.extractPGD = new JCheckBox();
        this.DisplayPanel = new JPanel();
        this.fullscreenCheck = new JCheckBox();
        this.antiAliasLabel = new JLabel();
        this.antiAliasingBox = new JComboBox();
        this.resolutionLabel = new JLabel();
        this.resolutionBox = new JComboBox();
        this.setTitle("Configuration");
        this.setResizable(true);
        this.jButtonOK.setText(Resource.get("ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(Resource.get("cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonApply.setText(Resource.get("apply"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.pbpunpackcheck.setText(Resource.get("unpackpbp"));
        this.saveWindowPosCheck.setText(Resource.get("saveposition"));
        this.buttonGroup1.add(this.umdBrowser);
        this.umdBrowser.setText(Resource.get("useUMDBrowser"));
        this.buttonGroup1.add(this.ClassicOpenDialogumd);
        this.ClassicOpenDialogumd.setText(Resource.get("useclassicUMD"));
        this.umdpath.setEditable(false);
        this.jLabel1.setText(Resource.get("UMDpath"));
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.filelogCheck.setText(Resource.get("enablefileIO"));
        this.loadAndRunCheck.setText(Resource.get("loadAndRun"));
        this.jLabel2.setText(Resource.get("TMPpath"));
        this.tmppath.setEditable(false);
        this.jButton2.setText("...");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.umdpath, -2, 175, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 23, -2)).addGroup(generalPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tmppath, -2, 175, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 23, -2)).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.umdBrowser, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.ClassicOpenDialogumd, GroupLayout.Alignment.LEADING)).addComponent(this.filelogCheck).addComponent(this.loadAndRunCheck).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.pbpunpackcheck, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.saveWindowPosCheck, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.pbpunpackcheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveWindowPosCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filelogCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadAndRunCheck).addGap(41, 41, 41).addComponent(this.umdBrowser).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ClassicOpenDialogumd).addGap(18, 18, 18).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.umdpath, -2, -1, -2).addComponent(this.jButton1)).addGap(18, 18, 18).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tmppath, -2, -1, -2).addComponent(this.jButton2)).addContainerGap(74, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("general"), this.generalPanel);
        this.languageLabel.setText(Resource.get("language"));
        this.languageBox.setModel(this.makeLanguageComboBoxModel());
        this.buttonLabel.setText(Resource.get("buttonpref"));
        this.buttonBox.setModel(new DefaultComboBoxModel<String>(new String[]{"\"O\" for \"Enter\"", "\"X\" for \"Enter\""}));
        this.daylightLabel.setText(Resource.get("daylightSavings"));
        this.daylightBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Off", "On"}));
        this.timeFormatLabel.setText(Resource.get("timeformat"));
        this.timeFormatBox.setModel(new DefaultComboBoxModel<String>(new String[]{"24H", "12H"}));
        this.dateFormatLabel.setText(Resource.get("dateformat"));
        this.dateFormatBox.setModel(new DefaultComboBoxModel<String>(new String[]{"YYYY-MM-DD", "MM-DD-YYYY", "DD-MM-YYYY"}));
        this.wlanPowerLabel.setText(Resource.get("wlanpowersaving"));
        this.wlanPowerBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Off", "On"}));
        this.adhocChannelLabel.setText(Resource.get("adhocChannel"));
        this.adhocChannelBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto", "1", "2", "3", "4"}));
        this.timezoneLabel.setText(Resource.get("timezone"));
        this.timezoneSpinner.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.nicknamelLabel.setText(Resource.get("nickname"));
        this.nicknameTextField.setHorizontalAlignment(4);
        this.nicknameTextField.setText("JPCSP");
        this.imposeLabel.setText("Impose:");
        this.imposeLabel1.setText("System param:");
        GroupLayout RegionPanelLayout = new GroupLayout(this.RegionPanel);
        this.RegionPanel.setLayout(RegionPanelLayout);
        RegionPanelLayout.setHorizontalGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RegionPanelLayout.createSequentialGroup().addContainerGap().addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imposeLabel).addGroup(RegionPanelLayout.createSequentialGroup().addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imposeLabel1).addComponent(this.daylightLabel).addComponent(this.timezoneLabel).addComponent(this.timeFormatLabel).addComponent(this.dateFormatLabel).addComponent(this.wlanPowerLabel).addComponent(this.adhocChannelLabel).addComponent(this.nicknamelLabel)).addGap(29, 29, 29).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timezoneSpinner, -2, -1, -2).addComponent(this.daylightBox, -2, -1, -2).addComponent(this.timeFormatBox, -2, -1, -2).addComponent(this.dateFormatBox, -2, -1, -2).addComponent(this.wlanPowerBox, -2, -1, -2).addComponent(this.adhocChannelBox, -2, -1, -2).addComponent(this.nicknameTextField, -2, 134, -2))).addGroup(RegionPanelLayout.createSequentialGroup().addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.languageLabel, -2, 86, -2).addComponent(this.buttonLabel)).addGap(117, 117, 117).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.languageBox, 0, -1, Short.MAX_VALUE).addComponent(this.buttonBox, 0, -1, Short.MAX_VALUE))).addComponent(this.jSeparator1, -2, 419, -2)).addContainerGap()));
        RegionPanelLayout.setVerticalGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RegionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.imposeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageLabel).addComponent(this.languageBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonLabel).addComponent(this.buttonBox, -2, -1, -2)).addGap(24, 24, 24).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imposeLabel1).addGap(18, 18, 18).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.daylightLabel).addComponent(this.daylightBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timezoneLabel).addComponent(this.timezoneSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeFormatLabel).addComponent(this.timeFormatBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateFormatLabel).addComponent(this.dateFormatBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wlanPowerLabel).addComponent(this.wlanPowerBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.adhocChannelLabel).addComponent(this.adhocChannelBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nicknamelLabel).addComponent(this.nicknameTextField, -2, -1, -2)).addGap(31, 31, 31)));
        this.jTabbedPane1.addTab(Resource.get("region"), this.RegionPanel);
        this.disableVBOCheck.setText(Resource.get("disablevbo"));
        this.onlyGEGraphicsCheck.setText(Resource.get("onlyGeGraphics"));
        this.useVertexCache.setText(Resource.get("usevertex"));
        this.shadersCheck.setText(Resource.get("useshader"));
        this.geometryShaderCheck.setText(Resource.get("useGeometryShader"));
        this.disableUBOCheck.setText(Resource.get("disableubo"));
        this.enableVAOCheck.setText(Resource.get("enablevao"));
        this.enableGETextureCheck.setText(Resource.get("enablegetexture"));
        this.enableNativeCLUTCheck.setText(Resource.get("enablenativeclut"));
        this.enableDynamicShadersCheck.setText(Resource.get("enabledynamicshaders"));
        this.enableShaderStencilTestCheck.setText(Resource.get("enableshaderstenciltest"));
        this.enableShaderColorMaskCheck.setText(Resource.get("enableshadercolormask"));
        this.disableOptimizedVertexInfoReading.setText(Resource.get("disableoptimizedvertexinforeading"));
        this.useSoftwareRenderer.setText(Resource.get("useSoftwareRenderer"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disableVBOCheck).addComponent(this.onlyGEGraphicsCheck).addComponent(this.useVertexCache).addComponent(this.shadersCheck, -1, -1, Short.MAX_VALUE).addComponent(this.geometryShaderCheck, -1, -1, Short.MAX_VALUE).addComponent(this.disableUBOCheck).addComponent(this.enableVAOCheck).addComponent(this.enableGETextureCheck).addComponent(this.enableNativeCLUTCheck).addComponent(this.enableDynamicShadersCheck).addComponent(this.enableShaderStencilTestCheck).addComponent(this.enableShaderColorMaskCheck).addComponent(this.disableOptimizedVertexInfoReading).addComponent(this.useSoftwareRenderer)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.disableVBOCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlyGEGraphicsCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useVertexCache).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shadersCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.geometryShaderCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableUBOCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableVAOCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableGETextureCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableNativeCLUTCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableDynamicShadersCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableShaderStencilTestCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableShaderColorMaskCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableOptimizedVertexInfoReading).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useSoftwareRenderer).addContainerGap(30, Short.MAX_VALUE)));
        GroupLayout VideoPanelLayout = new GroupLayout(this.VideoPanel);
        this.VideoPanel.setLayout(VideoPanelLayout);
        VideoPanelLayout.setHorizontalGroup(VideoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VideoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        VideoPanelLayout.setVerticalGroup(VideoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VideoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("video"), this.VideoPanel);
        this.IgnoreAudioThreadsCheck.setText(Resource.get("disableaudiothreads"));
        this.disableBlockingAudioCheck.setText(Resource.get("disableaudiotblocking"));
        this.DisableSceAudioCheck.setText(Resource.get("disableaudiotchannels"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.IgnoreAudioThreadsCheck).addComponent(this.DisableSceAudioCheck).addComponent(this.disableBlockingAudioCheck));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.IgnoreAudioThreadsCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DisableSceAudioCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableBlockingAudioCheck)));
        GroupLayout AudioPanelLayout = new GroupLayout(this.AudioPanel);
        this.AudioPanel.setLayout(AudioPanelLayout);
        AudioPanelLayout.setHorizontalGroup(AudioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AudioPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        AudioPanelLayout.setVerticalGroup(AudioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AudioPanelLayout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addContainerGap(257, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("audio"), this.AudioPanel);
        this.invalidMemoryCheck.setText(Resource.get("ignoreinvalidmemory"));
        this.ignoreUnmappedImports.setText(Resource.get("ignoreUnmaped"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignoreUnmappedImports).addComponent(this.invalidMemoryCheck)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.invalidMemoryCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreUnmappedImports).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout MemoryPanelLayout = new GroupLayout(this.MemoryPanel);
        this.MemoryPanel.setLayout(MemoryPanelLayout);
        MemoryPanelLayout.setHorizontalGroup(MemoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MemoryPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addContainerGap()));
        MemoryPanelLayout.setVerticalGroup(MemoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MemoryPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addContainerGap(269, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("memory"), this.MemoryPanel);
        this.useMediaEngine.setText(Resource.get("useMediaEngine"));
        this.useConnector.setText(Resource.get("useConnector"));
        this.useExternalDecoder.setText(Resource.get("useExternalDecoder"));
        this.useDebugFont.setText(Resource.get("useDebugFont"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.useMediaEngine, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.useConnector, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.useExternalDecoder, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.useDebugFont, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.useMediaEngine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useConnector).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useExternalDecoder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useDebugFont).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout MiscPanelLayout = new GroupLayout(this.MiscPanel);
        this.MiscPanel.setLayout(MiscPanelLayout);
        MiscPanelLayout.setHorizontalGroup(MiscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MiscPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addContainerGap()));
        MiscPanelLayout.setVerticalGroup(MiscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MiscPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addContainerGap(223, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("misc"), this.MiscPanel);
        this.useCompiler.setText(Resource.get("useCompiler"));
        this.methodMaxInstructionsBox.setModel(this.makeMethodMaxInstructions());
        this.profilerCheck.setText(Resource.get("outputprofiler"));
        this.methodMaxInstructionsLabel.setText(Resource.get("methodMaxInstructions"));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.useCompiler, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.profilerCheck, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel5Layout.createSequentialGroup().addComponent(this.methodMaxInstructionsBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, -1).addComponent(this.methodMaxInstructionsLabel, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.useCompiler).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profilerCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.methodMaxInstructionsBox, -2, -1, -2).addComponent(this.methodMaxInstructionsLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout CompilerPanelLayout = new GroupLayout(this.CompilerPanel);
        this.CompilerPanel.setLayout(CompilerPanelLayout);
        CompilerPanelLayout.setHorizontalGroup(CompilerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CompilerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addContainerGap()));
        CompilerPanelLayout.setVerticalGroup(CompilerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CompilerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addContainerGap(243, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("compiler"), this.CompilerPanel);
        this.extractEboot.setText(Resource.get("extractEboot"));
        this.cryptoSavedata.setText(Resource.get("cryptoSavedata"));
        this.extractPGD.setText(Resource.get("extractPGD"));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.extractEboot, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.cryptoSavedata, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.extractPGD, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.extractEboot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cryptoSavedata).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extractPGD).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout CryptoPanelLayout = new GroupLayout(this.CryptoPanel);
        this.CryptoPanel.setLayout(CryptoPanelLayout);
        CryptoPanelLayout.setHorizontalGroup(CryptoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CryptoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -2, -1, -2).addContainerGap()));
        CryptoPanelLayout.setVerticalGroup(CryptoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CryptoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -2, -1, -2).addContainerGap(246, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("crypto"), this.CryptoPanel);
        this.fullscreenCheck.setText(Resource.get("fullscreenMode"));
        this.antiAliasLabel.setText(Resource.get("antiAliasing"));
        this.antiAliasingBox.setModel(new DefaultComboBoxModel<String>(new String[]{"OFF", "x4", "x8", "x16"}));
        this.resolutionLabel.setText(Resource.get("resolution"));
        this.resolutionBox.setModel(this.makeResolutions());
        GroupLayout DisplayPanelLayout = new GroupLayout(this.DisplayPanel);
        this.DisplayPanel.setLayout(DisplayPanelLayout);
        DisplayPanelLayout.setHorizontalGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DisplayPanelLayout.createSequentialGroup().addContainerGap().addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fullscreenCheck).addGroup(DisplayPanelLayout.createSequentialGroup().addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.antiAliasLabel, -2, 65, -2).addComponent(this.resolutionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resolutionBox, -2, -1, -2).addComponent(this.antiAliasingBox, -2, -1, -2)))).addContainerGap()));
        DisplayPanelLayout.setVerticalGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DisplayPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.antiAliasLabel).addComponent(this.antiAliasingBox, -2, -1, -2)).addGap(12, 12, 12).addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resolutionLabel).addComponent(this.resolutionBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.fullscreenCheck).addContainerGap(228, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("display"), this.DisplayPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonOK, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply, -2, 94, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    public void RefreshWindow() {
        this.setAllComponentsFromSettings();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setAllComponentsToSettings();
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.setAllComponentsToSettings();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        FolderChooser folderChooser = new FolderChooser("Select UMD folder");
        int result = folderChooser.showSaveDialog((Component)this.jButton1.getTopLevelAncestor());
        if (result == 0) {
            this.umdpath.setText(folderChooser.getSelectedFile().getPath());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.RefreshWindow();
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        FolderChooser folderChooser = new FolderChooser("Select TMP folder");
        int result = folderChooser.showSaveDialog((Component)this.jButton2.getTopLevelAncestor());
        if (result == 0) {
            this.tmppath.setText(folderChooser.getSelectedFile().getPath());
        }
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

