/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.Resource;
import jpcsp.State;
import jpcsp.settings.Settings;
import net.java.games.input.Component;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public class ControlsGUI
extends JFrame
implements KeyListener {
    private static final long serialVersionUID = -732715495873159718L;
    private boolean getKey = false;
    private JTextField sender;
    private Controller.keyCode targetKey;
    private HashMap<Integer, Controller.keyCode> currentKeys;
    private HashMap<Controller.keyCode, Integer> revertKeys;
    private HashMap<Controller.keyCode, String> currentController;
    private ControllerPollThread controllerPollThread;
    private static final int maxControllerFieldValueLength = 9;
    private JLabel bgLabel1;
    private JComboBox controllerBox;
    private JLabel controllerLabel;
    private JPanel fgPanel;
    private JTextField fieldAnalogDown;
    private JTextField fieldAnalogLeft;
    private JTextField fieldAnalogRight;
    private JTextField fieldAnalogUp;
    private JTextField fieldCircle;
    private JTextField fieldCross;
    private JTextField fieldDown;
    private JTextField fieldHold;
    private JTextField fieldHome;
    private JTextField fieldLTrigger;
    private JTextField fieldLeft;
    private JTextField fieldMusic;
    private JTextField fieldRTrigger;
    private JTextField fieldRight;
    private JTextField fieldScreen;
    private JTextField fieldSelect;
    private JTextField fieldSquare;
    private JTextField fieldStart;
    private JTextField fieldTriangle;
    private JTextField fieldUp;
    private JTextField fieldVolMin;
    private JTextField fieldVolPlus;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JPanel keyPanel;

    public ControlsGUI() {
        this.initComponents();
        this.loadKeys();
        net.java.games.input.Controller controller = Controller.getInstance().getInputController();
        if (controller != null) {
            for (int i = 0; i < this.controllerBox.getItemCount(); ++i) {
                if (controller != this.controllerBox.getItemAt(i)) continue;
                this.controllerBox.setSelectedIndex(i);
                break;
            }
        }
        this.setFields();
        this.fieldCircle.addKeyListener(this);
        this.fieldCross.addKeyListener(this);
        this.fieldDown.addKeyListener(this);
        this.fieldLTrigger.addKeyListener(this);
        this.fieldLeft.addKeyListener(this);
        this.fieldRTrigger.addKeyListener(this);
        this.fieldRight.addKeyListener(this);
        this.fieldSelect.addKeyListener(this);
        this.fieldSquare.addKeyListener(this);
        this.fieldStart.addKeyListener(this);
        this.fieldTriangle.addKeyListener(this);
        this.fieldUp.addKeyListener(this);
        this.fieldHome.addKeyListener(this);
        this.fieldScreen.addKeyListener(this);
        this.fieldMusic.addKeyListener(this);
        this.fieldVolPlus.addKeyListener(this);
        this.fieldVolMin.addKeyListener(this);
        this.fieldHold.addKeyListener(this);
        this.fieldAnalogUp.addKeyListener(this);
        this.fieldAnalogDown.addKeyListener(this);
        this.fieldAnalogLeft.addKeyListener(this);
        this.fieldAnalogRight.addKeyListener(this);
        this.controllerBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ControlsGUI.this.onControllerChange();
            }
        });
        this.controllerPollThread = new ControllerPollThread();
        this.controllerPollThread.setName("Controller Poll Thread");
        this.controllerPollThread.setDaemon(true);
        this.controllerPollThread.start();
    }

    @Override
    public void dispose() {
        if (this.controllerPollThread != null) {
            this.controllerPollThread.exit = true;
        }
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private void onControllerChange() {
        this.setFields();
    }

    private net.java.games.input.Controller getSelectedController() {
        if (this.controllerBox != null) {
            int controllerIndex = this.controllerBox.getSelectedIndex();
            ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
            net.java.games.input.Controller[] controllers = ce.getControllers();
            if (controllers != null && controllerIndex >= 0 && controllerIndex < controllers.length) {
                return controllers[controllerIndex];
            }
        }
        return null;
    }

    private void loadKeys() {
        this.currentKeys = Settings.getInstance().loadKeys();
        this.revertKeys = new HashMap(22);
        for (Map.Entry<Integer, Controller.keyCode> entry : this.currentKeys.entrySet()) {
            this.revertKeys.put(entry.getValue(), entry.getKey());
        }
        this.currentController = Settings.getInstance().loadController();
    }

    private void setFieldValue(Controller.keyCode key, String value) {
        switch (key) {
            case DOWN: {
                this.fieldDown.setText(value);
                break;
            }
            case UP: {
                this.fieldUp.setText(value);
                break;
            }
            case LEFT: {
                this.fieldLeft.setText(value);
                break;
            }
            case RIGHT: {
                this.fieldRight.setText(value);
                break;
            }
            case ANDOWN: {
                this.fieldAnalogDown.setText(value);
                break;
            }
            case ANUP: {
                this.fieldAnalogUp.setText(value);
                break;
            }
            case ANLEFT: {
                this.fieldAnalogLeft.setText(value);
                break;
            }
            case ANRIGHT: {
                this.fieldAnalogRight.setText(value);
                break;
            }
            case TRIANGLE: {
                this.fieldTriangle.setText(value);
                break;
            }
            case SQUARE: {
                this.fieldSquare.setText(value);
                break;
            }
            case CIRCLE: {
                this.fieldCircle.setText(value);
                break;
            }
            case CROSS: {
                this.fieldCross.setText(value);
                break;
            }
            case L1: {
                this.fieldLTrigger.setText(value);
                break;
            }
            case R1: {
                this.fieldRTrigger.setText(value);
                break;
            }
            case START: {
                this.fieldStart.setText(value);
                break;
            }
            case SELECT: {
                this.fieldSelect.setText(value);
                break;
            }
            case HOME: {
                this.fieldHome.setText(value);
                break;
            }
            case HOLD: {
                this.fieldHold.setText(value);
                break;
            }
            case VOLMIN: {
                this.fieldVolMin.setText(value);
                break;
            }
            case VOLPLUS: {
                this.fieldVolPlus.setText(value);
                break;
            }
            case SCREEN: {
                this.fieldScreen.setText(value);
                break;
            }
            case MUSIC: {
                this.fieldMusic.setText(value);
            }
        }
    }

    private void setFields() {
        if (Controller.isKeyboardController(this.getSelectedController())) {
            for (Map.Entry<Integer, Controller.keyCode> entry : this.currentKeys.entrySet()) {
                this.setFieldValue(entry.getValue(), KeyEvent.getKeyText(entry.getKey()));
            }
        } else {
            for (Map.Entry<Controller.keyCode, String> entry : this.currentController.entrySet()) {
                String identifierName = entry.getValue();
                this.setFieldValue(entry.getKey(), this.getControllerFieldText(identifierName));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (!this.getKey) {
            return;
        }
        this.getKey = false;
        int pressedKey = arg0.getKeyCode();
        Controller.keyCode k = this.currentKeys.get(pressedKey);
        if (k != null) {
            Emulator.log.warn((Object)("Key already used for " + (Object)((Object)k)));
            this.sender.setText(KeyEvent.getKeyText(this.revertKeys.get((Object)this.targetKey)));
            return;
        }
        int oldMapping = this.revertKeys.get((Object)this.targetKey);
        this.revertKeys.remove((Object)this.targetKey);
        this.currentKeys.remove(oldMapping);
        this.currentKeys.put(pressedKey, this.targetKey);
        this.revertKeys.put(this.targetKey, pressedKey);
        this.sender.setText(KeyEvent.getKeyText(pressedKey));
        this.getKey = false;
    }

    private void setKey(JTextField sender, Controller.keyCode targetKey) {
        if (this.getKey) {
            this.sender.setText(KeyEvent.getKeyText(this.revertKeys.get((Object)this.targetKey)));
        }
        sender.setText("PressKey");
        this.getKey = true;
        this.sender = sender;
        this.targetKey = targetKey;
    }

    private void setControllerMapping(Controller.keyCode targetKey, String identifierName, JTextField field) {
        this.currentController.put(targetKey, identifierName);
        field.setText(this.getControllerFieldText(identifierName));
        this.getKey = false;
    }

    private Component getControllerComponent(String identifierName) {
        net.java.games.input.Controller controller = this.getSelectedController();
        if (controller == null) {
            return null;
        }
        Component[] components = controller.getComponents();
        if (components == null) {
            return null;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!identifierName.equals(components[i].getIdentifier().getName())) continue;
            return components[i];
        }
        return null;
    }

    private String getControllerFieldText(String identifierName) {
        Component component = this.getControllerComponent(identifierName);
        if (component == null) {
            return identifierName;
        }
        String name = component.getName();
        if (name == null) {
            name = identifierName;
        } else if (name.length() > 9 && identifierName.length() < name.length()) {
            name = identifierName;
        }
        return name;
    }

    private void onControllerEvent(Event event) {
        if (!this.getKey) {
            return;
        }
        Component component = event.getComponent();
        float value = event.getValue();
        Component.Identifier identifier = component.getIdentifier();
        String identifierName = identifier.getName();
        if (identifier instanceof Component.Identifier.Button && value == 1.0f) {
            this.setControllerMapping(this.targetKey, identifierName, this.sender);
        } else if (identifier == Component.Identifier.Axis.POV) {
            switch (this.targetKey) {
                case DOWN: 
                case UP: 
                case LEFT: 
                case RIGHT: {
                    this.setControllerMapping(Controller.keyCode.DOWN, identifierName, this.fieldDown);
                    this.setControllerMapping(Controller.keyCode.UP, identifierName, this.fieldUp);
                    this.setControllerMapping(Controller.keyCode.LEFT, identifierName, this.fieldLeft);
                    this.setControllerMapping(Controller.keyCode.RIGHT, identifierName, this.fieldRight);
                    break;
                }
                default: {
                    Controller.log.warn((Object)String.format("Unknown Controller POV Event on %s(%s): %f for %s", component.getName(), identifier.getName(), Float.valueOf(value), this.targetKey.toString()));
                    break;
                }
            }
        } else if (identifier instanceof Component.Identifier.Axis && !Controller.isInDeadZone(component, value)) {
            switch (this.targetKey) {
                case DOWN: 
                case UP: {
                    this.setControllerMapping(Controller.keyCode.DOWN, identifierName, this.fieldDown);
                    this.setControllerMapping(Controller.keyCode.UP, identifierName, this.fieldUp);
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.setControllerMapping(Controller.keyCode.LEFT, identifierName, this.fieldLeft);
                    this.setControllerMapping(Controller.keyCode.RIGHT, identifierName, this.fieldRight);
                    break;
                }
                case ANDOWN: 
                case ANUP: {
                    this.setControllerMapping(Controller.keyCode.ANDOWN, identifierName, this.fieldAnalogDown);
                    this.setControllerMapping(Controller.keyCode.ANUP, identifierName, this.fieldAnalogUp);
                    break;
                }
                case ANLEFT: 
                case ANRIGHT: {
                    this.setControllerMapping(Controller.keyCode.ANLEFT, identifierName, this.fieldAnalogLeft);
                    this.setControllerMapping(Controller.keyCode.ANRIGHT, identifierName, this.fieldAnalogRight);
                    break;
                }
                default: {
                    this.setControllerMapping(this.targetKey, identifierName, this.sender);
                    break;
                }
            }
        } else if (identifier instanceof Component.Identifier.Axis && Controller.isInDeadZone(component, value)) {
            Controller.log.debug((Object)String.format("Unknown Controller Event in DeadZone on %s(%s): %f for %s", component.getName(), identifier.getName(), Float.valueOf(value), this.targetKey.toString()));
        } else {
            Controller.log.warn((Object)String.format("Unknown Controller Event on %s(%s): %f for %s", component.getName(), identifier.getName(), Float.valueOf(value), this.targetKey.toString()));
        }
    }

    public ComboBoxModel makeControllerComboBoxModel() {
        net.java.games.input.Controller[] controllers;
        DefaultComboBoxModel<net.java.games.input.Controller> comboBox = new DefaultComboBoxModel<net.java.games.input.Controller>();
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        for (net.java.games.input.Controller c : controllers = ce.getControllers()) {
            comboBox.addElement(c);
        }
        return comboBox;
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.keyPanel = new JPanel();
        this.fgPanel = new JPanel();
        this.fieldStart = new JTextField();
        this.fieldSelect = new JTextField();
        this.fieldCross = new JTextField();
        this.fieldCircle = new JTextField();
        this.fieldTriangle = new JTextField();
        this.fieldSquare = new JTextField();
        this.fieldRight = new JTextField();
        this.fieldUp = new JTextField();
        this.fieldLeft = new JTextField();
        this.fieldDown = new JTextField();
        this.fieldHold = new JTextField();
        this.fieldHome = new JTextField();
        this.fieldVolMin = new JTextField();
        this.fieldVolPlus = new JTextField();
        this.fieldLTrigger = new JTextField();
        this.fieldRTrigger = new JTextField();
        this.fieldScreen = new JTextField();
        this.fieldMusic = new JTextField();
        this.fieldAnalogUp = new JTextField();
        this.fieldAnalogDown = new JTextField();
        this.fieldAnalogLeft = new JTextField();
        this.fieldAnalogRight = new JTextField();
        this.bgLabel1 = new JLabel();
        this.controllerBox = new JComboBox();
        this.controllerLabel = new JLabel();
        this.setTitle("Controls");
        this.setResizable(false);
        this.jButtonOK.setText(Resource.get("ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsGUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(Resource.get("cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsGUI.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.keyPanel.setMinimumSize(new Dimension(1, 1));
        this.keyPanel.setLayout(new GridBagLayout());
        this.fgPanel.setBorder(BorderFactory.createEtchedBorder(0));
        this.fgPanel.setOpaque(false);
        this.fgPanel.setPreferredSize(new Dimension(614, 312));
        this.fieldStart.setEditable(false);
        this.fieldStart.setHorizontalAlignment(0);
        this.fieldStart.setText("Enter");
        this.fieldStart.setToolTipText(Resource.get("putkey"));
        this.fieldStart.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldStart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldStartMouseClicked(evt);
            }
        });
        this.fieldSelect.setEditable(false);
        this.fieldSelect.setHorizontalAlignment(0);
        this.fieldSelect.setText("Space");
        this.fieldSelect.setToolTipText(Resource.get("putkey"));
        this.fieldSelect.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldSelect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldSelectMouseClicked(evt);
            }
        });
        this.fieldCross.setEditable(false);
        this.fieldCross.setHorizontalAlignment(0);
        this.fieldCross.setText("S");
        this.fieldCross.setToolTipText(Resource.get("putkey"));
        this.fieldCross.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldCross.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldCrossMouseClicked(evt);
            }
        });
        this.fieldCircle.setEditable(false);
        this.fieldCircle.setHorizontalAlignment(0);
        this.fieldCircle.setText("D");
        this.fieldCircle.setToolTipText(Resource.get("putkey"));
        this.fieldCircle.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldCircle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldCircleMouseClicked(evt);
            }
        });
        this.fieldTriangle.setEditable(false);
        this.fieldTriangle.setHorizontalAlignment(0);
        this.fieldTriangle.setText("W");
        this.fieldTriangle.setToolTipText(Resource.get("putkey"));
        this.fieldTriangle.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldTriangle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldTriangleMouseClicked(evt);
            }
        });
        this.fieldSquare.setEditable(false);
        this.fieldSquare.setHorizontalAlignment(0);
        this.fieldSquare.setText("A");
        this.fieldSquare.setToolTipText(Resource.get("putkey"));
        this.fieldSquare.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldSquare.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldSquareMouseClicked(evt);
            }
        });
        this.fieldRight.setEditable(false);
        this.fieldRight.setHorizontalAlignment(0);
        this.fieldRight.setText("Right");
        this.fieldRight.setToolTipText(Resource.get("putkey"));
        this.fieldRight.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldRightMouseClicked(evt);
            }
        });
        this.fieldUp.setEditable(false);
        this.fieldUp.setHorizontalAlignment(0);
        this.fieldUp.setText("Up");
        this.fieldUp.setToolTipText(Resource.get("putkey"));
        this.fieldUp.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldUpMouseClicked(evt);
            }
        });
        this.fieldLeft.setEditable(false);
        this.fieldLeft.setHorizontalAlignment(0);
        this.fieldLeft.setText("Left");
        this.fieldLeft.setToolTipText(Resource.get("putkey"));
        this.fieldLeft.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldLeftMouseClicked(evt);
            }
        });
        this.fieldDown.setEditable(false);
        this.fieldDown.setHorizontalAlignment(0);
        this.fieldDown.setText("Down");
        this.fieldDown.setToolTipText(Resource.get("putkey"));
        this.fieldDown.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldDownMouseClicked(evt);
            }
        });
        this.fieldHold.setEditable(false);
        this.fieldHold.setHorizontalAlignment(0);
        this.fieldHold.setText("O");
        this.fieldHold.setToolTipText(Resource.get("putkey"));
        this.fieldHold.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldHold.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldHoldMouseClicked(evt);
            }
        });
        this.fieldHome.setEditable(false);
        this.fieldHome.setHorizontalAlignment(0);
        this.fieldHome.setText("H");
        this.fieldHome.setToolTipText(Resource.get("putkey"));
        this.fieldHome.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldHome.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldHomeMouseClicked(evt);
            }
        });
        this.fieldVolMin.setEditable(false);
        this.fieldVolMin.setHorizontalAlignment(0);
        this.fieldVolMin.setText("-");
        this.fieldVolMin.setToolTipText(Resource.get("putkey"));
        this.fieldVolMin.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldVolMin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldVolMinMouseClicked(evt);
            }
        });
        this.fieldVolPlus.setEditable(false);
        this.fieldVolPlus.setHorizontalAlignment(0);
        this.fieldVolPlus.setText("+");
        this.fieldVolPlus.setToolTipText(Resource.get("putkey"));
        this.fieldVolPlus.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldVolPlus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldVolPlusMouseClicked(evt);
            }
        });
        this.fieldLTrigger.setEditable(false);
        this.fieldLTrigger.setHorizontalAlignment(0);
        this.fieldLTrigger.setText("Q");
        this.fieldLTrigger.setToolTipText(Resource.get("putkey"));
        this.fieldLTrigger.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldLTrigger.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldLTriggerMouseClicked(evt);
            }
        });
        this.fieldRTrigger.setEditable(false);
        this.fieldRTrigger.setHorizontalAlignment(0);
        this.fieldRTrigger.setText("E");
        this.fieldRTrigger.setToolTipText(Resource.get("putkey"));
        this.fieldRTrigger.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldRTrigger.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldRTriggerMouseClicked(evt);
            }
        });
        this.fieldScreen.setEditable(false);
        this.fieldScreen.setHorizontalAlignment(0);
        this.fieldScreen.setText("S");
        this.fieldScreen.setToolTipText(Resource.get("putkey"));
        this.fieldScreen.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldScreenMouseClicked(evt);
            }
        });
        this.fieldMusic.setEditable(false);
        this.fieldMusic.setHorizontalAlignment(0);
        this.fieldMusic.setText("N");
        this.fieldMusic.setToolTipText(Resource.get("putkey"));
        this.fieldMusic.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldMusic.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldMusicMouseClicked(evt);
            }
        });
        this.fieldAnalogUp.setEditable(false);
        this.fieldAnalogUp.setHorizontalAlignment(0);
        this.fieldAnalogUp.setText("I");
        this.fieldAnalogUp.setToolTipText(Resource.get("putkey"));
        this.fieldAnalogUp.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldAnalogUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogUpMouseClicked(evt);
            }
        });
        this.fieldAnalogDown.setEditable(false);
        this.fieldAnalogDown.setHorizontalAlignment(0);
        this.fieldAnalogDown.setText("K");
        this.fieldAnalogDown.setToolTipText(Resource.get("putkey"));
        this.fieldAnalogDown.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldAnalogDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogDownMouseClicked(evt);
            }
        });
        this.fieldAnalogLeft.setEditable(false);
        this.fieldAnalogLeft.setHorizontalAlignment(0);
        this.fieldAnalogLeft.setText("J");
        this.fieldAnalogLeft.setToolTipText(Resource.get("putkey"));
        this.fieldAnalogLeft.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldAnalogLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogLeftMouseClicked(evt);
            }
        });
        this.fieldAnalogRight.setEditable(false);
        this.fieldAnalogRight.setHorizontalAlignment(0);
        this.fieldAnalogRight.setText("L");
        this.fieldAnalogRight.setToolTipText(Resource.get("putkey"));
        this.fieldAnalogRight.setBorder(new LineBorder(new Color(102, 102, 102), 2, true));
        this.fieldAnalogRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogRightMouseClicked(evt);
            }
        });
        GroupLayout fgPanelLayout = new GroupLayout(this.fgPanel);
        this.fgPanel.setLayout(fgPanelLayout);
        fgPanelLayout.setHorizontalGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldDown, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 484, Short.MAX_VALUE).addComponent(this.fieldCross, -2, 53, -2).addContainerGap()).addGroup(fgPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldLTrigger, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 484, Short.MAX_VALUE).addComponent(this.fieldRTrigger, -2, 53, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldLeft, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 484, Short.MAX_VALUE).addComponent(this.fieldCircle, -2, 53, -2).addContainerGap()).addGroup(fgPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldRight, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 484, Short.MAX_VALUE).addComponent(this.fieldSquare, -2, 53, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldUp, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 484, Short.MAX_VALUE).addComponent(this.fieldTriangle, -2, 53, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addContainerGap(547, Short.MAX_VALUE).addComponent(this.fieldHold, -2, 53, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(fgPanelLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.fieldAnalogUp, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 71, Short.MAX_VALUE).addComponent(this.fieldHome, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fieldVolPlus, -2, 53, -2).addGap(48, 48, 48)).addGroup(GroupLayout.Alignment.LEADING, fgPanelLayout.createSequentialGroup().addComponent(this.fieldAnalogLeft, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldAnalogRight, -2, 53, -2).addGap(76, 76, 76).addComponent(this.fieldVolMin, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.fieldMusic, -2, 53, -2).addGap(19, 19, 19).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(81, 81, 81).addComponent(this.fieldStart, -2, 53, -2)).addGroup(fgPanelLayout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.fieldSelect, -2, 53, -2)))).addGroup(fgPanelLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.fieldScreen, -2, 53, -2))).addGap(43, 43, 43)).addGroup(fgPanelLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.fieldAnalogDown, -2, 53, -2).addContainerGap(528, Short.MAX_VALUE)));
        fgPanelLayout.setVerticalGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(70, 70, 70).addComponent(this.fieldTriangle, -2, -1, -2).addGap(41, 41, 41).addComponent(this.fieldCross, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 91, Short.MAX_VALUE).addComponent(this.fieldMusic, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldScreen, -2, -1, -2).addGap(37, 37, 37)).addGroup(fgPanelLayout.createSequentialGroup().addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(fgPanelLayout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.fieldRight, -2, -1, -2)).addGroup(fgPanelLayout.createSequentialGroup().addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldLTrigger, -2, -1, -2).addComponent(this.fieldRTrigger, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fieldSquare, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGap(9, 9, 9).addComponent(this.fieldUp, -2, -1, -2).addGap(11, 11, 11).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldCircle, -2, -1, -2).addComponent(this.fieldLeft, -2, -1, -2)).addGap(24, 24, 24).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(95, 95, 95).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldAnalogUp, -2, -1, -2).addComponent(this.fieldVolPlus, -2, -1, -2).addComponent(this.fieldHome, -2, -1, -2))).addGroup(fgPanelLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.fieldHold, -2, -1, -2).addGap(18, 18, 18).addComponent(this.fieldStart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldSelect, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fieldAnalogRight, -2, -1, -2).addComponent(this.fieldAnalogLeft, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldAnalogDown, -2, -1, -2)).addComponent(this.fieldVolMin, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)).addGroup(fgPanelLayout.createSequentialGroup().addGap(126, 126, 126).addComponent(this.fieldDown, -2, -1, -2).addContainerGap(169, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.keyPanel.add((java.awt.Component)this.fgPanel, gridBagConstraints);
        this.bgLabel1.setHorizontalAlignment(0);
        this.bgLabel1.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/images/controls.jpg")));
        this.bgLabel1.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.keyPanel.add((java.awt.Component)this.bgLabel1, gridBagConstraints);
        this.controllerBox.setModel(this.makeControllerComboBoxModel());
        this.controllerLabel.setText("Controller:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(202, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.controllerLabel).addGap(10, 10, 10).addComponent(this.controllerBox, -2, 209, -2).addGap(98, 98, 98)).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING, -2, 88, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel, -2, 94, -2).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 35, Short.MAX_VALUE).addComponent(this.keyPanel, -2, 614, -2).addGap(0, 35, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.controllerBox, -2, -1, -2).addComponent(this.controllerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 343, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 45, Short.MAX_VALUE).addComponent(this.keyPanel, -2, -1, -2).addGap(0, 46, Short.MAX_VALUE))));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Settings.getInstance().writeKeys(this.currentKeys);
        Settings.getInstance().writeController(this.currentController);
        String controllerName = this.controllerBox.getSelectedItem().toString();
        Settings.getInstance().writeString("controller.controllerName", controllerName);
        int controllerNameIndex = 0;
        int selectedIndex = this.controllerBox.getSelectedIndex();
        for (int i = 0; i < this.controllerBox.getItemCount(); ++i) {
            if (!controllerName.equals(this.controllerBox.getItemAt(i).toString())) continue;
            if (i >= selectedIndex) break;
            ++controllerNameIndex;
        }
        Settings.getInstance().writeString("controller.controllerNameIndex", String.valueOf(controllerNameIndex));
        State.controller.setInputControllerIndex(this.controllerBox.getSelectedIndex());
        State.controller.loadKeyConfig(this.currentKeys);
        State.controller.loadControllerConfig(this.currentController);
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void fieldAnalogRightMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogRight, Controller.keyCode.ANRIGHT);
    }

    private void fieldAnalogLeftMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogLeft, Controller.keyCode.ANLEFT);
    }

    private void fieldAnalogDownMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogDown, Controller.keyCode.ANDOWN);
    }

    private void fieldAnalogUpMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogUp, Controller.keyCode.ANUP);
    }

    private void fieldMusicMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldMusic, Controller.keyCode.MUSIC);
    }

    private void fieldScreenMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldScreen, Controller.keyCode.SCREEN);
    }

    private void fieldRTriggerMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldRTrigger, Controller.keyCode.R1);
    }

    private void fieldLTriggerMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldLTrigger, Controller.keyCode.L1);
    }

    private void fieldVolPlusMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldVolPlus, Controller.keyCode.VOLPLUS);
    }

    private void fieldVolMinMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldVolMin, Controller.keyCode.VOLMIN);
    }

    private void fieldHomeMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldHome, Controller.keyCode.HOME);
    }

    private void fieldHoldMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldHold, Controller.keyCode.HOLD);
    }

    private void fieldDownMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldDown, Controller.keyCode.DOWN);
    }

    private void fieldLeftMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldLeft, Controller.keyCode.LEFT);
    }

    private void fieldUpMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldUp, Controller.keyCode.UP);
    }

    private void fieldRightMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldRight, Controller.keyCode.RIGHT);
    }

    private void fieldSquareMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldSquare, Controller.keyCode.SQUARE);
    }

    private void fieldTriangleMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldTriangle, Controller.keyCode.TRIANGLE);
    }

    private void fieldCircleMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldCircle, Controller.keyCode.CIRCLE);
    }

    private void fieldCrossMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldCross, Controller.keyCode.CROSS);
    }

    private void fieldSelectMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldSelect, Controller.keyCode.SELECT);
    }

    private void fieldStartMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldStart, Controller.keyCode.START);
    }

    private class ControllerPollThread
    extends Thread {
        protected volatile boolean exit = false;

        private ControllerPollThread() {
        }

        @Override
        public void run() {
            while (!this.exit) {
                net.java.games.input.Controller controller = ControlsGUI.this.getSelectedController();
                if (controller != null && controller.poll()) {
                    EventQueue eventQueue = controller.getEventQueue();
                    Event event = new Event();
                    while (eventQueue.getNextEvent(event)) {
                        ControlsGUI.this.onControllerEvent(event);
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

