/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.DisassemblerModule;

import com.jidesoft.list.StyledListCellRenderer;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Debugger.DisassemblerModule.VfpuFrame;
import jpcsp.Debugger.DisassemblerModule.ViewTooltips;
import jpcsp.Debugger.DumpDebugState;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.Resource;
import jpcsp.State;
import jpcsp.settings.Settings;
import jpcsp.util.JpcspDialogManager;
import jpcsp.util.OptionPaneMultiple;
import jpcsp.util.Utilities;

public class DisassemblerFrame
extends JFrame
implements ClipboardOwner {
    private static final long serialVersionUID = -8481807175706172292L;
    private int DebuggerPC;
    private int SelectedPC;
    private Emulator emu;
    private DefaultListModel listmodel = new DefaultListModel();
    private ArrayList<Integer> breakpoints = new ArrayList();
    private volatile boolean wantStep;
    protected int gpi;
    protected int gpo;
    private int selectedRegCount;
    private final Color[] selectedRegColors = new Color[]{new Color(128, 255, 255), new Color(255, 255, 128), new Color(128, 255, 128)};
    private String[] selectedRegNames = new String[this.selectedRegColors.length];
    private final Color selectedAddressColor = new Color(255, 128, 255);
    private String selectedAddress;
    private static boolean jideInitialized;
    private int srcounter;
    private JButton AddBreakpoint;
    private JMenuItem BranchOrJump;
    private JMenuItem CopyAddress;
    private JMenuItem CopyAll;
    private JMenuItem CopyValue;
    private JButton DeleteAllBreakpoints;
    private JButton DeleteBreakpoint;
    private JPopupMenu DisMenu;
    private JButton DumpCodeToText;
    private JButton ExportBreaks;
    private JButton ImportBreaks;
    private JButton JumpToAddress;
    private JButton PauseDebugger;
    private JPopupMenu RegMenu;
    private JButton ResetToPCbutton;
    private JToggleButton RunDebugger;
    private JTextField SearchField;
    private JMenuItem SetPCToCursor;
    private JButton StepInto;
    private JButton captureButton;
    private JTable cop0Table;
    private JTable cop1Table;
    private JList disasmList;
    private JTabbedPane disasmTabs;
    private JToolBar disasmToolbar;
    private JToolBar disasmToolbar2;
    private JButton dumpDebugStateButton;
    private JToggleButton gpiButton1;
    private JToggleButton gpiButton2;
    private JToggleButton gpiButton3;
    private JToggleButton gpiButton4;
    private JToggleButton gpiButton5;
    private JToggleButton gpiButton6;
    private JToggleButton gpiButton7;
    private JToggleButton gpiButton8;
    private JLabel gpioLabel;
    private JLabel gpoLabel1;
    private JLabel gpoLabel2;
    private JLabel gpoLabel3;
    private JLabel gpoLabel4;
    private JLabel gpoLabel5;
    private JLabel gpoLabel6;
    private JLabel gpoLabel7;
    private JLabel gpoLabel8;
    private JTable gprTable;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JPanel miscPanel;
    private JButton replayButton;

    public DisassemblerFrame(Emulator emu) {
        this.emu = emu;
        this.listmodel = new DefaultListModel();
        this.initComponents();
        ViewTooltips.register(this.disasmList);
        this.initJide();
        this.disasmList.setCellRenderer(new StyledListCellRenderer(){
            private static final long serialVersionUID = 3921020228217850610L;

            protected void customizeStyledLabel(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.customizeStyledLabel(list, value, index, isSelected, cellHasFocus);
                String text = this.getText();
                this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                this.setIcon(null);
                if (index == DisassemblerFrame.this.disasmListGetSelectedIndex()) {
                    this.setBackground(Color.LIGHT_GRAY);
                }
                DisassemblerFrame.this.customizeStyledLabel((StyledLabel)this, text);
            }
        });
        this.disasmList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String text;
                if (!e.getValueIsAdjusting() && (text = (String)DisassemblerFrame.this.disasmList.getSelectedValue()) != null) {
                    DisassemblerFrame.this.SelectedPC = DisassemblerFrame.this.DebuggerPC + DisassemblerFrame.this.disasmList.getSelectedIndex() * 4;
                    DisassemblerFrame.this.updateSelectedRegisters(text);
                    DisassemblerFrame.this.disasmList.clearSelection();
                    DisassemblerFrame.this.disasmList.repaint();
                }
            }
        });
        this.RefreshDebugger(true);
        this.wantStep = false;
    }

    private void initJide() {
        if (!jideInitialized) {
            LookAndFeelFactory.installJideExtension((int)0);
            jideInitialized = true;
        }
    }

    private void customizeStyledLabel(StyledLabel label, String text) {
        int find;
        if (text.startsWith("<*>")) {
            label.addStyleRange(new StyleRange(0, 3, 1, Color.RED));
        }
        if (text.contains(String.format("%08X:", Emulator.getProcessor().cpu.pc))) {
            int length = 32;
            if (length > text.length() - 3) {
                length = text.length() - 3;
            }
            label.addStyleRange(new StyleRange(3, length, 1, Color.BLACK));
            if (!text.startsWith("<*>")) {
                label.addStyleRange(new StyleRange(0, 3, 1, Color.BLACK, Color.YELLOW, 0));
            }
        }
        if (text.contains(" [")) {
            find = text.indexOf(" [");
            label.addStyleRange(new StyleRange(find, -1, 0, Color.BLUE));
        }
        if (text.contains("<=>")) {
            find = text.indexOf("<=>");
            label.addStyleRange(new StyleRange(find, -1, 0, Color.GRAY));
        }
        if (this.selectedAddress != null && text.contains("0x" + this.selectedAddress) && !text.contains("syscall")) {
            find = text.indexOf("0x" + this.selectedAddress);
            label.addStyleRange(new StyleRange(find, 10, 0, Color.BLACK, this.selectedAddressColor, 0));
        } else if (this.selectedAddress != null && text.contains(this.selectedAddress) && !text.contains("syscall")) {
            find = text.indexOf(this.selectedAddress);
            label.addStyleRange(new StyleRange(find, 8, 0, Color.BLACK, this.selectedAddressColor, 0));
        }
        int lastfind = 0;
        while ((lastfind = text.indexOf("$", lastfind)) != -1) {
            String regName = text.substring(lastfind);
            for (int i = 0; i < Common.gprNames.length; ++i) {
                if (!regName.startsWith(Common.gprNames[i])) continue;
                for (int j = 0; j < this.selectedRegCount; ++j) {
                    if (!regName.startsWith(this.selectedRegNames[j])) continue;
                    label.addStyleRange(new StyleRange(lastfind, 3, 0, Color.BLACK, this.selectedRegColors[j], 0));
                }
                break;
            }
            lastfind += 3;
        }
    }

    public void resetDebugger() {
        this.DeleteAllBreakpoints();
        this.RefreshDebugger(true);
    }

    public void SafeRefreshDebugger(final boolean moveToPC) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DisassemblerFrame.this.RefreshDebugger(moveToPC);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RefreshDebugger(boolean moveToPC) {
        int i;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (moveToPC) {
            this.DebuggerPC = cpu.pc;
        }
        ViewTooltips.unregister(this.disasmList);
        DefaultListModel defaultListModel = this.listmodel;
        synchronized (defaultListModel) {
            this.listmodel.clear();
            for (int pc = this.DebuggerPC; pc < this.DebuggerPC + 148; pc += 4) {
                if (Memory.isAddressGood(pc)) {
                    int opcode = Memory.getInstance().read32(pc);
                    Common.Instruction insn = Decoder.instruction(opcode);
                    String line = this.breakpoints.indexOf(pc) != -1 ? String.format("<*>%08X:[%08X]: %s", pc, opcode, insn.disasm(pc, opcode)) : (pc == cpu.pc ? String.format("-->%08X:[%08X]: %s", pc, opcode, insn.disasm(pc, opcode)) : String.format("   %08X:[%08X]: %s", pc, opcode, insn.disasm(pc, opcode)));
                    this.listmodel.addElement(line);
                    if (pc != this.SelectedPC) continue;
                    this.updateSelectedRegisters(line);
                    continue;
                }
                this.listmodel.addElement(String.format("   %08x: invalid address", pc));
            }
        }
        ViewTooltips.register(this.disasmList);
        this.gprTable.setValueAt(Integer.toHexString(cpu.pc), 0, 1);
        this.gprTable.setValueAt(Integer.toHexString(cpu.getHi()), 1, 1);
        this.gprTable.setValueAt(Integer.toHexString(cpu.getLo()), 2, 1);
        for (i = 0; i < 32; ++i) {
            this.gprTable.setValueAt(Integer.toHexString(cpu.gpr[i]), 3 + i, 1);
        }
        for (i = 0; i < 32; ++i) {
            this.cop1Table.setValueAt(Float.valueOf(cpu.fpr[i]), i, 1);
        }
        VfpuFrame.getInstance().updateRegisters(cpu);
    }

    private void updateSelectedRegisters(String text) {
        this.selectedAddress = null;
        int find = text.indexOf(" 0x");
        if (find != -1 && find + 11 <= text.length() && text.charAt(find + 7) != ' ') {
            this.selectedAddress = text.substring(find + 3, find + 3 + 8);
        }
        this.selectedRegCount = 0;
        int lastFind = 0;
        while ((lastFind = text.indexOf("$", lastFind)) != -1 && this.selectedRegCount < this.selectedRegColors.length) {
            String regName = text.substring(lastFind);
            for (int i = 0; i < Common.gprNames.length; ++i) {
                if (!regName.startsWith(Common.gprNames[i])) continue;
                boolean found = false;
                for (int j = 0; j < this.selectedRegCount && !found; ++j) {
                    found = regName.startsWith(this.selectedRegNames[j]);
                }
                if (found) break;
                this.selectedRegNames[this.selectedRegCount] = Common.gprNames[i];
                ++this.selectedRegCount;
                break;
            }
            lastFind += 3;
        }
    }

    private void initComponents() {
        this.DisMenu = new JPopupMenu();
        this.CopyAddress = new JMenuItem();
        this.CopyAll = new JMenuItem();
        this.BranchOrJump = new JMenuItem();
        this.SetPCToCursor = new JMenuItem();
        this.RegMenu = new JPopupMenu();
        this.CopyValue = new JMenuItem();
        this.disasmList = new JList(this.listmodel);
        this.disasmToolbar = new JToolBar();
        this.RunDebugger = new JToggleButton();
        this.PauseDebugger = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.StepInto = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.ResetToPCbutton = new JButton();
        this.JumpToAddress = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.DumpCodeToText = new JButton();
        this.disasmTabs = new JTabbedPane();
        this.gprTable = new JTable();
        this.cop0Table = new JTable();
        this.cop1Table = new JTable();
        this.miscPanel = new JPanel();
        this.gpiButton1 = new JToggleButton();
        this.gpiButton2 = new JToggleButton();
        this.gpiButton3 = new JToggleButton();
        this.gpiButton4 = new JToggleButton();
        this.gpiButton5 = new JToggleButton();
        this.gpiButton6 = new JToggleButton();
        this.gpiButton7 = new JToggleButton();
        this.gpiButton8 = new JToggleButton();
        this.gpoLabel1 = new JLabel();
        this.gpoLabel2 = new JLabel();
        this.gpoLabel3 = new JLabel();
        this.gpoLabel4 = new JLabel();
        this.gpoLabel5 = new JLabel();
        this.gpoLabel6 = new JLabel();
        this.gpoLabel7 = new JLabel();
        this.gpoLabel8 = new JLabel();
        this.gpioLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.captureButton = new JButton();
        this.replayButton = new JButton();
        this.jLabel2 = new JLabel();
        this.dumpDebugStateButton = new JButton();
        this.SearchField = new JTextField();
        this.jLabel3 = new JLabel();
        this.disasmToolbar2 = new JToolBar();
        this.AddBreakpoint = new JButton();
        this.DeleteBreakpoint = new JButton();
        this.DeleteAllBreakpoints = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.ExportBreaks = new JButton();
        this.ImportBreaks = new JButton();
        this.jSeparator5 = new JSeparator();
        this.jSeparator6 = new JSeparator();
        this.CopyAddress.setText("Copy Address");
        this.CopyAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.CopyAddressActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.CopyAddress);
        this.CopyAll.setText("Copy All");
        this.CopyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.CopyAllActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.CopyAll);
        this.BranchOrJump.setText("Copy Branch Or Jump address");
        this.BranchOrJump.setEnabled(false);
        this.BranchOrJump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.BranchOrJumpActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.BranchOrJump);
        this.SetPCToCursor.setText("Set PC to Cursor");
        this.SetPCToCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.SetPCToCursorActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.SetPCToCursor);
        this.CopyValue.setText("Copy value");
        this.CopyValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.CopyValueActionPerformed(evt);
            }
        });
        this.RegMenu.add(this.CopyValue);
        this.setTitle("Debugger");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent evt) {
                DisassemblerFrame.this.formWindowDeactivated(evt);
            }
        });
        this.disasmList.setFont(new Font("Courier New", 0, 11));
        this.disasmList.setSelectionMode(0);
        this.disasmList.setToolTipText("");
        this.disasmList.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                DisassemblerFrame.this.disasmListMouseWheelMoved(evt);
            }
        });
        this.disasmList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DisassemblerFrame.this.disasmListMouseClicked(evt);
            }
        });
        this.disasmList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DisassemblerFrame.this.disasmListKeyPressed(evt);
            }
        });
        this.disasmToolbar.setFloatable(false);
        this.disasmToolbar.setRollover(true);
        this.RunDebugger.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PlayIcon.png")));
        this.RunDebugger.setMnemonic('R');
        this.RunDebugger.setText(Resource.get("run"));
        this.RunDebugger.setFocusable(false);
        this.RunDebugger.setHorizontalTextPosition(4);
        this.RunDebugger.setIconTextGap(2);
        this.RunDebugger.setVerticalTextPosition(3);
        this.RunDebugger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.RunDebuggerActionPerformed(evt);
            }
        });
        this.disasmToolbar.add(this.RunDebugger);
        this.PauseDebugger.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PauseIcon.png")));
        this.PauseDebugger.setMnemonic('P');
        this.PauseDebugger.setText(Resource.get("pause"));
        this.PauseDebugger.setFocusable(false);
        this.PauseDebugger.setHorizontalTextPosition(4);
        this.PauseDebugger.setIconTextGap(2);
        this.PauseDebugger.setInheritsPopupMenu(true);
        this.PauseDebugger.setVerticalTextPosition(3);
        this.PauseDebugger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.PauseDebuggerActionPerformed(evt);
            }
        });
        this.disasmToolbar.add(this.PauseDebugger);
        this.disasmToolbar.add(this.jSeparator1);
        this.StepInto.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepIntoIcon.png")));
        this.StepInto.setText(Resource.get("stepinto"));
        this.StepInto.setFocusable(false);
        this.StepInto.setHorizontalTextPosition(4);
        this.StepInto.setIconTextGap(2);
        this.StepInto.setVerticalTextPosition(3);
        this.StepInto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.StepIntoActionPerformed(evt);
            }
        });
        this.disasmToolbar.add(this.StepInto);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepOverIcon.png")));
        this.jButton2.setText(Resource.get("stepover"));
        this.jButton2.setEnabled(false);
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(4);
        this.jButton2.setIconTextGap(2);
        this.jButton2.setVerticalTextPosition(3);
        this.disasmToolbar.add(this.jButton2);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepOutIcon.png")));
        this.jButton3.setText(Resource.get("stepout"));
        this.jButton3.setEnabled(false);
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(4);
        this.jButton3.setIconTextGap(2);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.disasmToolbar.add(this.jButton3);
        this.disasmToolbar.add(this.jSeparator2);
        this.ResetToPCbutton.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/ResetToPc.png")));
        this.ResetToPCbutton.setMnemonic('P');
        this.ResetToPCbutton.setText(Resource.get("resettopc"));
        this.ResetToPCbutton.setFocusable(false);
        this.ResetToPCbutton.setHorizontalTextPosition(4);
        this.ResetToPCbutton.setIconTextGap(2);
        this.ResetToPCbutton.setVerticalTextPosition(3);
        this.ResetToPCbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ResetToPCbuttonActionPerformed(evt);
            }
        });
        this.disasmToolbar.add(this.ResetToPCbutton);
        this.JumpToAddress.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/JumpTo.png")));
        this.JumpToAddress.setMnemonic('J');
        this.JumpToAddress.setText(Resource.get("jumpto"));
        this.JumpToAddress.setFocusable(false);
        this.JumpToAddress.setHorizontalTextPosition(4);
        this.JumpToAddress.setIconTextGap(2);
        this.JumpToAddress.setVerticalTextPosition(3);
        this.JumpToAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.JumpToAddressActionPerformed(evt);
            }
        });
        this.disasmToolbar.add(this.JumpToAddress);
        this.disasmToolbar.add(this.jSeparator4);
        this.DumpCodeToText.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/Dump.png")));
        this.DumpCodeToText.setMnemonic('W');
        this.DumpCodeToText.setText(Resource.get("dumpcode"));
        this.DumpCodeToText.setFocusable(false);
        this.DumpCodeToText.setHorizontalTextPosition(4);
        this.DumpCodeToText.setIconTextGap(2);
        this.DumpCodeToText.setVerticalTextPosition(3);
        this.DumpCodeToText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DumpCodeToTextActionPerformed(evt);
            }
        });
        this.disasmToolbar.add(this.DumpCodeToText);
        this.gprTable.setModel(new DefaultTableModel(new Object[][]{{"PC", ""}, {"HI", null}, {"LO", null}, {"zr", null}, {"at", null}, {"v0", null}, {"v1", null}, {"a0", null}, {"a1", null}, {"a2", null}, {"a3", null}, {"t0", null}, {"t1", null}, {"t2", null}, {"t3", null}, {"t4", null}, {"t5", null}, {"t6", null}, {"t7", null}, {"s0", null}, {"s1", null}, {"s2", null}, {"s3", null}, {"s4", null}, {"s5", null}, {"s6", null}, {"s7", null}, {"t8", null}, {"t9", null}, {"k0", null}, {"k1", null}, {"gp", null}, {"sp", null}, {"fp", null}, {"ra", null}}, new String[]{"REG", "HEX"}){
            private static final long serialVersionUID = 4714824805211201111L;
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.gprTable.setColumnSelectionAllowed(true);
        this.gprTable.getTableHeader().setReorderingAllowed(false);
        this.gprTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DisassemblerFrame.this.gprTableMouseClicked(evt);
            }
        });
        this.disasmTabs.addTab("GPR", this.gprTable);
        this.cop0Table.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"REG", "HEX"}){
            private static final long serialVersionUID = 1080691380828614427L;
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.disasmTabs.addTab("COP0", this.cop0Table);
        this.cop1Table.setModel(new DefaultTableModel(new Object[][]{{"FPR0", null}, {"FPR1", null}, {"FPR2", null}, {"FPR3", null}, {"FPR4", null}, {"FPR5", null}, {"FPR6", null}, {"FPR7", null}, {"FPR8", null}, {"FPR9", null}, {"FPR10", null}, {"FPR11", null}, {"FPR12", null}, {"FPR13", null}, {"FPR14", null}, {"FPR15", null}, {"FPR16", null}, {"FPR17", null}, {"FPR18", null}, {"FPR19", null}, {"FPR20", null}, {"FPR21", null}, {"FPR22", null}, {"FPR23", null}, {"FPR24", null}, {"FPR25", null}, {"FPR26", null}, {"FPR27", null}, {"FPR28", null}, {"FPR29", null}, {"FPR30", null}, {"FPR31", null}}, new String[]{"REG", "FLOAT"}){
            private static final long serialVersionUID = -5902668243370431997L;
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Float.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.cop1Table.setColumnSelectionAllowed(true);
        this.cop1Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DisassemblerFrame.this.cop1TableMouseClicked(evt);
            }
        });
        this.disasmTabs.addTab("COP1", this.cop1Table);
        this.gpiButton1.setText("1");
        this.gpiButton1.setBorder(null);
        this.gpiButton1.setPreferredSize(new Dimension(16, 16));
        this.gpiButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton1ActionPerformed(evt);
            }
        });
        this.gpiButton2.setText("2");
        this.gpiButton2.setBorder(null);
        this.gpiButton2.setPreferredSize(new Dimension(16, 16));
        this.gpiButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton2ActionPerformed(evt);
            }
        });
        this.gpiButton3.setText("3");
        this.gpiButton3.setBorder(null);
        this.gpiButton3.setPreferredSize(new Dimension(16, 16));
        this.gpiButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton3ActionPerformed(evt);
            }
        });
        this.gpiButton4.setText("4");
        this.gpiButton4.setBorder(null);
        this.gpiButton4.setPreferredSize(new Dimension(16, 16));
        this.gpiButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton4ActionPerformed(evt);
            }
        });
        this.gpiButton5.setText("5");
        this.gpiButton5.setBorder(null);
        this.gpiButton5.setPreferredSize(new Dimension(16, 16));
        this.gpiButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton5ActionPerformed(evt);
            }
        });
        this.gpiButton6.setText("6");
        this.gpiButton6.setBorder(null);
        this.gpiButton6.setPreferredSize(new Dimension(16, 16));
        this.gpiButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton6ActionPerformed(evt);
            }
        });
        this.gpiButton7.setText("7");
        this.gpiButton7.setBorder(null);
        this.gpiButton7.setPreferredSize(new Dimension(16, 16));
        this.gpiButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton7ActionPerformed(evt);
            }
        });
        this.gpiButton8.setText("8");
        this.gpiButton8.setBorder(null);
        this.gpiButton8.setPreferredSize(new Dimension(16, 16));
        this.gpiButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton8ActionPerformed(evt);
            }
        });
        this.gpoLabel1.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel1.setEnabled(false);
        this.gpoLabel2.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel2.setEnabled(false);
        this.gpoLabel3.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel3.setEnabled(false);
        this.gpoLabel4.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel4.setEnabled(false);
        this.gpoLabel5.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel5.setEnabled(false);
        this.gpoLabel6.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel6.setEnabled(false);
        this.gpoLabel7.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel7.setEnabled(false);
        this.gpoLabel8.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel8.setEnabled(false);
        this.gpioLabel.setText("GPI/GPO");
        this.jLabel1.setText("GE Capture/Replay");
        this.captureButton.setText(Resource.get("capturenextframe"));
        this.captureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.captureButtonActionPerformed(evt);
            }
        });
        this.replayButton.setText(Resource.get("replaycapturenextframe"));
        this.replayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.replayButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText(Resource.get("dumpdebugstate"));
        this.dumpDebugStateButton.setText(Resource.get("dumptoconsole"));
        this.dumpDebugStateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.dumpDebugStateButtonActionPerformed(evt);
            }
        });
        this.SearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.SearchFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setText(Resource.get("search"));
        GroupLayout miscPanelLayout = new GroupLayout(this.miscPanel);
        this.miscPanel.setLayout(miscPanelLayout);
        miscPanelLayout.setHorizontalGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscPanelLayout.createSequentialGroup().addContainerGap().addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.SearchField, -1, 229, Short.MAX_VALUE).addContainerGap()).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addContainerGap()).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.gpioLabel).addContainerGap(197, Short.MAX_VALUE)).addGroup(miscPanelLayout.createSequentialGroup().addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpoLabel1).addComponent(this.gpiButton1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton2, -2, -1, -2).addComponent(this.gpoLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton3, -2, -1, -2).addComponent(this.gpoLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton4, -2, -1, -2).addComponent(this.gpoLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton5, -2, -1, -2).addComponent(this.gpoLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton6, -2, -1, -2).addComponent(this.gpoLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton7, -2, -1, -2).addComponent(this.gpoLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpoLabel8).addComponent(this.gpiButton8, -2, -1, -2)).addGap(46, 46, 46)).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(147, Short.MAX_VALUE)).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap(173, Short.MAX_VALUE)).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.dumpDebugStateButton).addContainerGap(140, Short.MAX_VALUE)).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.captureButton).addContainerGap(140, Short.MAX_VALUE)).addGroup(miscPanelLayout.createSequentialGroup().addComponent(this.replayButton).addContainerGap(140, Short.MAX_VALUE)))));
        miscPanelLayout.setVerticalGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.gpioLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscPanelLayout.createSequentialGroup().addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpoLabel1).addComponent(this.gpoLabel2).addComponent(this.gpoLabel3).addComponent(this.gpoLabel4).addComponent(this.gpoLabel5).addComponent(this.gpoLabel6).addComponent(this.gpoLabel7)).addGap(11, 11, 11).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gpiButton1, -2, -1, -2).addComponent(this.gpiButton2, -2, -1, -2).addComponent(this.gpiButton3, -2, -1, -2).addComponent(this.gpiButton4, -2, -1, -2).addComponent(this.gpiButton5, -2, -1, -2).addComponent(this.gpiButton6, -2, -1, -2).addComponent(this.gpiButton7, -2, -1, -2).addComponent(this.gpiButton8, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.captureButton)).addComponent(this.gpoLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replayButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dumpDebugStateButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3, -2, 11, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SearchField, -2, -1, -2).addContainerGap(300, Short.MAX_VALUE)));
        this.disasmTabs.addTab("Misc", this.miscPanel);
        this.disasmToolbar2.setFloatable(false);
        this.disasmToolbar2.setRollover(true);
        this.AddBreakpoint.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/NewBreakpointIcon.png")));
        this.AddBreakpoint.setMnemonic('A');
        this.AddBreakpoint.setText(Resource.get("addbreak"));
        this.AddBreakpoint.setFocusable(false);
        this.AddBreakpoint.setHorizontalTextPosition(4);
        this.AddBreakpoint.setIconTextGap(2);
        this.AddBreakpoint.setVerticalTextPosition(3);
        this.AddBreakpoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.AddBreakpointActionPerformed(evt);
            }
        });
        this.disasmToolbar2.add(this.AddBreakpoint);
        this.DeleteBreakpoint.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/DeleteBreakpointIcon.png")));
        this.DeleteBreakpoint.setMnemonic('D');
        this.DeleteBreakpoint.setText(Resource.get("deletebreak"));
        this.DeleteBreakpoint.setFocusable(false);
        this.DeleteBreakpoint.setHorizontalTextPosition(4);
        this.DeleteBreakpoint.setIconTextGap(2);
        this.DeleteBreakpoint.setInheritsPopupMenu(true);
        this.DeleteBreakpoint.setVerticalTextPosition(3);
        this.DeleteBreakpoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DeleteBreakpointActionPerformed(evt);
            }
        });
        this.disasmToolbar2.add(this.DeleteBreakpoint);
        this.DeleteAllBreakpoints.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/DeleteAllBreakpointsIcon.png")));
        this.DeleteAllBreakpoints.setMnemonic('E');
        this.DeleteAllBreakpoints.setText(Resource.get("deleteall"));
        this.DeleteAllBreakpoints.setFocusable(false);
        this.DeleteAllBreakpoints.setHorizontalTextPosition(4);
        this.DeleteAllBreakpoints.setIconTextGap(2);
        this.DeleteAllBreakpoints.setVerticalTextPosition(3);
        this.DeleteAllBreakpoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DeleteAllBreakpointsActionPerformed(evt);
            }
        });
        this.disasmToolbar2.add(this.DeleteAllBreakpoints);
        this.disasmToolbar2.add(this.jSeparator3);
        this.ExportBreaks.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/SaveStateIcon.png")));
        this.ExportBreaks.setText("Export Breaks");
        this.ExportBreaks.setFocusable(false);
        this.ExportBreaks.setHorizontalTextPosition(4);
        this.ExportBreaks.setVerticalTextPosition(3);
        this.ExportBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ExportBreaksActionPerformed(evt);
            }
        });
        this.disasmToolbar2.add(this.ExportBreaks);
        this.ImportBreaks.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/LoadStateIcon.png")));
        this.ImportBreaks.setText("Import Breaks");
        this.ImportBreaks.setFocusable(false);
        this.ImportBreaks.setHorizontalTextPosition(4);
        this.ImportBreaks.setVerticalTextPosition(3);
        this.ImportBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ImportBreaksActionPerformed(evt);
            }
        });
        this.disasmToolbar2.add(this.ImportBreaks);
        this.jSeparator5.setForeground(new Color(0, 0, 0));
        this.jSeparator6.setForeground(new Color(0, 0, 0));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disasmToolbar, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.disasmList, -2, 503, -2).addGap(18, 18, 18).addComponent(this.disasmTabs, -2, 254, -2))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.disasmToolbar2, -1, 469, Short.MAX_VALUE).addGap(326, 326, 326)).addComponent(this.jSeparator5, -1, 795, Short.MAX_VALUE).addComponent(this.jSeparator6, -1, 795, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.disasmToolbar, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disasmToolbar2, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator6, -2, 1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5, -2, 2, -2).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disasmTabs, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.disasmList, -1, 588, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void disasmListKeyPressed(KeyEvent evt) {
        int keyCode2 = evt.getKeyCode();
        switch (keyCode2) {
            case 40: {
                this.DebuggerPC += 4;
                this.RefreshDebugger(false);
                this.updateSelectedIndex();
                evt.consume();
                break;
            }
            case 38: {
                this.DebuggerPC -= 4;
                this.RefreshDebugger(false);
                this.updateSelectedIndex();
                evt.consume();
                break;
            }
            case 33: {
                this.DebuggerPC -= 148;
                this.RefreshDebugger(false);
                this.updateSelectedIndex();
                evt.consume();
                break;
            }
            case 34: {
                this.DebuggerPC += 148;
                this.RefreshDebugger(false);
                this.updateSelectedIndex();
                evt.consume();
            }
        }
    }

    private void disasmListMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            this.DebuggerPC -= 4;
            this.RefreshDebugger(false);
            this.updateSelectedIndex();
            evt.consume();
        } else {
            this.DebuggerPC += 4;
            this.RefreshDebugger(false);
            this.updateSelectedIndex();
            evt.consume();
        }
    }

    private void updateSelectedIndex() {
        if (this.SelectedPC >= this.DebuggerPC && this.SelectedPC < this.DebuggerPC + 148) {
            this.disasmList.setSelectedIndex((this.SelectedPC - this.DebuggerPC) / 4);
        }
    }

    private int disasmListGetSelectedIndex() {
        return (this.SelectedPC - this.DebuggerPC) / 4;
    }

    private Object disasmListGetSelectedValue() {
        return this.disasmList.getModel().getElementAt(this.disasmListGetSelectedIndex());
    }

    private void ResetToPCbuttonActionPerformed(ActionEvent evt) {
        this.RefreshDebugger(true);
    }

    private void JumpToAddressActionPerformed(ActionEvent evt) {
        String input = (String)JOptionPane.showInputDialog(this, Resource.get("entertojump"), "Jpcsp", 3, null, null, String.format("%08x", Emulator.getProcessor().cpu.pc));
        if (input == null) {
            return;
        }
        int value = 0;
        try {
            value = Utilities.parseAddress(input);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        this.DebuggerPC = value;
        this.RefreshDebugger(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void DumpCodeToTextActionPerformed(ActionEvent evt) {
        OptionPaneMultiple opt = new OptionPaneMultiple(this, Integer.toHexString(this.DebuggerPC), Integer.toHexString(this.DebuggerPC + 148));
        if (opt.completed()) {
            Emulator.log.debug((Object)("Start address: " + opt.getInput()[0]));
            Emulator.log.debug((Object)("End address: " + opt.getInput()[1]));
            Emulator.log.debug((Object)("File name: " + opt.getInput()[2]));
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(opt.getInput()[2]));
                bufferedWriter.write("-------JPCSP DISASM-----------");
                bufferedWriter.newLine();
                int Start2 = Utilities.parseAddress(opt.getInput()[0]);
                int End2 = Utilities.parseAddress(opt.getInput()[1]);
                for (int i = Start2; i <= End2; i += 4) {
                    if (Memory.isAddressGood(i)) {
                        int opcode = Memory.getInstance().read32(i);
                        Common.Instruction insn = Decoder.instruction(opcode);
                        bufferedWriter.write(String.format("%08X:[%08X]: %s", i, opcode, insn.disasm(i, opcode)));
                    } else {
                        bufferedWriter.write(String.format("%08X: invalid address", i));
                    }
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                Utilities.close(bufferedWriter);
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        Utilities.close(bufferedWriter);
                        throw throwable;
                    }
                }
                Utilities.close(bufferedWriter);
            }
            Utilities.close(bufferedWriter);
        }
        opt = null;
    }

    private void CopyAddressActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        String address = value.substring(3, 11);
        StringSelection stringSelection = new StringSelection(address);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private void CopyAllActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        StringSelection stringSelection = new StringSelection(value);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private void BranchOrJumpActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        int address = value.indexOf("0x");
        if (address == -1) {
            JpcspDialogManager.showError(this, "Can't find the jump or branch address");
            return;
        }
        String add = value.substring(address + 2, value.length());
        int addressend = add.indexOf(" ");
        if (addressend != -1) {
            add = add.substring(0, addressend);
        }
        StringSelection stringSelection = new StringSelection(add);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    @Override
    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    private void disasmListMouseClicked(MouseEvent evt) {
        this.BranchOrJump.setEnabled(false);
        this.SetPCToCursor.setEnabled(false);
        if (SwingUtilities.isRightMouseButton(evt) && this.disasmList.locationToIndex(evt.getPoint()) == this.disasmListGetSelectedIndex()) {
            int addr;
            int finddot;
            String line = (String)this.disasmListGetSelectedValue();
            String opcode = line.substring((finddot = line.indexOf("]:")) + 3, line.length());
            if (opcode.startsWith("b") || opcode.startsWith("j")) {
                this.BranchOrJump.setEnabled(true);
            }
            if (Memory.isAddressGood(addr = this.DebuggerPC + this.disasmListGetSelectedIndex() * 4)) {
                this.SetPCToCursor.setEnabled(true);
            }
            this.DisMenu.show(this.disasmList, evt.getX(), evt.getY());
        }
    }

    private void AddBreakpointActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        if (value != null) {
            try {
                String address = value.substring(3, 11);
                int addr = Utilities.parseAddress(address);
                if (!this.breakpoints.contains(addr)) {
                    this.breakpoints.add(addr);
                }
                this.RefreshDebugger(false);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            JpcspDialogManager.showInformation(this, "Breakpoint Help : Select the line to add a breakpoint to.");
        }
    }

    private void DeleteAllBreakpointsActionPerformed(ActionEvent evt) {
        this.DeleteAllBreakpoints();
        this.RefreshDebugger(false);
    }

    public void DeleteAllBreakpoints() {
        if (!this.breakpoints.isEmpty()) {
            this.breakpoints.clear();
        }
    }

    private void DeleteBreakpointActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        if (value != null) {
            boolean breakpointexists = value.startsWith("<*>");
            if (breakpointexists) {
                String address = value.substring(3, 11);
                int addr = Utilities.parseAddress(address);
                int b = this.breakpoints.indexOf(addr);
                this.breakpoints.remove(b);
                this.RefreshDebugger(false);
            }
        } else {
            JpcspDialogManager.showInformation(this, "Breakpoint Help : Select the line to remove a breakpoint from.");
        }
    }

    private void StepIntoActionPerformed(ActionEvent evt) {
        this.wantStep = true;
        this.emu.RunEmu();
    }

    private void RunDebuggerActionPerformed(ActionEvent evt) {
        this.emu.RunEmu();
    }

    public void step() {
        if (this.wantStep || !this.breakpoints.isEmpty() && this.breakpoints.indexOf(Emulator.getProcessor().cpu.pc) != -1) {
            this.wantStep = false;
            Emulator.PauseEmuWithStatus(16);
        }
    }

    private void PauseDebuggerActionPerformed(ActionEvent evt) {
        Emulator.PauseEmuWithStatus(64);
    }

    public void RefreshButtons() {
        this.RunDebugger.setSelected(Emulator.run && !Emulator.pause);
        this.PauseDebugger.setSelected(Emulator.run && Emulator.pause);
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (Settings.getInstance().readBool("gui.saveWindowPos")) {
            Settings.getInstance().writeWindowPos("disassembler", this.getLocation());
        }
    }

    private boolean isCellChecked(JTable table) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (!table.isCellSelected(i, 1)) continue;
            return true;
        }
        return false;
    }

    private void cop1TableMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt) && this.cop1Table.isColumnSelected(1) && this.isCellChecked(this.cop1Table)) {
            this.RegMenu.show(this.cop1Table, evt.getX(), evt.getY());
        }
    }

    private void CopyValueActionPerformed(ActionEvent evt) {
        if (this.cop1Table.isShowing()) {
            float value = ((Float)this.cop1Table.getValueAt(this.cop1Table.getSelectedRow(), 1)).floatValue();
            StringSelection stringSelection = new StringSelection(Float.toString(value));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, this);
        } else if (this.gprTable.isShowing()) {
            String value = (String)this.gprTable.getValueAt(this.gprTable.getSelectedRow(), 1);
            StringSelection stringSelection = new StringSelection(value);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, this);
        }
    }

    private void gprTableMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt) && this.gprTable.isColumnSelected(1) && this.isCellChecked(this.gprTable)) {
            this.RegMenu.show(this.gprTable, evt.getX(), evt.getY());
        }
    }

    public int GetGPI() {
        return this.gpi;
    }

    public void SetGPO(int gpo) {
        this.gpo = gpo;
        for (int i = 0; i < 8; ++i) {
            this.SetGPO(i, (gpo & 1 << i) != 0);
        }
    }

    private void ToggleGPI(int index) {
        this.gpi ^= 1 << index;
        for (int i = 0; i < 8; ++i) {
            this.SetGPI(i, (this.gpi & 1 << i) != 0);
        }
    }

    private void SetGPO(int index, boolean on) {
        switch (index) {
            case 0: {
                this.gpoLabel1.setEnabled(on);
                break;
            }
            case 1: {
                this.gpoLabel2.setEnabled(on);
                break;
            }
            case 2: {
                this.gpoLabel3.setEnabled(on);
                break;
            }
            case 3: {
                this.gpoLabel4.setEnabled(on);
                break;
            }
            case 4: {
                this.gpoLabel5.setEnabled(on);
                break;
            }
            case 5: {
                this.gpoLabel6.setEnabled(on);
                break;
            }
            case 6: {
                this.gpoLabel7.setEnabled(on);
                break;
            }
            case 7: {
                this.gpoLabel8.setEnabled(on);
            }
        }
    }

    private void SetGPI(int index, boolean on) {
        switch (index) {
            case 0: {
                this.gpiButton1.setSelected(on);
                break;
            }
            case 1: {
                this.gpiButton2.setSelected(on);
                break;
            }
            case 2: {
                this.gpiButton3.setSelected(on);
                break;
            }
            case 3: {
                this.gpiButton4.setSelected(on);
                break;
            }
            case 4: {
                this.gpiButton5.setSelected(on);
                break;
            }
            case 5: {
                this.gpiButton6.setSelected(on);
                break;
            }
            case 6: {
                this.gpiButton7.setSelected(on);
                break;
            }
            case 7: {
                this.gpiButton8.setSelected(on);
            }
        }
    }

    private void gpiButton1ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(0);
    }

    private void gpiButton2ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(1);
    }

    private void gpiButton3ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(2);
    }

    private void gpiButton4ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(3);
    }

    private void gpiButton5ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(4);
    }

    private void gpiButton6ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(5);
    }

    private void gpiButton7ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(6);
    }

    private void gpiButton8ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(7);
    }

    private void SetPCToCursorActionPerformed(ActionEvent evt) {
        int index = this.disasmListGetSelectedIndex();
        if (index != -1) {
            Emulator.getProcessor().cpu.pc = this.DebuggerPC + index * 4;
            this.RefreshDebugger(true);
        } else {
            System.out.println("dpc: " + Integer.toHexString(this.DebuggerPC));
            System.out.println("idx: " + Integer.toHexString(index));
            System.out.println("npc: " + Integer.toHexString(this.DebuggerPC + index * 4));
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
    }

    private void captureButtonActionPerformed(ActionEvent evt) {
        State.captureGeNextFrame = true;
    }

    private void replayButtonActionPerformed(ActionEvent evt) {
        State.replayGeNextFrame = true;
    }

    private void dumpDebugStateButtonActionPerformed(ActionEvent evt) {
        DumpDebugState.dumpDebugState();
    }

    private void SearchFieldActionPerformed(ActionEvent evt) {
        String text = this.SearchField.getText();
        String current = "";
        this.disasmList.setSelectedIndex(this.srcounter);
        while (!current.contains(text)) {
            this.DebuggerPC += 4;
            this.SelectedPC = this.DebuggerPC;
            this.RefreshDebugger(false);
            this.updateSelectedIndex();
            current = (String)this.disasmListGetSelectedValue();
            ++this.srcounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ExportBreaksActionPerformed(ActionEvent evt) {
        BufferedWriter out;
        File f;
        block7: {
            int res;
            JFileChooser fc = new JFileChooser();
            fc.setSelectedFile(new File(State.discId + ".brk"));
            fc.setDialogTitle("Export breakpoints");
            fc.setCurrentDirectory(new File("."));
            int returnVal = fc.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            f = fc.getSelectedFile();
            out = null;
            if (!f.exists() || (res = JOptionPane.showConfirmDialog(this, "File '" + f.getName() + "' already exists! Do you want to override?", "Export breakpoints", 0, 2)) == 0) break block7;
            Utilities.close(out);
            return;
        }
        try {
            out = new BufferedWriter(new FileWriter(f));
            for (int i = 0; i < this.breakpoints.size(); ++i) {
                out.write(Integer.toHexString(this.breakpoints.get(i)) + System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                Utilities.close(out);
                throw throwable;
            }
            Utilities.close(out);
        }
        Utilities.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ImportBreaksActionPerformed(ActionEvent evt) {
        BufferedReader in;
        File f;
        block7: {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Import breakpoints");
            fc.setCurrentDirectory(new File("."));
            int returnVal = fc.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            f = fc.getSelectedFile();
            in = null;
            if (f.getName().contains(".brk")) break block7;
            JOptionPane.showMessageDialog(this, "File '" + f.getName() + "' is not a valid .brk file!", "Import breakpoints", 0);
            Utilities.close(in);
            return;
        }
        try {
            in = new BufferedReader(new FileReader(f));
            String nextBrk = in.readLine();
            while (nextBrk != null) {
                this.breakpoints.add(Integer.parseInt(nextBrk, 16));
                nextBrk = in.readLine();
            }
            this.RefreshDebugger(true);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                Utilities.close(in);
                throw throwable;
            }
            Utilities.close(in);
        }
        Utilities.close(in);
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

