/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.grapeshot.halfnes;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

/**
 *
 * @author Andrew
 */
public abstract class Renderer {
    public abstract BufferedImage render(int[] nespixels, int[] bgcolors, boolean dotcrawl); 
    
    
    public static BufferedImage getImageFromArray(final int[] bitmap, final int offset, final int width, final int height) {
        final BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB_PRE);
        final WritableRaster raster = image.getRaster();
        final int[] pixels = ((DataBufferInt) raster.getDataBuffer()).getData();
        System.arraycopy(bitmap, offset, pixels, 0, width * height);
        return image;
    }
}
