/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class UnromMapper
extends Mapper {
    private int bank = 0;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        this.bank = data & 0xF;
        for (int i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * (i + 16 * this.bank) & this.prgsize - 1;
        }
    }
}

