/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper92
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[16 + i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        int i;
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if ((data & 0x40) != 0) {
            for (i = 0; i < 8; ++i) {
                this.chr_map[i] = 1024 * (i + 8 * (data & 0xF)) & this.chrsize - 1;
            }
        }
        if ((data & 0x80) != 0) {
            for (i = 0; i < 16; ++i) {
                this.prg_map[16 + i] = 1024 * (i + 16 * (data & 0xF)) & this.prgsize - 1;
            }
        }
    }
}

