/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper86
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr >= 24576 && addr <= 28671) {
            int i;
            int prgselect = data >> 4 & 3;
            int chrselect = data & 3 | (data & 0x40) >> 4;
            for (i = 0; i < 8; ++i) {
                this.chr_map[i] = 1024 * (i + 8 * chrselect) & this.chrsize - 1;
            }
            for (i = 0; i < 32; ++i) {
                this.prg_map[i] = 1024 * (i + 32 * prgselect) & this.prgsize - 1;
            }
        } else if (addr >= 28672 && addr <= Short.MAX_VALUE) {
            if ((data & 0x30) != 32) {
                return;
            }
            switch (data & 0x1F) {
                case 0: {
                    System.out.println("\"Strike!\"");
                    break;
                }
                case 1: {
                    System.out.println("\"Ball!\"");
                    break;
                }
                case 2: {
                    System.out.println("\"Time!\"");
                    break;
                }
                case 3: {
                    System.out.println("\"Out!\"");
                    break;
                }
                case 4: {
                    System.out.println("\"Safe!\"");
                    break;
                }
                case 5: {
                    System.out.println("\"Foul!\"");
                    break;
                }
                case 6: {
                    System.out.println("\"Fair!\"");
                    break;
                }
                case 7: {
                    System.out.println("\"You're out!\"");
                    break;
                }
                case 8: {
                    System.out.println("\"Play ball!\"");
                    break;
                }
                case 9: {
                    System.out.println("\"Ball 4!\"");
                    break;
                }
                case 10: {
                    System.out.println("\"Home run!\"");
                    break;
                }
                case 11: {
                    System.out.println("\"New pitcher\"");
                    break;
                }
                case 12: {
                    System.out.println("\"Ouch!\"");
                    break;
                }
                case 13: {
                    System.out.println("\"Dummy!\"");
                    break;
                }
                case 14: {
                    System.out.println("*crack*");
                    break;
                }
                case 15: {
                    System.out.println("*cheer*");
                }
            }
        }
    }
}

