/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper76
extends Mapper {
    private int whichbank = 0;
    private int[] chrreg = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 0;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr == 32769) {
            if (this.whichbank <= 5) {
                this.chrreg[this.whichbank] = data;
                this.setupchr();
            } else if (this.whichbank == 6) {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[i] = 1024 * (i + data * 8) % this.prgsize;
                }
            } else if (this.whichbank == 7) {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[i + 8] = 1024 * (i + data * 8) % this.prgsize;
                }
            }
        } else if (addr == 32768) {
            this.whichbank = data & 7;
        }
    }

    private void setupchr() {
        this.setppubank(2, 0, this.chrreg[2] << 1);
        this.setppubank(2, 2, this.chrreg[3] << 1);
        this.setppubank(2, 4, this.chrreg[4] << 1);
        this.setppubank(2, 6, this.chrreg[5] << 1);
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) & this.chrsize - 1;
        }
    }
}

