/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class Mapper61
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public void reset() {
        this.cartWrite(32768, this.cartRead(32768));
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        switch (addr & 0x30) {
            case 0: 
            case 48: {
                for (int i = 0; i < 32; ++i) {
                    this.prg_map[i] = 1024 * (i + 32 * (addr & 0xF)) & this.prgsize - 1;
                }
                break;
            }
            case 16: 
            case 32: {
                int i;
                int prgselect = addr << 1 & 0x1E | addr >> 4 & 2;
                for (i = 0; i < 16; ++i) {
                    this.prg_map[i] = 1024 * (i + 32 * prgselect) & this.prgsize - 1;
                }
                for (i = 0; i < 16; ++i) {
                    this.prg_map[i + 16] = 1024 * (i + 32 * prgselect) & this.prgsize - 1;
                }
                break;
            }
        }
        this.setmirroring(utils.getbit(addr, 7) ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
    }
}

