/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper255
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        int i;
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        int mode = ~addr >> 12 & 1;
        int bank = addr >> 8 & 0x40 | addr >> 6 & 0x3F;
        this.setmirroring((addr & 0x2000) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * (i + 8 * (addr >> 8 & 0x40 | addr & 0x3F)) & this.chrsize - 1;
        }
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * (i + 16 * (bank & ~mode)) & this.prgsize - 1;
        }
        for (i = 0; i < 16; ++i) {
            this.prg_map[16 + i] = 1024 * (i + 16 * (bank | mode)) & this.prgsize - 1;
        }
    }
}

