/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.CPU;
import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.ROMLoader;
import com.grapeshot.halfnes.mappers.Action52Mapper;
import com.grapeshot.halfnes.mappers.AfterburnerMapper;
import com.grapeshot.halfnes.mappers.AnromMapper;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.BnromMapper;
import com.grapeshot.halfnes.mappers.CaltronMapper;
import com.grapeshot.halfnes.mappers.CnromMapper;
import com.grapeshot.halfnes.mappers.CodemastersMapper;
import com.grapeshot.halfnes.mappers.ColorDreamsMapper;
import com.grapeshot.halfnes.mappers.CrazyClimberMapper;
import com.grapeshot.halfnes.mappers.CrimeBustersMapper;
import com.grapeshot.halfnes.mappers.FME7Mapper;
import com.grapeshot.halfnes.mappers.GnromMapper;
import com.grapeshot.halfnes.mappers.IremH3001Mapper;
import com.grapeshot.halfnes.mappers.MIMICMapper;
import com.grapeshot.halfnes.mappers.MMC1Mapper;
import com.grapeshot.halfnes.mappers.MMC2Mapper;
import com.grapeshot.halfnes.mappers.MMC3Mapper;
import com.grapeshot.halfnes.mappers.MMC4Mapper;
import com.grapeshot.halfnes.mappers.MMC5Mapper;
import com.grapeshot.halfnes.mappers.Mapper107;
import com.grapeshot.halfnes.mappers.Mapper112;
import com.grapeshot.halfnes.mappers.Mapper119;
import com.grapeshot.halfnes.mappers.Mapper140;
import com.grapeshot.halfnes.mappers.Mapper15;
import com.grapeshot.halfnes.mappers.Mapper152;
import com.grapeshot.halfnes.mappers.Mapper182;
import com.grapeshot.halfnes.mappers.Mapper185;
import com.grapeshot.halfnes.mappers.Mapper200;
import com.grapeshot.halfnes.mappers.Mapper201;
import com.grapeshot.halfnes.mappers.Mapper203;
import com.grapeshot.halfnes.mappers.Mapper212;
import com.grapeshot.halfnes.mappers.Mapper213;
import com.grapeshot.halfnes.mappers.Mapper214;
import com.grapeshot.halfnes.mappers.Mapper225;
import com.grapeshot.halfnes.mappers.Mapper226;
import com.grapeshot.halfnes.mappers.Mapper229;
import com.grapeshot.halfnes.mappers.Mapper231;
import com.grapeshot.halfnes.mappers.Mapper240;
import com.grapeshot.halfnes.mappers.Mapper241;
import com.grapeshot.halfnes.mappers.Mapper242;
import com.grapeshot.halfnes.mappers.Mapper244;
import com.grapeshot.halfnes.mappers.Mapper246;
import com.grapeshot.halfnes.mappers.Mapper255;
import com.grapeshot.halfnes.mappers.Mapper33;
import com.grapeshot.halfnes.mappers.Mapper48;
import com.grapeshot.halfnes.mappers.Mapper58;
import com.grapeshot.halfnes.mappers.Mapper60;
import com.grapeshot.halfnes.mappers.Mapper61;
import com.grapeshot.halfnes.mappers.Mapper62;
import com.grapeshot.halfnes.mappers.Mapper70;
import com.grapeshot.halfnes.mappers.Mapper72;
import com.grapeshot.halfnes.mappers.Mapper76;
import com.grapeshot.halfnes.mappers.Mapper78;
import com.grapeshot.halfnes.mappers.Mapper86;
import com.grapeshot.halfnes.mappers.Mapper87;
import com.grapeshot.halfnes.mappers.Mapper92;
import com.grapeshot.halfnes.mappers.Mapper94;
import com.grapeshot.halfnes.mappers.Mapper97;
import com.grapeshot.halfnes.mappers.NINA_001_Mapper;
import com.grapeshot.halfnes.mappers.NINA_003_006_Mapper;
import com.grapeshot.halfnes.mappers.NamcoMapper;
import com.grapeshot.halfnes.mappers.Namcot34x3Mapper;
import com.grapeshot.halfnes.mappers.NromMapper;
import com.grapeshot.halfnes.mappers.Sunsoft01Mapper;
import com.grapeshot.halfnes.mappers.Sunsoft02Mapper;
import com.grapeshot.halfnes.mappers.Sunsoft03Mapper;
import com.grapeshot.halfnes.mappers.TengenRamboMapper;
import com.grapeshot.halfnes.mappers.UnromMapper;
import com.grapeshot.halfnes.mappers.VRC1Mapper;
import com.grapeshot.halfnes.mappers.VRC2Mapper;
import com.grapeshot.halfnes.mappers.VRC3Mapper;
import com.grapeshot.halfnes.mappers.VRC4Mapper;
import com.grapeshot.halfnes.mappers.VRC6Mapper;
import com.grapeshot.halfnes.mappers.VRC7Mapper;
import com.grapeshot.halfnes.utils;
import java.util.Arrays;
import java.util.zip.CRC32;

public abstract class Mapper {
    private ROMLoader loader;
    protected int mappertype = 0;
    protected int prgsize = 0;
    protected int prgoff = 0;
    protected int chroff = 0;
    protected int chrsize = 0;
    public CPU cpu;
    public CPURAM cpuram;
    public PPU ppu;
    protected int[] prg;
    protected int[] chr;
    protected int[] chr_map;
    protected int[] prg_map;
    protected int[] prgram = new int[8192];
    protected MirrorType scrolltype;
    protected boolean haschrram = false;
    protected boolean hasprgram = true;
    protected boolean savesram = false;
    protected final int[] pput0 = new int[1024];
    protected final int[] pput1 = new int[1024];
    protected final int[] pput2 = new int[1024];
    protected final int[] pput3 = new int[1024];
    protected int[] nt0;
    protected int[] nt1;
    protected int[] nt2;
    protected int[] nt3;
    long crc;

    public boolean supportsSaves() {
        return this.savesram;
    }

    public void destroy() {
        this.cpu = null;
        this.cpuram = null;
        this.ppu = null;
    }

    public long crc32(int[] array) {
        CRC32 c = new CRC32();
        for (int i : array) {
            c.update(i);
        }
        return c.getValue();
    }

    public void loadrom() throws BadMapperException {
        int i;
        this.loader.parseInesheader();
        this.prgsize = this.loader.prgsize;
        this.mappertype = this.loader.mappertype;
        this.prgoff = this.loader.prgoff;
        this.chroff = this.loader.chroff;
        this.chrsize = this.loader.chrsize;
        this.scrolltype = this.loader.scrolltype;
        this.savesram = this.loader.savesram;
        this.prg = this.loader.load(this.prgsize, this.prgoff);
        this.crc = this.crc32(this.prg);
        if (this.crc == 1092891794L || this.crc == -1731406971L) {
            this.hasprgram = false;
        }
        this.chr = this.loader.load(this.chrsize, this.chroff);
        if (this.chrsize == 0) {
            this.haschrram = true;
            this.chrsize = 8192;
            this.chr = new int[8192];
        }
        this.prg_map = new int[32];
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        this.chr_map = new int[8];
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
        this.cpuram = new CPURAM(this);
        this.cpu = new CPU(this.cpuram);
        this.ppu = new PPU(this);
        Arrays.fill(this.pput0, 160);
        Arrays.fill(this.pput1, 176);
        Arrays.fill(this.pput2, 192);
        Arrays.fill(this.pput3, 208);
        this.setmirroring(this.scrolltype);
    }

    public void reset() {
    }

    public void cartWrite(int addr, int data) {
        if (addr >= 24576 && addr < 32768) {
            this.prgram[addr & 0x1FFF] = data;
        }
    }

    public int cartRead(int addr) {
        if (addr >= 32768) {
            return this.prg[this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF)];
        }
        if (addr >= 24576 && this.hasprgram) {
            return this.prgram[addr & 0x1FFF];
        }
        return addr >> 8;
    }

    public int ppuRead(int addr) {
        if (addr < 8192) {
            return this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)];
        }
        switch (addr & 0xC00) {
            case 0: {
                return this.nt0[addr & 0x3FF];
            }
            case 1024: {
                return this.nt1[addr & 0x3FF];
            }
            case 2048: {
                return this.nt2[addr & 0x3FF];
            }
        }
        if (addr >= 16128) {
            if ((addr &= 0x1F) >= 16 && (addr & 3) == 0) {
                addr -= 16;
            }
            return this.ppu.pal[addr];
        }
        return this.nt3[addr & 0x3FF];
    }

    public void ppuWrite(int addr, int data) {
        if ((addr &= 0x3FFF) < 8192) {
            if (this.haschrram) {
                this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)] = data;
            }
        } else {
            switch (addr & 0xC00) {
                case 0: {
                    this.nt0[addr & 0x3FF] = data;
                    break;
                }
                case 1024: {
                    this.nt1[addr & 0x3FF] = data;
                    break;
                }
                case 2048: {
                    this.nt2[addr & 0x3FF] = data;
                    break;
                }
                case 3072: {
                    if (addr >= 16128 && addr <= 16383) {
                        if ((addr &= 0x1F) >= 16 && (addr & 3) == 0) {
                            addr -= 16;
                        }
                        this.ppu.pal[addr] = data & 0x3F;
                        break;
                    }
                    this.nt3[addr & 0x3FF] = data;
                    break;
                }
            }
        }
    }

    public void notifyscanline(int scanline) {
    }

    public void cpucycle(int cycles) {
    }

    public static Mapper getCorrectMapper(ROMLoader l) throws BadMapperException {
        int type = l.mappertype;
        boolean haschr = l.chrsize == 0;
        switch (type) {
            case 0: {
                return new NromMapper();
            }
            case 1: {
                return new MMC1Mapper();
            }
            case 2: {
                return new UnromMapper();
            }
            case 3: {
                return new CnromMapper();
            }
            case 4: {
                return new MMC3Mapper();
            }
            case 5: {
                return new MMC5Mapper();
            }
            case 7: {
                return new AnromMapper();
            }
            case 9: {
                return new MMC2Mapper();
            }
            case 10: {
                return new MMC4Mapper();
            }
            case 11: {
                return new ColorDreamsMapper();
            }
            case 15: 
            case 169: {
                return new Mapper15();
            }
            case 19: {
                return new NamcoMapper();
            }
            case 21: 
            case 23: 
            case 25: {
                return new VRC4Mapper(type);
            }
            case 22: {
                return new VRC2Mapper();
            }
            case 24: 
            case 26: {
                return new VRC6Mapper(type);
            }
            case 33: {
                return new Mapper33();
            }
            case 34: {
                if (haschr) {
                    return new BnromMapper();
                }
                return new NINA_001_Mapper();
            }
            case 38: {
                return new CrimeBustersMapper();
            }
            case 41: {
                return new CaltronMapper();
            }
            case 48: {
                return new Mapper48();
            }
            case 58: {
                return new Mapper58();
            }
            case 60: {
                return new Mapper60();
            }
            case 61: {
                return new Mapper61();
            }
            case 62: {
                return new Mapper62();
            }
            case 64: {
                return new TengenRamboMapper();
            }
            case 65: {
                return new IremH3001Mapper();
            }
            case 66: {
                return new GnromMapper();
            }
            case 67: {
                return new Sunsoft03Mapper();
            }
            case 68: {
                return new AfterburnerMapper();
            }
            case 69: {
                return new FME7Mapper();
            }
            case 70: {
                return new Mapper70();
            }
            case 71: {
                return new CodemastersMapper();
            }
            case 72: {
                return new Mapper72();
            }
            case 73: {
                return new VRC3Mapper();
            }
            case 75: {
                return new VRC1Mapper();
            }
            case 76: {
                return new Mapper76();
            }
            case 78: {
                return new Mapper78();
            }
            case 79: 
            case 113: {
                return new NINA_003_006_Mapper(type);
            }
            case 85: {
                return new VRC7Mapper();
            }
            case 86: {
                return new Mapper86();
            }
            case 87: {
                return new Mapper87();
            }
            case 88: 
            case 154: {
                return new Namcot34x3Mapper(type);
            }
            case 89: 
            case 93: {
                return new Sunsoft02Mapper(type);
            }
            case 92: {
                return new Mapper92();
            }
            case 94: {
                return new Mapper94();
            }
            case 97: {
                return new Mapper97();
            }
            case 107: {
                return new Mapper107();
            }
            case 112: {
                return new Mapper112();
            }
            case 119: {
                return new Mapper119();
            }
            case 140: {
                return new Mapper140();
            }
            case 152: {
                return new Mapper152();
            }
            case 180: {
                return new CrazyClimberMapper();
            }
            case 182: {
                return new Mapper182();
            }
            case 184: {
                return new Sunsoft01Mapper();
            }
            case 185: {
                return new Mapper185();
            }
            case 200: {
                return new Mapper200();
            }
            case 201: {
                return new Mapper201();
            }
            case 203: {
                return new Mapper203();
            }
            case 206: {
                return new MIMICMapper();
            }
            case 212: {
                return new Mapper212();
            }
            case 213: {
                return new Mapper213();
            }
            case 214: {
                return new Mapper214();
            }
            case 225: {
                return new Mapper225();
            }
            case 226: {
                return new Mapper226();
            }
            case 228: {
                return new Action52Mapper();
            }
            case 229: {
                return new Mapper229();
            }
            case 231: {
                return new Mapper231();
            }
            case 240: {
                return new Mapper240();
            }
            case 241: {
                return new Mapper241();
            }
            case 242: {
                return new Mapper242();
            }
            case 244: {
                return new Mapper244();
            }
            case 246: {
                return new Mapper246();
            }
            case 255: {
                return new Mapper255();
            }
        }
        System.err.println("unsupported mapper # " + type);
        throw new BadMapperException("Unsupported mapper: " + type);
    }

    public String getrominfo() {
        return "ROM INFO: \nFilename:     " + this.loader.name + "\n" + "Mapper:       " + this.mappertype + "\n" + "PRG Size:     " + this.prgsize / 1024 + " K\n" + "CHR Size:     " + (this.haschrram ? 0 : this.chrsize / 1024) + " K\n" + "Mirroring:    " + this.scrolltype.toString() + "\n" + "Battery Save: " + (this.savesram ? "Yes" : "No") + "\n" + "CRC:          " + utils.hex(this.crc);
    }

    public boolean hasSRAM() {
        return this.savesram;
    }

    public void setLoader(ROMLoader l) {
        this.loader = l;
    }

    public CPURAM getCPURAM() {
        return this.cpuram;
    }

    public void setPRGRAM(int[] newprgram) {
        this.prgram = (int[])newprgram.clone();
    }

    public int[] getPRGRam() {
        return (int[])this.prgram.clone();
    }

    public final void setmirroring(MirrorType type) {
        switch (type) {
            case H_MIRROR: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput0;
                this.nt2 = this.pput1;
                this.nt3 = this.pput1;
                break;
            }
            case V_MIRROR: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput1;
                this.nt2 = this.pput0;
                this.nt3 = this.pput1;
                break;
            }
            case SS_MIRROR0: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput0;
                this.nt2 = this.pput0;
                this.nt3 = this.pput0;
                break;
            }
            case SS_MIRROR1: {
                this.nt0 = this.pput1;
                this.nt1 = this.pput1;
                this.nt2 = this.pput1;
                this.nt3 = this.pput1;
                break;
            }
            default: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput1;
                this.nt2 = this.pput2;
                this.nt3 = this.pput3;
            }
        }
    }

    public static enum MirrorType {
        H_MIRROR,
        V_MIRROR,
        SS_MIRROR0,
        SS_MIRROR1,
        FOUR_SCREEN_MIRROR;

    }
}

