/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class MMC3Mapper
extends Mapper {
    private int whichbank = 0;
    private boolean prgconfig = false;
    private boolean chrconfig = false;
    private int irqctrreload = 0;
    private int irqctr = 0;
    private boolean irqenable = false;
    private boolean irqreload = false;
    private int bank6 = 0;
    private int[] chrreg = new int[]{0, 0, 0, 0, 0, 0};
    private boolean interrupted = false;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 0;
        }
        this.setbank6();
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (utils.getbit(addr, 0)) {
            if (addr >= 32768 && addr <= 40959) {
                if (this.whichbank <= 5) {
                    this.chrreg[this.whichbank] = data;
                    this.setupchr();
                } else if (this.whichbank == 6) {
                    this.bank6 = data;
                    this.setbank6();
                } else if (this.whichbank == 7) {
                    for (int i = 0; i < 8; ++i) {
                        this.prg_map[i + 8] = 1024 * (i + data * 8) % this.prgsize;
                    }
                }
            } else if (addr < 40960 || addr > 49151) {
                if (addr >= 49152 && addr <= 57343) {
                    this.irqreload = true;
                } else if (addr >= 57344 && addr <= 65535) {
                    this.irqenable = true;
                }
            }
        } else if (addr >= 32768 && addr <= 40959) {
            this.whichbank = data & 7;
            this.prgconfig = utils.getbit(data, 6);
            this.chrconfig = utils.getbit(data, 7);
            this.setupchr();
            this.setbank6();
        } else if (addr >= 40960 && addr <= 49151) {
            if (this.scrolltype != Mapper.MirrorType.FOUR_SCREEN_MIRROR) {
                this.setmirroring(utils.getbit(data, 0) ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
            }
        } else if (addr >= 49152 && addr <= 57343) {
            this.irqctrreload = data;
            this.irqreload = true;
        } else if (addr >= 57344 && addr <= 65535) {
            if (this.interrupted) {
                --this.cpu.interrupt;
            }
            this.interrupted = false;
            this.irqenable = false;
            this.irqctr = this.irqctrreload;
        }
    }

    private void setupchr() {
        if (this.chrconfig) {
            this.setppubank(1, 0, this.chrreg[2]);
            this.setppubank(1, 1, this.chrreg[3]);
            this.setppubank(1, 2, this.chrreg[4]);
            this.setppubank(1, 3, this.chrreg[5]);
            this.setppubank(2, 4, this.chrreg[0] >> 1 << 1);
            this.setppubank(2, 6, this.chrreg[1] >> 1 << 1);
        } else {
            this.setppubank(1, 4, this.chrreg[2]);
            this.setppubank(1, 5, this.chrreg[3]);
            this.setppubank(1, 6, this.chrreg[4]);
            this.setppubank(1, 7, this.chrreg[5]);
            this.setppubank(2, 0, this.chrreg[0] >> 1 << 1);
            this.setppubank(2, 2, this.chrreg[1] >> 1 << 1);
        }
    }

    private void setbank6() {
        if (!this.prgconfig) {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = 1024 * (i + this.bank6 * 8) % this.prgsize;
                this.prg_map[i + 16] = this.prgsize - 16384 + 1024 * i;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = this.prgsize - 16384 + 1024 * i;
                this.prg_map[i + 16] = 1024 * (i + this.bank6 * 8) % this.prgsize;
            }
        }
    }

    @Override
    public void notifyscanline(int scanline) {
        if (scanline > 239 && scanline != 261) {
            return;
        }
        if (!this.ppu.mmc3CounterClocking()) {
            return;
        }
        if (this.irqreload) {
            this.irqreload = false;
            this.irqctr = this.irqctrreload;
        }
        if (this.irqctr-- <= 0) {
            if (this.irqctrreload == 0) {
                return;
            }
            if (this.irqenable && !this.interrupted) {
                ++this.cpu.interrupt;
                this.interrupted = true;
            }
            this.irqctr = this.irqctrreload;
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) % this.chrsize;
        }
    }
}

