/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.Timer;

public class TriangleTimer
extends Timer {
    private static final int[] triangle = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};

    public TriangleTimer() {
        this.period = 0;
        this.position = 0L;
    }

    @Override
    public final void reset() {
        this.position = 0L;
    }

    @Override
    public final void clock() {
        if (this.period == 0) {
            return;
        }
        ++this.position;
        this.position %= (long)((this.period + 1) * triangle.length);
    }

    @Override
    public final void clock(int cycles) {
        if (this.period == 0) {
            return;
        }
        this.position += (long)cycles;
        this.position %= (long)((this.period + 1) * triangle.length);
    }

    @Override
    public final int getval() {
        return this.period <= 1 ? 0 : triangle[(int)(this.position / (long)(this.period + 1))];
    }

    @Override
    public final void setperiod(int newperiod) {
        this.position *= newperiod == 0 ? 0L : (long)(newperiod + 1);
        this.position = this.period == 0 ? 0L : this.position / (long)(this.period + 1);
        this.period = newperiod;
    }

    @Override
    public void setduty(int duty) {
        throw new UnsupportedOperationException("Triangle counter has no duty setting.");
    }

    @Override
    public void setduty(int[] duty) {
        throw new UnsupportedOperationException("Triangle counter has no duty setting.");
    }
}

