/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;
import com.grapeshot.halfnes.audio.SquareTimer;
import com.grapeshot.halfnes.audio.Timer;
import com.grapeshot.halfnes.utils;

public class FME7SoundChip
implements ExpansionSoundChip {
    private final Timer[] timers = new Timer[]{new SquareTimer(32), new SquareTimer(32), new SquareTimer(32)};
    private boolean[] enable = new boolean[]{false, false, false};
    private boolean[] useenvelope = new boolean[]{false, false, false};
    private int[] volume = new int[]{0, 0, 0};
    int currentval = 0;
    int enval = 0;
    private int[] volumetbl = FME7SoundChip.getvoltbl();

    @Override
    public final void write(int register, int data) {
        switch (register) {
            case 0: {
                this.timers[0].setperiod((this.timers[0].getperiod() & 0xF00) + data);
                break;
            }
            case 1: {
                this.timers[0].setperiod((this.timers[0].getperiod() & 0xFF) + ((data & 0xF) << 8));
                break;
            }
            case 2: {
                this.timers[1].setperiod((this.timers[1].getperiod() & 0xF00) + data);
                break;
            }
            case 3: {
                this.timers[1].setperiod((this.timers[1].getperiod() & 0xFF) + ((data & 0xF) << 8));
                break;
            }
            case 4: {
                this.timers[2].setperiod((this.timers[2].getperiod() & 0xF00) + data);
                break;
            }
            case 5: {
                this.timers[2].setperiod((this.timers[2].getperiod() & 0xFF) + ((data & 0xF) << 8));
                break;
            }
            case 7: {
                for (int i = 0; i < 3; ++i) {
                    this.enable[i] = !utils.getbit(data, i);
                }
                break;
            }
            case 8: {
                this.volume[0] = data & 0xF;
                this.useenvelope[0] = utils.getbit(data, 4);
                break;
            }
            case 9: {
                this.volume[1] = data & 0xF;
                this.useenvelope[1] = utils.getbit(data, 4);
                break;
            }
            case 10: {
                this.volume[2] = data & 0xF;
                this.useenvelope[2] = utils.getbit(data, 4);
                break;
            }
            case 13: {
                this.enval = 15;
                break;
            }
        }
    }

    @Override
    public final void clock(int cycle) {
        this.clockenvelope(cycle);
        this.timers[0].clock(cycle);
        this.timers[1].clock(cycle);
        this.timers[2].clock(cycle);
    }

    @Override
    public final int getval() {
        int mixvol = (this.enable[0] ? (this.useenvelope[0] ? this.enval : this.volumetbl[this.volume[0]]) * this.timers[0].getval() : 0) + (this.enable[1] ? (this.useenvelope[1] ? this.enval : this.volumetbl[this.volume[1]]) * this.timers[1].getval() : 0) + (this.enable[2] ? (this.useenvelope[2] ? this.enval : this.volumetbl[this.volume[2]]) * this.timers[2].getval() : 0);
        return mixvol;
    }

    public static int[] getvoltbl() {
        int[] vols = new int[16];
        for (int i = 0; i < 16; ++i) {
            vols[i] = (int)(90.0 * Math.pow(1.4, i));
        }
        return vols;
    }

    private void clockenvelope(int cycles) {
        this.enval = 0;
    }
}

