/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.ControllerImpl;
import com.grapeshot.halfnes.GUIInterface;
import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.NESFileFilter;
import com.grapeshot.halfnes.NTSCRenderer;
import com.grapeshot.halfnes.PreferencesDialog;
import com.grapeshot.halfnes.RGBRenderer;
import com.grapeshot.halfnes.Renderer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;

public class GUIImpl
extends JFrame
implements GUIInterface {
    private Canvas canvas;
    private BufferStrategy buffer;
    private final NES nes;
    private static final long serialVersionUID = 6411494245530679723L;
    private final AL listener = new AL();
    private int screenScaleFactor;
    private long[] frametimes = new long[60];
    private int frametimeptr = 0;
    private boolean smoothScale;
    private boolean inFullScreen = false;
    private GraphicsDevice gd;
    private int NES_HEIGHT = 224;
    private int NES_WIDTH;
    private Renderer renderer;
    private final ControllerImpl padController1;
    private final ControllerImpl padController2;
    int bgcolor;
    BufferedImage frame;
    double fps;
    int frameskip = 0;

    public GUIImpl(NES nes) {
        this.nes = nes;
        this.screenScaleFactor = nes.getPrefs().getInt("screenScaling", 2);
        this.padController1 = new ControllerImpl(this, nes.getPrefs(), 0);
        this.padController2 = new ControllerImpl(this, nes.getPrefs(), 1);
        nes.setControllers(this.padController1, this.padController2);
        this.padController1.startEventQueue();
        this.padController2.startEventQueue();
    }

    public synchronized void setRenderOptions() {
        if (this.canvas != null) {
            this.remove(this.canvas);
        }
        this.screenScaleFactor = this.nes.getPrefs().getInt("screenScaling", 2);
        this.smoothScale = this.nes.getPrefs().getBoolean("smoothScaling", false);
        if (this.nes.getPrefs().getBoolean("TVEmulation", false)) {
            this.renderer = new NTSCRenderer();
            this.NES_WIDTH = 302;
        } else {
            this.renderer = new RGBRenderer();
            this.NES_WIDTH = 256;
        }
        this.canvas = new Canvas();
        this.canvas.setSize(this.NES_WIDTH * this.screenScaleFactor, this.NES_HEIGHT * this.screenScaleFactor);
        this.canvas.setEnabled(false);
        this.add(this.canvas);
        this.pack();
        this.canvas.createBufferStrategy(2);
        this.buffer = this.canvas.getBufferStrategy();
    }

    @Override
    public synchronized void run() {
        this.setTitle("HalfNES 0.051");
        this.setResizable(false);
        this.buildMenus();
        this.setRenderOptions();
        this.getRootPane().registerKeyboardAction(this.listener, "Escape", KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(this.listener, "Toggle Fullscreen", KeyStroke.getKeyStroke(122, 0), 2);
        this.getRootPane().registerKeyboardAction(this.listener, "Quit", KeyStroke.getKeyStroke(115, 512), 2);
        this.setLocation(this.nes.getPrefs().getInt("windowX", 0), this.nes.getPrefs().getInt("windowY", 0));
        this.addWindowListener(this.listener);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        TransferHandler handler = new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                try {
                    File toload = (File)((List)t.getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                    GUIImpl.this.nes.loadROM(toload.getCanonicalPath());
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        };
        this.setTransferHandler(handler);
    }

    public void buildMenus() {
        JMenuBar menus = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem item = new JMenuItem("Open ROM...");
        file.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        file.addSeparator();
        item = new JMenuItem("Preferences...");
        file.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        file.addSeparator();
        item = new JMenuItem("Toggle Fullscreen");
        file.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        item.addActionListener(this.listener);
        menus.add(file);
        item = new JMenuItem("Quit");
        file.add(item);
        item.addActionListener(this.listener);
        menus.add(file);
        JMenu nesmenu = new JMenu("NES");
        item = new JMenuItem("Reset");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item = new JMenuItem("Hard Reset");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item = new JMenuItem("Pause");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        item = new JMenuItem("Resume");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        item = new JMenuItem("Fast Forward");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(32, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item = new JMenuItem("Frame Advance");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(46, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        nesmenu.addSeparator();
        item = new JMenuItem("ROM Info");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menus.add(nesmenu);
        JMenu help = new JMenu("Help");
        item = new JMenuItem("About");
        help.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        menus.add(help);
        this.setJMenuBar(menus);
    }

    public void loadROM() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(0);
        fileDialog.setTitle("Select a ROM to load");
        String path = this.nes.getPrefs().get("filePath", System.getProperty("user.dir", ""));
        File startDirectory = new File(path);
        if (startDirectory.isDirectory()) {
            fileDialog.setDirectory(path);
        }
        fileDialog.setFilenameFilter(new NESFileFilter());
        boolean wasInFullScreen = false;
        if (this.inFullScreen) {
            wasInFullScreen = true;
            this.toggleFullScreen();
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            this.nes.loadROM(fileDialog.getDirectory() + fileDialog.getFile());
            this.nes.getPrefs().put("filePath", fileDialog.getDirectory());
        }
        if (wasInFullScreen) {
            this.toggleFullScreen();
        }
    }

    public synchronized void toggleFullScreen() {
        if (this.inFullScreen) {
            this.dispose();
            this.gd.setFullScreenWindow(null);
            this.canvas.setSize(this.NES_HEIGHT * this.screenScaleFactor, this.NES_WIDTH * this.screenScaleFactor);
            this.setUndecorated(false);
            this.setVisible(true);
            this.inFullScreen = false;
            this.buildMenus();
        } else {
            this.setJMenuBar(null);
            this.gd = this.getGraphicsConfiguration().getDevice();
            if (!this.gd.isFullScreenSupported()) {
                this.messageBox("Fullscreen is not supported by your OS or version of Java.");
            }
            this.dispose();
            this.setUndecorated(true);
            this.gd.setFullScreenWindow(this);
            this.setVisible(true);
            this.inFullScreen = true;
        }
    }

    @Override
    public void messageBox(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    @Override
    public final synchronized void setFrame(int[] nextframe, int[] bgcolors, boolean dotcrawl) {
        this.frametimes[this.frametimeptr] = this.nes.getFrameTime();
        ++this.frametimeptr;
        this.frametimeptr %= this.frametimes.length;
        if (this.frametimeptr == 0) {
            long averageframes = 0L;
            for (long l : this.frametimes) {
                averageframes += l;
            }
            this.fps = 1.0E9 / (double)(averageframes /= (long)this.frametimes.length);
            this.setTitle(String.format("HalfNES %s - %s, %2.2f fps" + (this.frameskip > 0 ? " frameskip " + this.frameskip : ""), "0.051", this.nes.getCurrentRomName(), this.fps));
        }
        if (this.nes.framecount % (long)(this.frameskip + 1) == 0L) {
            this.frame = this.renderer.render(nextframe, bgcolors, dotcrawl);
            this.render();
        }
    }

    @Override
    public final synchronized void render() {
        Graphics graphics = this.buffer.getDrawGraphics();
        if (this.smoothScale) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        if (this.inFullScreen) {
            graphics.setColor(Color.BLACK);
            DisplayMode dm = this.gd.getDisplayMode();
            int scrnheight = dm.getHeight();
            int scrnwidth = dm.getWidth();
            this.canvas.setSize(scrnwidth, scrnheight);
            graphics.fillRect(0, 0, scrnwidth, scrnheight);
            if (this.nes.getPrefs().getBoolean("maintainAspect", true)) {
                double scalefactor = this.getmaxscale(scrnwidth, scrnheight);
                int height = (int)((double)this.NES_HEIGHT * scalefactor);
                int width = (int)(256.0 * scalefactor * 1.1666667);
                graphics.drawImage(this.frame, scrnwidth / 2 - width / 2, scrnheight / 2 - height / 2, width, height, null);
            } else {
                graphics.drawImage(this.frame, 0, 0, scrnwidth, scrnheight, null);
            }
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawString(this.getTitle(), 16, 16);
        } else {
            graphics.drawImage(this.frame, 0, 0, this.NES_WIDTH * this.screenScaleFactor, this.NES_HEIGHT * this.screenScaleFactor, null);
        }
        graphics.dispose();
        this.buffer.show();
    }

    public void showoptdlg() {
        PreferencesDialog dialog = new PreferencesDialog((Frame)this, this.nes.getPrefs());
        dialog.setVisible(true);
        if (dialog.okClicked()) {
            this.setRenderOptions();
            this.padController1.setButtons();
            this.padController2.setButtons();
            this.nes.setApuVol();
        }
    }

    public void savewindowposition() {
        this.nes.getPrefs().putInt("windowX", this.getX());
        this.nes.getPrefs().putInt("windowY", this.getY());
    }

    private double getmaxscale(int width, int height) {
        return Math.min((double)height / (double)this.NES_HEIGHT, (double)width / (double)this.NES_WIDTH);
    }

    public class AL
    implements ActionListener,
    WindowListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("Quit")) {
                GUIImpl.this.nes.quit();
            } else if (arg0.getActionCommand().equals("Reset")) {
                GUIImpl.this.nes.reset();
            } else if (arg0.getActionCommand().equals("Hard Reset")) {
                GUIImpl.this.nes.reloadROM();
            } else if (arg0.getActionCommand().equals("Pause")) {
                GUIImpl.this.nes.pause();
            } else if (arg0.getActionCommand().equals("Resume")) {
                GUIImpl.this.nes.resume();
            } else if (arg0.getActionCommand().equals("Preferences...")) {
                GUIImpl.this.showoptdlg();
            } else if (arg0.getActionCommand().equals("Fast Forward")) {
                GUIImpl.this.nes.toggleFrameLimiter();
            } else if (arg0.getActionCommand().equals("About")) {
                GUIImpl.this.messageBox("HalfNES 0.051 by Andrew Hoffman \n\nGet the latest version and report any bugs at http://halfnes.googlecode.com/ \n\nThis program is free software licensed under the GPL version 3, and comes with \nNO WARRANTY of any kind. (but if something's broken, please let me know). \nSee the license.txt file for details.");
            } else if (arg0.getActionCommand().equals("ROM Info")) {
                String info = GUIImpl.this.nes.getrominfo();
                if (info != null) {
                    GUIImpl.this.messageBox(info);
                }
            } else if (arg0.getActionCommand().equals("Open ROM...")) {
                GUIImpl.this.loadROM();
            } else if (arg0.getActionCommand().equals("Toggle Fullscreen")) {
                GUIImpl.this.toggleFullScreen();
            } else if (arg0.getActionCommand().equals("Frame Advance")) {
                GUIImpl.this.nes.frameAdvance();
            } else if (arg0.getActionCommand().equals("Escape")) {
                if (GUIImpl.this.inFullScreen) {
                    GUIImpl.this.toggleFullScreen();
                } else {
                    GUIImpl.this.nes.quit();
                }
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GUIImpl.this.savewindowposition();
            GUIImpl.this.padController1.stopEventQueue();
            GUIImpl.this.padController2.stopEventQueue();
            GUIImpl.this.nes.quit();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

