/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.FrameLimiterInterface;
import com.grapeshot.halfnes.NES;

public class FrameLimiterImpl
implements FrameLimiterInterface {
    NES nes;
    private long sleepingtest = 0L;
    public static final long FRAME_NS = 16639267L;

    public FrameLimiterImpl(NES nes) {
        this.nes = nes;
        FrameLimiterImpl.forceHighResolutionTimer();
    }

    @Override
    public void sleep() {
        long timeleft = System.nanoTime() - this.nes.frameStartTime;
        if (timeleft < 16639267L) {
            int sleepytime = (int)(16639267L - timeleft + this.sleepingtest);
            if (sleepytime < 0) {
                return;
            }
            this.sleepingtest = System.nanoTime();
            try {
                Thread.sleep(sleepytime / 1000000);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.sleepingtest = System.nanoTime() - this.sleepingtest;
            this.sleepingtest = (long)sleepytime - this.sleepingtest;
        }
    }

    @Override
    public void sleepFixed() {
        try {
            Thread.sleep(16L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void forceHighResolutionTimer() {
        Thread daemon = new Thread("ForceHighResolutionTimer"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(99999999999L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        daemon.setDaemon(true);
        daemon.start();
    }
}

