/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.ControllerInterface;
import com.grapeshot.halfnes.utils;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.prefs.Preferences;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public class ControllerImpl
implements ControllerInterface,
KeyListener {
    private final Component parent;
    private Controller gameController;
    private net.java.games.input.Component[] buttons;
    private final ScheduledExecutorService thread = Executors.newSingleThreadScheduledExecutor();
    private int latchbyte = 0;
    private int controllerbyte = 0;
    private int prevbyte = 0;
    private int outbyte = 0;
    private int gamepadbyte = 0;
    private final HashMap<Integer, Integer> m = new HashMap(10);
    private final int controllernum;
    private Preferences prefs;
    double threshold = 0.25;

    public ControllerImpl(Component parent, Preferences prefs, int controllernum) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (controllernum != 0 && controllernum != 1) {
            throw new IllegalArgumentException("controllerNum must be 0 or 1");
        }
        this.controllernum = controllernum;
        this.prefs = prefs;
        this.setButtons();
        this.parent = parent;
        parent.addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        this.prevbyte = this.controllerbyte;
        int kepressed = arg0.getKeyCode();
        if (!this.m.containsKey(kepressed)) {
            return;
        }
        this.controllerbyte |= this.m.get(kepressed).intValue();
        if (utils.getbit(this.controllerbyte, 4) && utils.getbit(this.controllerbyte, 5)) {
            this.controllerbyte &= 0xFFFFFFCF;
            this.controllerbyte |= this.prevbyte & 0xFFFFFFCF;
        }
        if (utils.getbit(this.controllerbyte, 6) && utils.getbit(this.controllerbyte, 7)) {
            this.controllerbyte &= 0xFFFFFF3F;
            this.controllerbyte |= this.prevbyte & 0xFFFFFF3F;
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        this.prevbyte = this.controllerbyte;
        int kepressed = arg0.getKeyCode();
        if (!this.m.containsKey(kepressed)) {
            return;
        }
        this.controllerbyte &= ~this.m.get(kepressed).intValue();
    }

    @Override
    public int getbyte() {
        return this.outbyte;
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void strobe() {
        this.outbyte = this.latchbyte & 1;
        this.latchbyte = this.latchbyte >> 1 | 0x100;
    }

    @Override
    public void output(boolean state) {
        this.latchbyte = this.gamepadbyte | this.controllerbyte;
    }

    public void startEventQueue() {
        this.thread.execute(this.eventQueueLoop());
    }

    private Runnable eventQueueLoop() {
        return new Runnable(){

            @Override
            public void run() {
                if (ControllerImpl.this.gameController != null) {
                    Event event = new Event();
                    while (!Thread.interrupted()) {
                        ControllerImpl.this.gameController.poll();
                        EventQueue queue = ControllerImpl.this.gameController.getEventQueue();
                        while (queue.getNextEvent(event)) {
                            net.java.games.input.Component component = event.getComponent();
                            if (component.getIdentifier() == Component.Identifier.Axis.X) {
                                if ((double)event.getValue() > ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte |= 128;
                                    ControllerImpl.this.gamepadbyte &= -65;
                                    continue;
                                }
                                if ((double)event.getValue() < -ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte |= 64;
                                    ControllerImpl.this.gamepadbyte &= -129;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte &= -193;
                                continue;
                            }
                            if (component.getIdentifier() == Component.Identifier.Axis.Y) {
                                if ((double)event.getValue() > ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte |= 32;
                                    ControllerImpl.this.gamepadbyte &= -17;
                                    continue;
                                }
                                if ((double)event.getValue() < -ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte |= 16;
                                    ControllerImpl.this.gamepadbyte &= -33;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte &= -49;
                                continue;
                            }
                            if (component == ControllerImpl.this.buttons[0]) {
                                if (ControllerImpl.this.isPressed(event)) {
                                    ControllerImpl.this.gamepadbyte |= 1;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte &= -2;
                                continue;
                            }
                            if (component == ControllerImpl.this.buttons[1]) {
                                if (ControllerImpl.this.isPressed(event)) {
                                    ControllerImpl.this.gamepadbyte |= 2;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte &= -3;
                                continue;
                            }
                            if (component == ControllerImpl.this.buttons[2]) {
                                if (ControllerImpl.this.isPressed(event)) {
                                    ControllerImpl.this.gamepadbyte |= 4;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte &= -5;
                                continue;
                            }
                            if (component != ControllerImpl.this.buttons[3]) continue;
                            if (ControllerImpl.this.isPressed(event)) {
                                ControllerImpl.this.gamepadbyte |= 8;
                                continue;
                            }
                            ControllerImpl.this.gamepadbyte &= -9;
                        }
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
        };
    }

    private boolean isPressed(Event event) {
        net.java.games.input.Component component = event.getComponent();
        if (component.isAnalog()) {
            return Math.abs(event.getValue()) > 0.2f;
        }
        return event.getValue() != 0.0f;
    }

    public void stopEventQueue() {
        this.thread.shutdownNow();
    }

    private static Controller[] getAvailablePadControllers() {
        Controller[] controllers;
        ArrayList<Controller> gameControllers = new ArrayList<Controller>();
        for (Controller controller : controllers = ControllerEnvironment.getDefaultEnvironment().getControllers()) {
            net.java.games.input.Component[] components;
            if (controller.getType() != Controller.Type.GAMEPAD && controller.getType() != Controller.Type.STICK) continue;
            int nbOfAxis = 0;
            for (net.java.games.input.Component component : components = controller.getComponents()) {
                if (component.getIdentifier() != Component.Identifier.Axis.X && component.getIdentifier() != Component.Identifier.Axis.Y) continue;
                ++nbOfAxis;
            }
            if (nbOfAxis < 2 || ControllerImpl.getButtons(controller).length < 2) continue;
            gameControllers.add(controller);
        }
        return gameControllers.toArray(new Controller[0]);
    }

    private static net.java.games.input.Component[] getButtons(Controller controller) {
        net.java.games.input.Component[] components;
        ArrayList<net.java.games.input.Component> buttons = new ArrayList<net.java.games.input.Component>();
        for (net.java.games.input.Component component : components = controller.getComponents()) {
            if (!(component.getIdentifier() instanceof Component.Identifier.Button)) continue;
            buttons.add(component);
        }
        return buttons.toArray(new net.java.games.input.Component[0]);
    }

    public final void setButtons() {
        this.m.clear();
        switch (this.controllernum) {
            case 0: {
                this.m.put(this.prefs.getInt("keyUp1", 38), 16);
                this.m.put(this.prefs.getInt("keyDown1", 40), 32);
                this.m.put(this.prefs.getInt("keyLeft1", 37), 64);
                this.m.put(this.prefs.getInt("keyRight1", 39), 128);
                this.m.put(this.prefs.getInt("keyA1", 88), 1);
                this.m.put(this.prefs.getInt("keyB1", 90), 2);
                this.m.put(this.prefs.getInt("keySelect1", 16), 4);
                this.m.put(this.prefs.getInt("keyStart1", 10), 8);
                break;
            }
            default: {
                this.m.put(this.prefs.getInt("keyUp2", 87), 16);
                this.m.put(this.prefs.getInt("keyDown2", 83), 32);
                this.m.put(this.prefs.getInt("keyLeft2", 65), 64);
                this.m.put(this.prefs.getInt("keyRight2", 68), 128);
                this.m.put(this.prefs.getInt("keyA2", 71), 1);
                this.m.put(this.prefs.getInt("keyB2", 70), 2);
                this.m.put(this.prefs.getInt("keySelect2", 82), 4);
                this.m.put(this.prefs.getInt("keyStart2", 84), 8);
            }
        }
        Controller[] controllers = ControllerImpl.getAvailablePadControllers();
        if (controllers.length > this.controllernum) {
            this.gameController = controllers[this.controllernum];
            System.err.println(this.controllernum + 1 + ". " + this.gameController.getName());
            this.buttons = ControllerImpl.getButtons(controllers[this.controllernum]);
        } else {
            this.gameController = null;
            this.buttons = null;
        }
    }
}

