/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.Renderer;
import com.grapeshot.halfnes.utils;
import java.awt.image.BufferedImage;

public class AltNTSCRenderer
extends Renderer {
    private final int[] frame = new int[144960];
    private int frame_ptr = 0;
    private int frame_ctr;
    private int phase;
    private static final double attenuation = 0.746;
    private static final double[] levels = new double[]{-0.117f, 0.0, 0.308f, 0.715f, 0.397f, 0.681f, 1.0, 1.0};
    private static final int SAMPLESPERPIXEL = 8;
    private double[] signal_levels = new double[2048];
    private int ntsc_buf_ptr = 0;
    private static final int width = 604;

    @Override
    public BufferedImage render(int[] nespixels, int[] bgcolors, boolean dotcrawl) {
        ++this.frame_ctr;
        this.phase = (this.frame_ctr & 1) == 0 ? 0 : 6;
        for (int i = 0; i < 240; ++i) {
            double phi = ((double)this.phase + 3.9 - 0.3) % 12.0;
            for (int j = 0; j < 256; ++j) {
                this.ntsc_render(nespixels[i * 256 + j]);
            }
            this.ntsc_decode(phi);
            this.ntsc_buf_ptr = 0;
        }
        this.frame_ptr = 0;
        return AltNTSCRenderer.getImageFromArray(this.frame, 4832, 604, 224);
    }

    private void ntsc_render(int pixel) {
        int color = pixel & 0xF;
        int level = pixel >> 4 & 3;
        int emphasis = pixel >> 6;
        if (color > 13) {
            level = 1;
        }
        double low = levels[level];
        double high = levels[4 + level];
        if (color == 0) {
            low = high;
        } else if (color > 12) {
            high = low;
        }
        int i = 0;
        while (i < 8) {
            double signal;
            double d = signal = AltNTSCRenderer.inColorPhase(color, this.phase) ? high : low;
            if (emphasis != 0 && (utils.getbit(emphasis, 0) && AltNTSCRenderer.inColorPhase(0, this.phase) || utils.getbit(emphasis, 1) && AltNTSCRenderer.inColorPhase(4, this.phase) || utils.getbit(emphasis, 2) && AltNTSCRenderer.inColorPhase(8, this.phase))) {
                signal *= 0.746;
            }
            this.signal_levels[this.ntsc_buf_ptr++] = signal;
            ++i;
            ++this.phase;
        }
    }

    private static boolean inColorPhase(int color, int phase) {
        return (color + phase) % 12 < 6;
    }

    private void ntsc_decode(double phase) {
        for (int x = 0; x < 604; ++x) {
            int end;
            int center = x * 2048 / 604 + 0;
            int begin = center - 6;
            if (begin < 0) {
                begin = 0;
            }
            if ((end = center + 6) > 2048) {
                end = 2048;
            }
            double y = 0.0;
            double i = 0.0;
            double q = 0.0;
            for (int p = begin; p < end; ++p) {
                double level = this.signal_levels[p] / 12.0;
                y += level;
                i += level * Math.cos(Math.PI * (phase + (double)p) / 6.0);
                q += level * Math.sin(Math.PI * (phase + (double)p) / 6.0);
            }
            this.render_pixel(y, i, q);
        }
    }

    private void render_pixel(double y, double i, double q) {
        float gamma = 2.0f;
        int rgb = 0xFF000000 | 65536 * AltNTSCRenderer.clamp(255.95 * AltNTSCRenderer.gammafix(y + (double)0.946882f * i + (double)0.623557f * q)) + 256 * AltNTSCRenderer.clamp(255.95 * AltNTSCRenderer.gammafix(y + (double)-0.274788f * i + (double)-0.635691f * q)) + 1 * AltNTSCRenderer.clamp(255.95 * AltNTSCRenderer.gammafix(y + -1.108544945716858 * i + (double)1.709007f * q));
        this.frame[this.frame_ptr++] = rgb;
    }

    public static int clamp(double a) {
        return (int)(a < 0.0 ? 0.0 : (a > 255.0 ? 255.0 : a));
    }

    public static double gammafix(double luma) {
        return luma <= 0.0 ? 0.0 : Math.pow(luma, 1.1f);
    }
}

