/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class Mapper226
extends Mapper {
    int[] reg = new int[]{0, 0};

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        this.reg[addr & 1] = data;
        int bank = this.reg[0] >> 1 & 0xF | this.reg[0] >> 3 & 0x10 | this.reg[1] << 5 & 0x20;
        this.setmirroring(utils.getbit(this.reg[0], 6) ? Mapper.MirrorType.V_MIRROR : Mapper.MirrorType.H_MIRROR);
        if ((this.reg[0] & 0x20) != 0) {
            int i;
            bank = bank << 1 | this.reg[0] & 1;
            for (i = 0; i < 16; ++i) {
                this.prg_map[i] = 1024 * (i + 16 * bank) & this.prgsize - 1;
            }
            for (i = 0; i < 16; ++i) {
                this.prg_map[i + 16] = 1024 * (i + 16 * bank) & this.prgsize - 1;
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                this.prg_map[i] = 1024 * (i + 32 * bank) & this.prgsize - 1;
            }
        }
    }
}

