/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class Mapper212
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[16 + i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        int i;
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr >= 32768 && addr <= 49151) {
            for (i = 0; i < 16; ++i) {
                this.prg_map[i] = 1024 * (i + 16 * addr) & this.prgsize - 1;
            }
            for (i = 0; i < 16; ++i) {
                this.prg_map[i + 16] = 1024 * (i + 16 * addr) & this.prgsize - 1;
            }
        } else if (addr >= 49152 && addr <= 65535) {
            for (i = 0; i < 32; ++i) {
                this.prg_map[i] = 1024 * (i + 32 * (addr >> 1)) & this.prgsize - 1;
            }
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * (i + 8 * addr) & this.chrsize - 1;
        }
        this.setmirroring(utils.getbit(addr, 4) ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
    }
}

