/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class Mapper15
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        int prgbank = data << 1 & 0xFE;
        int prgflip = data >> 7;
        this.setmirroring(utils.getbit(data, 6) ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
        switch (addr & 0xFFF) {
            case 0: {
                int i;
                for (i = 0; i < 8; ++i) {
                    this.prg_map[i] = 1024 * (i + 8 * (prgbank | 0 ^ prgflip)) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[8 + i] = 1024 * (i + 8 * (prgbank | 1 ^ prgflip)) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[16 + i] = 1024 * (i + 8 * (prgbank | 2 ^ prgflip)) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[24 + i] = 1024 * (i + 8 * (prgbank | 3 ^ prgflip)) & this.prgsize - 1;
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < 8; ++i) {
                    this.prg_map[i] = 1024 * (i + 8 * (prgbank | 0 ^ prgflip)) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[8 + i] = 1024 * (i + 8 * (prgbank | 1 ^ prgflip)) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[16 + i] = 1024 * (i + 8 * (0x7E | 0 ^ prgflip)) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[24 + i] = 1024 * (i + 8 * (0x7F | 1 ^ prgflip)) & this.prgsize - 1;
                }
                break;
            }
            case 2: {
                int i;
                prgbank |= prgflip;
                for (i = 0; i < 8; ++i) {
                    this.prg_map[i] = 1024 * (i + 8 * prgbank) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[8 + i] = 1024 * (i + 8 * prgbank) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[16 + i] = 1024 * (i + 8 * prgbank) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[24 + i] = 1024 * (i + 8 * prgbank) & this.prgsize - 1;
                }
                break;
            }
            case 3: {
                int i;
                prgbank |= prgflip;
                for (i = 0; i < 8; ++i) {
                    this.prg_map[i] = 1024 * (i + 8 * prgbank) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[8 + i] = 1024 * (i + 8 * (prgbank + 1)) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[16 + i] = 1024 * (i + 8 * (prgbank + (~addr >> 1 & 1))) & this.prgsize - 1;
                }
                for (i = 0; i < 8; ++i) {
                    this.prg_map[24 + i] = 1024 * (i + 8 * (prgbank + 1)) & this.prgsize - 1;
                }
                break;
            }
        }
    }
}

