/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class IremH3001Mapper
extends Mapper {
    private int[] chrbank = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int irqctr;
    private int irqreload = 0;
    private boolean irqenable;
    private boolean interrupted = false;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        block14: {
            block17: {
                block16: {
                    block15: {
                        block13: {
                            if (addr < 32768 || addr > 53247) {
                                super.cartWrite(addr, data);
                                return;
                            }
                            if (addr < 32768 || addr > 36863) break block13;
                            for (int i = 0; i < 8; ++i) {
                                this.prg_map[i] = 1024 * (i + data * 8) & this.prgsize - 1;
                            }
                            break block14;
                        }
                        if (addr != 36865) break block15;
                        this.setmirroring(utils.getbit(data, 7) ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
                        break block14;
                    }
                    if (addr != 36867) break block16;
                    this.irqenable = utils.getbit(data, 7);
                    if (!this.interrupted) break block14;
                    --this.cpu.interrupt;
                    this.interrupted = false;
                    break block14;
                }
                if (addr != 36868) break block17;
                this.irqctr = this.irqreload;
                if (!this.interrupted) break block14;
                --this.cpu.interrupt;
                this.interrupted = false;
                break block14;
            }
            if (addr == 36869) {
                this.irqreload = this.irqreload & 0xFF | data << 8;
            } else if (addr == 36870) {
                this.irqreload = this.irqreload & 0xFF00 | data;
            } else if (addr >= 40960 && addr <= 45055) {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[i + 8] = 1024 * (i + data * 8) & this.prgsize - 1;
                }
            } else if (addr >= 45056 && addr <= 49151) {
                this.chrbank[addr & 7] = data;
                this.setppubank(1, addr & 7, this.chrbank[addr & 7]);
            } else if (addr >= 49152 && addr <= 53247) {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[i + 16] = 1024 * (i + data * 8) & this.prgsize - 1;
                }
            }
        }
    }

    @Override
    public void cpucycle(int cycles) {
        if (this.irqenable) {
            if (this.irqctr <= 0) {
                if (!this.interrupted) {
                    ++this.cpu.interrupt;
                    this.interrupted = true;
                }
                this.irqenable = false;
            } else {
                this.irqctr -= cycles;
            }
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) & this.chrsize - 1;
        }
    }
}

