/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.Timer;

public class SquareTimer
extends Timer {
    protected int[] values;
    private final int periodadd;

    @Override
    public final void clock() {
        if (this.period < 8) {
            return;
        }
        ++this.position;
        this.position %= (long)((this.period + this.periodadd) * this.values.length);
    }

    @Override
    public final void clock(int cycles) {
        if (this.period < 8) {
            return;
        }
        this.position += (long)cycles;
        this.position %= (long)((this.period + this.periodadd) * this.values.length);
    }

    public SquareTimer(int ctrlen, int periodadd) {
        this.periodadd = periodadd;
        this.values = new int[ctrlen];
        this.period = 0;
        this.position = 0L;
        this.setduty(ctrlen / 2);
    }

    public SquareTimer(int ctrlen) {
        this.periodadd = 0;
        this.values = new int[ctrlen];
        this.period = 0;
        this.position = 0L;
        this.setduty(ctrlen / 2);
    }

    @Override
    public final void reset() {
        this.position = 0L;
    }

    @Override
    public final void setduty(int duty) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = i < duty ? 1 : 0;
        }
        if (this.position >= (long)(this.values.length * (this.period + this.periodadd))) {
            this.position = this.period > 0 ? this.position % (long)((this.period + this.periodadd) * this.values.length) : 0L;
        }
    }

    @Override
    public final void setduty(int[] dutyarray) {
        this.values = dutyarray;
    }

    @Override
    public final int getval() {
        return this.period <= 1 ? 0 : this.values[(int)(this.position / (long)(this.period + this.periodadd))];
    }

    @Override
    public final void setperiod(int newperiod) {
        this.position *= newperiod == 0 ? 0L : (long)(newperiod + this.periodadd);
        this.position = this.period == 0 ? 0L : this.position / (long)(this.period + this.periodadd);
        this.period = newperiod;
    }
}

