/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.Timer;
import com.grapeshot.halfnes.utils;

public class NoiseTimer
extends Timer {
    int valuespos = 0;
    private int[] values = NoiseTimer.genvalues(1, 1);
    private int prevduty = 1;

    public void NoiseTimer() {
        this.period = 0;
    }

    @Override
    public void setduty(int duty) {
        if (duty != this.prevduty) {
            this.values = NoiseTimer.genvalues(duty, this.values[this.valuespos]);
            this.valuespos = 0;
        }
        this.prevduty = duty;
    }

    @Override
    public final void clock() {
        if (--this.position < 0L) {
            this.position = this.period;
            ++this.valuespos;
            this.valuespos %= this.values.length;
        }
    }

    @Override
    public final int getval() {
        return this.values[this.valuespos] & 1;
    }

    @Override
    public final void reset() {
        this.position = 0L;
    }

    @Override
    public final void clock(int cycles) {
        for (int i = 0; i < cycles; ++i) {
            if (--this.position >= 0L) continue;
            this.position = this.period;
            this.position = this.period;
            ++this.valuespos;
            this.valuespos %= this.values.length;
        }
    }

    @Override
    public final void setperiod(int newperiod) {
        this.period = newperiod;
    }

    public static int[] genvalues(int whichbit, int seed) {
        int[] tehsuck = new int[whichbit == 1 ? Short.MAX_VALUE : 93];
        for (int i = 0; i < tehsuck.length; ++i) {
            tehsuck[i] = seed = seed >> 1 | (utils.getbit(seed, whichbit) ^ utils.getbit(seed, 0) ? 16384 : 0);
        }
        return tehsuck;
    }

    @Override
    public void setduty(int[] duty) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

