/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;
import com.grapeshot.halfnes.utils;

public class NamcoSoundChip
implements ExpansionSoundChip {
    private int[] registers = new int[128];
    private int[] out = new int[8];
    private int numch;
    private int cycpos = 0;
    private int curch = 0;
    int hpaccum = 0;

    @Override
    public void clock(int cycles) {
        this.numch = 1 + (this.registers[127] >> 4 & 7);
        for (int i = 0; i < cycles; ++i) {
            ++this.cycpos;
            this.cycpos %= 15;
            if (this.cycpos != 0) continue;
            ++this.curch;
            this.curch %= this.numch;
            this.clock_channel(this.curch);
        }
    }

    private void clock_channel(int ch) {
        int off = 128 - 8 * (ch + 1);
        int phase = (this.registers[off + 5] << 16) + (this.registers[off + 3] << 8) + this.registers[off + 1];
        int f = ((this.registers[off + 4] & 3) << 16) + (this.registers[off + 2] << 8) + this.registers[off];
        int len = (64 - (this.registers[off + 4] >> 2)) * 4;
        int wavestart = this.registers[off + 6];
        phase = (phase + f) % (len << 16);
        int volume = this.registers[off + 7] & 0xF;
        int output = (this.getWavefromRAM((phase >> 16) + wavestart & 0xFF) - 8) * volume;
        this.registers[off + 5] = phase >> 16 & 0xFF;
        this.registers[off + 3] = phase >> 8 & 0xFF;
        this.registers[off + 1] = phase & 0xFF;
        this.out[ch] = output * 16;
        this.output(output * 128);
    }

    private int getWavefromRAM(int addr) {
        int b = this.registers[addr >> 1];
        int r = utils.getbit(addr, 0) ? b >> 4 : b & 0xF;
        return r;
    }

    @Override
    public void write(int register, int data) {
        this.registers[register] = data;
    }

    public int read(int register) {
        return this.registers[register];
    }

    @Override
    public int getval() {
        return this.hpaccum << 2;
    }

    private void output(int sample) {
        this.hpaccum = (int)((double)this.hpaccum - (double)(sample += this.hpaccum) * 0.0625);
    }
}

