/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.DebugUI;
import com.grapeshot.halfnes.GUIInterface;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class PPU {
    public Mapper mapper;
    private int scanline;
    private int oamaddr;
    private int sprite0x;
    private int readbuffer = 0;
    private int loopyV = 0;
    private int loopyT = 0;
    private int loopyX = 0;
    private final int[] OAM = new int[256];
    private final int[] spriteshiftregH = new int[8];
    private final int[] spriteshiftregL = new int[8];
    private final int[] spriteXlatch = new int[8];
    private final int[] spritepals = new int[8];
    private final int[] bitmap = new int[61440];
    private final boolean[] spritebgflags = new boolean[8];
    private boolean sprite0hit = false;
    private boolean even = true;
    private boolean bgpattern = true;
    private boolean sprpattern = false;
    public final int[] ppuregs = new int[8];
    public final int[] pal = new int[]{9, 1, 0, 1, 0, 2, 2, 13, 8, 16, 8, 36, 0, 0, 4, 44, 9, 1, 52, 3, 0, 4, 0, 20, 8, 58, 0, 2, 0, 32, 44, 8};
    private DebugUI debuggui;
    private int vraminc = 1;
    private static final boolean PPUDEBUG = false;
    private BufferedImage newBuff;
    int[] bgcolors = new int[256];
    int openbus = 0;
    int bgcolor;
    boolean dotcrawl = true;
    private int off;
    private int y;
    private int index;
    private int sprpxl;
    private int found;
    private boolean sprite0here = false;
    private int[] tiledata = new int[8];
    private int[] tilepal = new int[4];

    public PPU(Mapper mapper) {
        this.mapper = mapper;
        Arrays.fill(this.OAM, 255);
        Arrays.fill(this.ppuregs, 0);
    }

    public final int read(int regnum) {
        switch (regnum) {
            case 2: {
                this.even = true;
                int tmp = this.ppuregs[2];
                this.ppuregs[2] = this.ppuregs[2] & 0x7F;
                this.openbus = tmp;
                break;
            }
            case 4: {
                this.openbus = this.OAM[this.oamaddr];
                break;
            }
            case 7: {
                if ((this.loopyV & 0x3FFF) < 16128) {
                    int temp = this.readbuffer;
                    this.readbuffer = this.mapper.ppuRead(this.loopyV & 0x3FFF);
                    this.loopyV += this.vraminc;
                    this.openbus = temp;
                    break;
                }
                this.readbuffer = this.mapper.ppuRead((this.loopyV & 0x3FFF) - 4096);
                int temp = this.mapper.ppuRead(this.loopyV);
                this.loopyV += this.vraminc;
                this.openbus = temp;
                break;
            }
            default: {
                return this.openbus;
            }
        }
        return this.openbus;
    }

    public final void write(int regnum, int data) {
        this.openbus = data;
        switch (regnum) {
            case 0: {
                this.ppuregs[0] = data;
                this.vraminc = utils.getbit(data, 2) ? 32 : 1;
                this.loopyT &= 0xFFFFF3FF;
                this.loopyT += (data & 3) << 10;
                break;
            }
            case 1: {
                this.ppuregs[1] = data;
            }
            case 3: {
                this.oamaddr = data & 0xFF;
                break;
            }
            case 4: {
                this.OAM[this.oamaddr++] = (this.oamaddr & 3) == 2 ? data & 0xE3 : data;
                this.oamaddr &= 0xFF;
                break;
            }
            case 5: {
                if (this.even) {
                    this.loopyT &= 0xFFFFFFE0;
                    this.loopyX = data & 7;
                    this.loopyT += data >> 3;
                    this.even = false;
                    break;
                }
                this.loopyT &= 0xFFFF8FFF;
                this.loopyT |= (data & 7) << 12;
                this.loopyT &= 0xFFFFFC1F;
                this.loopyT |= (data & 0xF8) << 2;
                this.even = true;
                break;
            }
            case 6: {
                if (this.even) {
                    this.loopyT &= 0xC0FF;
                    this.loopyT += (data & 0x3F) << 8;
                    this.loopyT &= 0x3FFF;
                    this.even = false;
                    break;
                }
                this.loopyT &= 0xFF00;
                this.loopyT += data;
                this.loopyV = this.loopyT;
                this.even = true;
                break;
            }
            case 7: {
                if (this.renderingisoff()) {
                    this.mapper.ppuWrite(this.loopyV & 0x3FFF, data);
                    this.loopyV += this.vraminc;
                    break;
                }
                this.mapper.ppuWrite(this.loopyV & 0x3FFF, data);
                this.loopyV += this.vraminc;
            }
        }
    }

    public final boolean renderingisoff() {
        return this.scanline >= 240 || !utils.getbit(this.ppuregs[1], 3);
    }

    public final boolean ppuison() {
        return utils.getbit(this.ppuregs[1], 3) | utils.getbit(this.ppuregs[1], 4);
    }

    public final boolean mmc3CounterClocking() {
        return this.bgpattern != this.sprpattern && !this.renderingisoff();
    }

    public final boolean drawLine(int scanline) {
        this.bgpattern = utils.getbit(this.ppuregs[0], 4);
        this.sprpattern = utils.getbit(this.ppuregs[0], 3);
        int bufferoffset = scanline << 8;
        this.bgcolor = this.pal[0] + 256;
        this.bgcolors[scanline] = this.pal[0];
        if (scanline == 0) {
            this.dotcrawl = this.ppuison();
        }
        if (utils.getbit(this.ppuregs[1], 3)) {
            if (scanline == 0) {
                this.loopyV = this.loopyT;
            } else {
                this.loopyV &= 0xFFFFFBE0;
                this.loopyV |= this.loopyT & 0x41F;
            }
            int ntoffset = this.loopyV & 0xC00 | 0x2000;
            int attroffset = this.loopyV & 0xC00 | 0x23C0;
            boolean horizWrap = false;
            for (int tilenum = 0; tilenum < 33; ++tilenum) {
                if (tilenum * 8 + (((this.loopyV & 0x1F) << 3) + this.loopyX) > 255 && !horizWrap) {
                    ntoffset ^= 0x400;
                    ntoffset -= 32;
                    attroffset ^= 0x400;
                    horizWrap = true;
                }
                int tileaddr = this.mapper.ppuRead(ntoffset + (this.loopyV & 0x3FF) + tilenum) * 16 + (this.bgpattern ? 4096 : 0);
                int palettenum = this.getattrtbl(attroffset, this.loopyV + tilenum & 0x1F, (ntoffset + this.loopyV + tilenum & 0x3E0) >> 5);
                int[] tile = this.getTile(tileaddr, palettenum * 4, (this.loopyV & 0x7000) >> 12);
                int xpos = tilenum * 8 - this.loopyX;
                for (int pxl = 0; pxl < 8; ++pxl) {
                    if (pxl + xpos >= 256 || pxl + xpos < 0) continue;
                    this.bitmap[pxl + xpos + bufferoffset] = tile[pxl];
                }
            }
            int newfinescroll = this.loopyV & 0x7000;
            this.loopyV &= 0xFFFF8FFF;
            this.loopyV = (newfinescroll += 4096) > 28672 ? (this.loopyV += 32) : (this.loopyV += newfinescroll);
            if ((this.loopyV >> 5 & 0x1F) == 30) {
                this.loopyV &= 0xFFFFFC1F;
                this.loopyV ^= 0x800;
                ntoffset += 1088;
                attroffset += 1984;
            }
            if (!utils.getbit(this.ppuregs[1], 1)) {
                for (int i = 0; i < 8; ++i) {
                    this.bitmap[i + bufferoffset] = this.bgcolor;
                }
            }
        } else {
            this.bgcolor = this.loopyV > 16128 && this.loopyV < 16383 ? this.mapper.ppuRead(this.loopyV) : this.pal[0];
            Arrays.fill(this.bitmap, bufferoffset, bufferoffset + 256, this.bgcolor);
        }
        this.drawSprites(scanline);
        this.evalSprites(scanline);
        if (utils.getbit(this.ppuregs[1], 0)) {
            int i = bufferoffset;
            while (i < bufferoffset + 256) {
                int n = i++;
                this.bitmap[n] = this.bitmap[n] & 0x30;
            }
        }
        int emph = (this.ppuregs[1] & 0xE0) << 1;
        for (int i = bufferoffset; i < bufferoffset + 256; ++i) {
            this.bitmap[i] = this.bitmap[i] & 0x3F | emph;
        }
        if (this.sprite0hit) {
            this.sprite0hit = false;
            return true;
        }
        return false;
    }

    private void evalSprites(int scanline) {
        if (!utils.getbit(this.ppuregs[1], 4) && !utils.getbit(this.ppuregs[1], 3)) {
            return;
        }
        this.sprite0here = false;
        this.bgpattern = utils.getbit(this.ppuregs[0], 4);
        this.sprpattern = utils.getbit(this.ppuregs[0], 3);
        this.found = 0;
        boolean spritesize = utils.getbit(this.ppuregs[0], 5);
        for (int spritestart = 0; spritestart < 255; spritestart += 4) {
            int ypos = this.OAM[spritestart];
            int offset = scanline - ypos;
            if (ypos > scanline || offset > (spritesize ? 15 : 7)) continue;
            if (spritestart == 0) {
                this.sprite0here = true;
            }
            if (this.found >= 8) {
                this.ppuregs[2] = this.ppuregs[2] | 0x20;
                break;
            }
            int oamextra = this.OAM[spritestart + 2];
            this.spritebgflags[this.found] = utils.getbit(oamextra, 5);
            this.spriteXlatch[this.found] = this.OAM[spritestart + 3];
            this.spritepals[this.found] = ((oamextra & 3) + 4) * 4;
            if (utils.getbit(oamextra, 7)) {
                offset = (spritesize ? 15 : 7) - offset;
            }
            if (offset > 7) {
                offset += 8;
            }
            int tilenum = this.OAM[spritestart + 1];
            int tilefetched = spritesize ? (tilenum & 1) * 4096 + (tilenum & 0xFE) * 16 : tilenum * 16 + (this.sprpattern ? 4096 : 0);
            tilefetched += offset;
            boolean hflip = utils.getbit(oamextra, 6);
            if (!hflip) {
                this.spriteshiftregL[this.found] = utils.reverseByte(this.mapper.ppuRead(tilefetched));
                this.spriteshiftregH[this.found] = utils.reverseByte(this.mapper.ppuRead(tilefetched + 8));
            } else {
                this.spriteshiftregL[this.found] = this.mapper.ppuRead(tilefetched);
                this.spriteshiftregH[this.found] = this.mapper.ppuRead(tilefetched + 8);
            }
            ++this.found;
        }
        for (int i = this.found; i < 8; ++i) {
            this.spriteshiftregL[this.found] = 0;
            this.spriteshiftregH[this.found] = 0;
        }
    }

    private void drawSprites(int scanline) {
        if (this.found == 0) {
            return;
        }
        int bufferoffset = scanline << 8;
        int startdraw = utils.getbit(this.ppuregs[1], 2) ? 0 : 8;
        for (int x = 0; x < 256; ++x) {
            this.sprpxl = 0;
            this.index = 7;
            this.y = this.found - 1;
            while (this.y >= 0) {
                this.off = x - this.spriteXlatch[this.y];
                if (this.off >= 0 && this.off <= 8) {
                    if ((this.spriteshiftregH[this.y] & 1) + (this.spriteshiftregL[this.y] & 1) != 0) {
                        this.index = this.y;
                        this.sprpxl = 2 * (this.spriteshiftregH[this.y] & 1) + (this.spriteshiftregL[this.y] & 1);
                    }
                    int n = this.y;
                    this.spriteshiftregH[n] = this.spriteshiftregH[n] >> 1;
                    int n2 = this.y;
                    this.spriteshiftregL[n2] = this.spriteshiftregL[n2] >> 1;
                }
                --this.y;
            }
            if (this.sprpxl == 0 || x < startdraw || !utils.getbit(this.ppuregs[1], 4)) continue;
            if (this.sprite0here && this.index == 0 && this.bitmap[bufferoffset + x] != this.bgcolor && x < 255) {
                this.sprite0hit = true;
                this.sprite0x = x;
            }
            if (this.spritebgflags[this.index] && this.bitmap[bufferoffset + x] != this.bgcolor) continue;
            this.bitmap[bufferoffset + x] = this.pal[this.spritepals[this.index] + this.sprpxl];
        }
    }

    private int getattrtbl(int ntstart, int tileX, int tileY) {
        int base = this.mapper.ppuRead(ntstart + (tileX >> 2) + 8 * (tileY >> 2));
        if (utils.getbit(tileY, 1)) {
            if (utils.getbit(tileX, 1)) {
                return base >> 6 & 3;
            }
            return base >> 4 & 3;
        }
        if (utils.getbit(tileX, 1)) {
            return base >> 2 & 3;
        }
        return base & 3;
    }

    public final void debugdraw() {
        int j;
        int i;
        boolean tilemode = true;
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.newBuff.setRGB(i * 8, j * 8, 8, 8, this.oldgettile(this.mapper.ppuRead(8192 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.newBuff.setRGB(i * 8 + 255, j * 8, 8, 8, this.oldgettile(this.mapper.ppuRead(9216 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.newBuff.setRGB(i * 8, j * 8 + 239, 8, 8, this.oldgettile(this.mapper.ppuRead(10240 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.newBuff.setRGB(i * 8 + 255, j * 8 + 239, 8, 8, this.oldgettile(this.mapper.ppuRead(11264 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        this.debuggui.setFrame(this.newBuff);
    }

    public final int[] oldgettile(int patterntblptr) {
        int[] dat = new int[64];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                dat[8 * i + j] = (utils.getbit(this.mapper.ppuRead(i + patterntblptr), 7 - j) ? 0x555555 : 0) + (utils.getbit(this.mapper.ppuRead(i + patterntblptr + 8), 7 - j) ? 0xAAAAAA : 0);
            }
        }
        return dat;
    }

    public final void renderFrame(GUIInterface gui) {
        gui.setFrame(this.bitmap, this.bgcolors, this.dotcrawl);
    }

    public final int[] getTile(int tileptr, int paletteindex, int off) {
        this.tilepal[0] = this.bgcolor;
        System.arraycopy(this.pal, paletteindex + 1, this.tilepal, 1, 3);
        int linelowbits = this.mapper.ppuRead(off + tileptr);
        int linehighbits = this.mapper.ppuRead(off + tileptr + 8);
        for (int j = 7; j >= 0; --j) {
            this.tiledata[j] = this.tilepal[((linehighbits & 1) << 1) + (linelowbits & 1)];
            linehighbits >>= 1;
            linelowbits >>= 1;
        }
        return this.tiledata;
    }

    public final int getspritehit() {
        return this.sprite0x < 255 ? this.sprite0x : -1;
    }
}

