/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.APU;
import com.grapeshot.halfnes.CPU;
import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.ControllerInterface;
import com.grapeshot.halfnes.FileUtils;
import com.grapeshot.halfnes.FrameLimiterImpl;
import com.grapeshot.halfnes.FrameLimiterInterface;
import com.grapeshot.halfnes.GUIImpl;
import com.grapeshot.halfnes.GUIInterface;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.ROMLoader;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.prefs.Preferences;

public class NES {
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private Mapper mapper;
    private APU apu;
    private CPU cpu;
    private CPURAM cpuram;
    private PPU ppu;
    private ControllerInterface controller1;
    private ControllerInterface controller2;
    public static final String VERSION = "0.051";
    public boolean runEmulation = false;
    private boolean dontSleep = false;
    public long frameStartTime;
    public long framecount;
    public long frameDoneTime;
    private boolean frameLimiterOn = true;
    private String curRomPath;
    private String curRomName;
    private final GUIInterface gui = new GUIImpl(this);
    private FrameLimiterInterface limiter = new FrameLimiterImpl(this);
    Runnable render = new Runnable(){

        @Override
        public void run() {
            NES.this.gui.render();
        }
    };

    public NES() {
        try {
            EventQueue.invokeAndWait(this.gui);
        }
        catch (InterruptedException e) {
            System.err.println("Could not initialize GUI. Exiting.");
            System.exit(-1);
        }
        catch (InvocationTargetException f) {
            System.err.println(f.getCause().toString());
            System.exit(-1);
        }
    }

    public void run(String romtoload) {
        Thread.currentThread().setPriority(6);
        this.curRomPath = romtoload;
        this.loadROM(romtoload);
        this.run();
    }

    public void run() {
        while (true) {
            if (this.runEmulation) {
                this.frameStartTime = System.nanoTime();
                this.runframe();
                if (this.frameLimiterOn && !this.dontSleep) {
                    this.limiter.sleep();
                }
                this.frameDoneTime = System.nanoTime() - this.frameStartTime;
                continue;
            }
            this.limiter.sleepFixed();
            if (this.ppu == null || this.framecount <= 1L) continue;
            EventQueue.invokeLater(this.render);
        }
    }

    public synchronized void runframe() {
        int scanline;
        int scanlinectrfire = 256;
        if (utils.getbit(this.ppu.ppuregs[0], 7)) {
            this.cpu.runcycle(241, 9000);
            this.cpu.nmi();
        }
        for (scanline = 241; scanline < 261; ++scanline) {
            this.cpu.cycle(scanline, 256);
            this.mapper.notifyscanline(scanline);
            this.cpu.cycle(scanline, 341);
        }
        this.ppu.ppuregs[2] = this.ppu.ppuregs[2] & 0x80;
        this.cpu.cycle(261, 30);
        this.ppu.ppuregs[2] = this.ppu.ppuregs[2] & 0x9F;
        this.cpu.cycle(261, 256);
        this.mapper.notifyscanline(261);
        this.cpu.cycle(261, (this.framecount & 1L) == 1L && utils.getbit(this.ppu.ppuregs[1], 3) ? 340 : 341);
        this.dontSleep = this.apu.bufferHasLessThan(1000);
        this.apu.finishframe();
        this.cpu.modcycles();
        for (scanline = 0; scanline < 240; ++scanline) {
            if (!this.ppu.drawLine(scanline)) {
                this.cpu.cycle(scanline, 256);
                this.mapper.notifyscanline(scanline);
            } else {
                int sprite0x = this.ppu.getspritehit();
                if (sprite0x < 256) {
                    this.cpu.cycle(scanline, sprite0x);
                    this.ppu.ppuregs[2] = this.ppu.ppuregs[2] | 0x40;
                    this.cpu.cycle(scanline, 256);
                    this.mapper.notifyscanline(scanline);
                } else {
                    this.cpu.cycle(scanline, 256);
                    this.mapper.notifyscanline(scanline);
                    this.cpu.cycle(scanline, sprite0x);
                    this.ppu.ppuregs[2] = this.ppu.ppuregs[2] | 0x40;
                }
            }
            this.cpu.cycle(scanline, 341);
        }
        this.cpu.cycle(240, 256);
        this.mapper.notifyscanline(240);
        this.cpu.cycle(240, 341);
        this.ppu.ppuregs[2] = this.ppu.ppuregs[2] | 0x80;
        this.ppu.renderFrame(this.gui);
        if ((this.framecount & 0x7FFL) == 0L) {
            this.saveSRAM(true);
        }
        ++this.framecount;
    }

    public void setControllers(ControllerInterface controller1, ControllerInterface controller2) {
        this.controller1 = controller1;
        this.controller2 = controller2;
    }

    public void toggleFrameLimiter() {
        this.frameLimiterOn = !this.frameLimiterOn;
    }

    public synchronized void loadROM(String filename) {
        Mapper newmapper;
        this.runEmulation = false;
        if (!FileUtils.exists(filename) || !FileUtils.getExtension(filename).equalsIgnoreCase(".nes")) {
            this.gui.messageBox("Could not load file:\nFile " + filename + "\ndoes not exist or is not a valid NES game.");
            return;
        }
        try {
            if (!FileUtils.getExtension(filename).equalsIgnoreCase(".nes")) {
                throw new BadMapperException("ROM is not a valid NES game");
            }
            ROMLoader loader = new ROMLoader(filename);
            loader.parseInesheader();
            newmapper = Mapper.getCorrectMapper(loader);
            newmapper.setLoader(loader);
            newmapper.loadrom();
        }
        catch (BadMapperException e) {
            this.gui.messageBox("Error Loading File: ROM is corrupted or uses an unsupported mapper.\n" + e.getMessage());
            return;
        }
        if (this.apu != null) {
            this.apu.destroy();
            this.saveSRAM(false);
            this.mapper.destroy();
            this.cpu = null;
            this.cpuram = null;
            this.ppu = null;
        }
        this.mapper = newmapper;
        this.cpuram = this.mapper.getCPURAM();
        this.cpu = this.mapper.cpu;
        this.ppu = this.mapper.ppu;
        this.apu = new APU(this, this.cpu, this.cpuram);
        this.cpuram.setAPU(this.apu);
        this.cpuram.setPPU(this.ppu);
        this.curRomPath = filename;
        this.curRomName = FileUtils.getFilenamefromPath(filename);
        this.framecount = 0L;
        if (this.mapper.hasSRAM()) {
            this.loadSRAM();
        }
        this.cpu.init();
        this.runEmulation = true;
    }

    private void saveSRAM(boolean async) {
        if (this.mapper != null && this.mapper.hasSRAM() && this.mapper.supportsSaves()) {
            if (async) {
                FileUtils.asyncwritetofile(this.mapper.getPRGRam(), FileUtils.stripExtension(this.curRomPath) + ".sav");
            } else {
                FileUtils.writetofile(this.mapper.getPRGRam(), FileUtils.stripExtension(this.curRomPath) + ".sav");
            }
        }
    }

    private void loadSRAM() {
        String name = FileUtils.stripExtension(this.curRomPath) + ".sav";
        if (FileUtils.exists(name) && this.mapper.supportsSaves()) {
            this.mapper.setPRGRAM(FileUtils.readfromfile(name));
        }
    }

    public void quit() {
        if (this.cpu != null && this.curRomPath != null) {
            this.runEmulation = false;
            this.saveSRAM(false);
        }
        System.exit(0);
    }

    public synchronized void reset() {
        if (this.cpu != null) {
            this.mapper.reset();
            this.cpu.reset();
            this.runEmulation = true;
            this.apu.pause();
            this.apu.resume();
        }
        this.framecount = 0L;
    }

    public synchronized void reloadROM() {
        this.loadROM(this.curRomPath);
    }

    public synchronized void pause() {
        if (this.apu != null) {
            this.apu.pause();
        }
        this.runEmulation = false;
    }

    public long getFrameTime() {
        return this.frameDoneTime;
    }

    public String getrominfo() {
        if (this.mapper != null) {
            return this.mapper.getrominfo();
        }
        return null;
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    public synchronized void frameAdvance() {
        this.runEmulation = false;
        if (this.cpu != null) {
            this.runframe();
        }
    }

    public synchronized void resume() {
        if (this.apu != null) {
            this.apu.resume();
        }
        if (this.cpu != null) {
            this.runEmulation = true;
        }
    }

    public String getCurrentRomName() {
        return this.curRomName;
    }

    public boolean isFrameLimiterOn() {
        return this.frameLimiterOn;
    }

    public void messageBox(String string) {
        this.gui.messageBox(string);
    }

    public ControllerInterface getcontroller1() {
        return this.controller1;
    }

    public ControllerInterface getcontroller2() {
        return this.controller2;
    }

    void setApuVol() {
        if (this.apu != null) {
            this.apu.setParameters();
        }
    }
}

