/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    public static String getExtension(File f) {
        return FileUtils.getExtension(f.getName());
    }

    public static String getExtension(String s) {
        if (s == null || s.equals("")) {
            return "";
        }
        int split = s.lastIndexOf(".");
        if (split < 0) {
            return "";
        }
        return s.substring(split);
    }

    public static String stripExtension(File f) {
        String s = f.getName();
        if (s == null || s.equals("")) {
            return "";
        }
        int split = s.lastIndexOf(".");
        if (split < 0) {
            return "";
        }
        return s.substring(0, split);
    }

    public static String stripExtension(String s) {
        if (s == null || s.equals("")) {
            return "";
        }
        int split = s.lastIndexOf(".");
        if (split < 0) {
            return "";
        }
        return s.substring(0, split);
    }

    public static void writetofile(int[] array, String path) {
        AsyncWriter writer = new AsyncWriter(array, path);
        writer.run();
    }

    public static void asyncwritetofile(int[] array, String path) {
        AsyncWriter writer = new AsyncWriter(array, path);
        EventQueue.invokeLater(writer);
    }

    public static String getFilenamefromPath(String path) {
        return new File(path).getName();
    }

    public static int[] readfromfile(String path) {
        File f = new File(path);
        byte[] bytes = new byte[(int)f.length()];
        try {
            FileInputStream fis = new FileInputStream(f);
            fis.read(bytes);
            fis.close();
        }
        catch (IOException e) {
            System.err.println("Failed to load file");
            e.printStackTrace();
        }
        int[] ints = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ints[i] = (short)(bytes[i] & 0xFF);
        }
        return ints;
    }

    public static boolean exists(String path) {
        return new File(path).canRead();
    }

    private static class AsyncWriter
    implements Runnable {
        private int[] a;
        private String path;

        public AsyncWriter(int[] a, String path) {
            this.a = a;
            this.path = path;
        }

        @Override
        public void run() {
            if (this.a != null && this.path != null) {
                try {
                    FileOutputStream b = new FileOutputStream(this.path);
                    byte[] buf = new byte[this.a.length];
                    for (int i = 0; i < this.a.length; ++i) {
                        buf[i] = (byte)(this.a[i] & 0xFF);
                    }
                    b.write(buf);
                    b.flush();
                    b.close();
                }
                catch (IOException e) {
                    System.err.print("Could not save. ");
                    System.err.println(e);
                }
            }
        }
    }
}

