/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.APU;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.mappers.Mapper;
import java.util.Arrays;

public class CPURAM {
    private boolean hasprgram = true;
    private final int[] wram = new int[2048];
    Mapper mapper;
    public APU apu;
    PPU ppu;

    public CPURAM(Mapper mappy) {
        this.mapper = mappy;
        Arrays.fill(this.wram, 255);
    }

    public final int read(int addr) {
        if (addr > 16408) {
            return this.mapper.cartRead(addr);
        }
        if (addr <= 8191) {
            return this.wram[addr & 0x7FF];
        }
        if (addr <= 16383) {
            return this.ppu.read(addr & 7);
        }
        if (16384 <= addr && addr <= 16408) {
            return this.apu.read(addr - 16384);
        }
        return addr >> 8;
    }

    public final void write(int addr, int data) {
        if (addr > 16408) {
            this.mapper.cartWrite(addr, data);
        } else if (addr <= 8191) {
            this.wram[addr & 0x7FF] = data;
        } else if (addr <= 16383) {
            this.ppu.write(addr & 7, data);
        } else if (16384 <= addr && addr <= 16408) {
            this.apu.write(addr - 16384, data);
        }
    }

    public void setPrgRAMEnable(boolean b) {
        this.hasprgram = b;
    }

    public void setAPU(APU apu) {
        this.apu = apu;
    }

    public void setPPU(PPU ppu) {
        this.ppu = ppu;
    }
}

