/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.AudioOutInterface;
import com.grapeshot.halfnes.CPU;
import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.SwingAudioImpl;
import com.grapeshot.halfnes.audio.ExpansionSoundChip;
import com.grapeshot.halfnes.audio.NoiseTimer;
import com.grapeshot.halfnes.audio.SquareTimer;
import com.grapeshot.halfnes.audio.Timer;
import com.grapeshot.halfnes.audio.TriangleTimer;
import com.grapeshot.halfnes.utils;

public class APU {
    public int samplerate = 1;
    private final Timer[] timers = new Timer[]{new SquareTimer(8, 2), new SquareTimer(8, 2), new TriangleTimer(), new NoiseTimer()};
    private double cyclespersample;
    public final NES nes;
    CPU cpu;
    CPURAM cpuram;
    private int apucycle = 0;
    private int remainder = 0;
    private static final int[] noiseperiod = new int[]{4, 8, 16, 32, 64, 96, 128, 160, 202, 254, 380, 508, 762, 1016, 2034, 4068};
    private long accum = 0L;
    private ExpansionSoundChip expnSound;
    private boolean soundFiltering;
    private final int[] tnd_lookup;
    private final int[] square_lookup;
    private AudioOutInterface ai;
    private static final int[][] dutylookup = new int[][]{{0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 1, 1, 1}};
    private int framectrdiv = 7456;
    boolean derp = false;
    private int dckiller = 0;
    int lpaccum = 0;
    private boolean apuintflag = true;
    private boolean statusdmcint = false;
    private boolean statusframeint = false;
    private int framectr = 0;
    private int ctrmode = 4;
    private boolean[] lenCtrEnable = new boolean[]{true, true, true, true};
    private int[] volume = new int[]{0, 0, 0, 0};
    private static final int[] dmcperiods = new int[]{428, 380, 340, 320, 286, 254, 226, 214, 190, 160, 142, 128, 106, 84, 72, 54};
    private int dmcrate = 54;
    private int dmcpos = 0;
    private int dmcshiftregister = 0;
    private int dmcbuffer = 0;
    private int dmcvalue = 0;
    private int dmcsamplelength = 0;
    private int dmcsamplesleft = 0;
    private int dmcstartaddr = 49152;
    private int dmcaddr = 49152;
    private int dmcbitsleft = 8;
    private boolean dmcsilence = true;
    private boolean dmcirq = false;
    private boolean dmcloop = false;
    private boolean dmcBufferEmpty = true;
    private final int[] lengthctr = new int[]{0, 0, 0, 0};
    private static final int[] lenctrload = new int[]{10, 254, 20, 2, 40, 4, 80, 6, 160, 8, 60, 10, 14, 12, 26, 14, 12, 16, 24, 18, 48, 20, 96, 22, 192, 24, 72, 26, 16, 28, 32, 30};
    private final boolean[] lenctrHalt = new boolean[]{true, true, true, true};
    private int linearctr = 0;
    private int linctrreload = 0;
    private boolean linctrflag = false;
    private final int[] envelopeValue = new int[]{15, 15, 15, 15};
    private final int[] envelopeCounter = new int[]{0, 0, 0, 0};
    private final int[] envelopePos = new int[]{0, 0, 0, 0};
    private final boolean[] envConstVolume = new boolean[]{true, true, true, true};
    private final boolean[] envelopeStartFlag = new boolean[]{false, false, false, false};
    private final boolean[] sweepenable = new boolean[]{false, false};
    private final boolean[] sweepnegate = new boolean[]{false, false};
    private final boolean[] sweepsilence = new boolean[]{false, false};
    private final boolean[] sweepreload = new boolean[]{false, false};
    private final int[] sweepperiod = new int[]{15, 15};
    private final int[] sweepshift = new int[]{0, 0};
    private final int[] sweeppos = new int[]{0, 0};

    public APU(NES nes, CPU cpu, CPURAM cpuram) {
        int i;
        this.square_lookup = new int[31];
        for (i = 0; i < this.square_lookup.length; ++i) {
            this.square_lookup[i] = (int)(95.52 / (8128.0 / (double)i + 100.0) * 49151.0);
        }
        this.tnd_lookup = new int[203];
        for (i = 0; i < this.tnd_lookup.length; ++i) {
            this.tnd_lookup[i] = (int)(163.67 / (24329.0 / (double)i + 100.0) * 49151.0);
        }
        this.nes = nes;
        this.cpu = cpu;
        this.cpuram = cpuram;
        this.setParameters();
    }

    public final synchronized void setParameters() {
        this.soundFiltering = this.nes.getPrefs().getBoolean("soundFiltering", false);
        this.samplerate = this.nes.getPrefs().getInt("sampleRate", 44100);
        this.cyclespersample = 1789773.0 / (double)this.samplerate;
        if (this.ai != null) {
            this.ai.destroy();
        }
        this.ai = new SwingAudioImpl(this.nes, this.samplerate);
    }

    public boolean bufferHasLessThan(int samples) {
        return this.ai.bufferHasLessThan(samples);
    }

    public final int read(int addr) {
        this.updateto(this.cpu.cycles);
        switch (addr) {
            case 21: {
                int returnval = (this.lengthctr[0] > 0 ? 1 : 0) + (this.lengthctr[1] > 0 ? 2 : 0) + (this.lengthctr[2] > 0 ? 4 : 0) + (this.lengthctr[3] > 0 ? 8 : 0) + (this.dmcsamplesleft > 0 ? 16 : 0) + (this.statusframeint ? 64 : 0) + (this.statusdmcint ? 128 : 0);
                if (this.statusframeint) {
                    --this.cpu.interrupt;
                    this.statusframeint = false;
                }
                return returnval;
            }
            case 22: {
                this.nes.getcontroller1().strobe();
                return this.nes.getcontroller1().getbyte() | 0x40;
            }
            case 23: {
                this.nes.getcontroller2().strobe();
                return this.nes.getcontroller2().getbyte() | 0x40;
            }
        }
        return 64;
    }

    public void addExpnSound(ExpansionSoundChip chip) {
        this.expnSound = chip;
    }

    public void destroy() {
        this.ai.destroy();
    }

    public void pause() {
        this.ai.pause();
    }

    public void resume() {
        this.ai.resume();
    }

    public final void write(int reg, int data) {
        this.updateto(this.cpu.cycles - 1);
        switch (reg) {
            case 0: {
                this.lenctrHalt[0] = utils.getbit(data, 5);
                this.timers[0].setduty(dutylookup[data >> 6]);
                this.envConstVolume[0] = utils.getbit(data, 4);
                this.envelopeValue[0] = data & 0xF;
                break;
            }
            case 1: {
                this.sweepenable[0] = utils.getbit(data, 7);
                this.sweepperiod[0] = data >> 4 & 7;
                this.sweepnegate[0] = utils.getbit(data, 3);
                this.sweepshift[0] = data & 7;
                this.sweepreload[0] = true;
                break;
            }
            case 2: {
                this.timers[0].setperiod((this.timers[0].getperiod() & 0xFE00) + (data << 1));
                break;
            }
            case 3: {
                if (this.lenCtrEnable[0]) {
                    this.lengthctr[0] = lenctrload[data >> 3];
                }
                this.timers[0].setperiod((this.timers[0].getperiod() & 0x1FF) + ((data & 7) << 9));
                this.timers[0].reset();
                this.envelopeStartFlag[0] = true;
                break;
            }
            case 4: {
                this.lenctrHalt[1] = utils.getbit(data, 5);
                this.timers[1].setduty(dutylookup[data >> 6]);
                this.envConstVolume[1] = utils.getbit(data, 4);
                this.envelopeValue[1] = data & 0xF;
                break;
            }
            case 5: {
                this.sweepenable[1] = utils.getbit(data, 7);
                this.sweepperiod[1] = data >> 4 & 7;
                this.sweepnegate[1] = utils.getbit(data, 3);
                this.sweepshift[1] = data & 7;
                this.sweepreload[1] = true;
                break;
            }
            case 6: {
                this.timers[1].setperiod((this.timers[1].getperiod() & 0xFE00) + (data << 1));
                break;
            }
            case 7: {
                if (this.lenCtrEnable[1]) {
                    this.lengthctr[1] = lenctrload[data >> 3];
                }
                this.timers[1].setperiod((this.timers[1].getperiod() & 0x1FF) + ((data & 7) << 9));
                this.timers[1].reset();
                this.envelopeStartFlag[1] = true;
                break;
            }
            case 8: {
                this.linctrreload = data & 0x7F;
                this.lenctrHalt[2] = utils.getbit(data, 7);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.timers[2].setperiod(((this.timers[2].getperiod() * 1 & 0xFF00) + data) / 1);
                break;
            }
            case 11: {
                if (this.lenCtrEnable[2]) {
                    this.lengthctr[2] = lenctrload[data >> 3];
                }
                this.timers[2].setperiod(((this.timers[2].getperiod() * 1 & 0xFF) + ((data & 7) << 8)) / 1);
                this.linctrflag = true;
                break;
            }
            case 12: {
                this.lenctrHalt[3] = utils.getbit(data, 5);
                this.envConstVolume[3] = utils.getbit(data, 4);
                this.envelopeValue[3] = data & 0xF;
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                this.timers[3].setduty(utils.getbit(data, 7) ? 6 : 1);
                this.timers[3].setperiod(noiseperiod[data & 0xF]);
                break;
            }
            case 15: {
                if (this.lenCtrEnable[3]) {
                    this.lengthctr[3] = lenctrload[data >> 3];
                }
                this.envelopeStartFlag[3] = true;
                break;
            }
            case 16: {
                this.dmcirq = utils.getbit(data, 7);
                this.dmcloop = utils.getbit(data, 6);
                this.dmcrate = dmcperiods[data & 0xF];
                if (this.dmcirq || !this.statusdmcint) break;
                --this.cpu.interrupt;
                this.statusdmcint = false;
                break;
            }
            case 17: {
                this.dmcvalue = data & 0x7F;
                break;
            }
            case 18: {
                this.dmcstartaddr = (data << 6) + 49152;
                break;
            }
            case 19: {
                this.dmcsamplelength = (data << 4) + 1;
                break;
            }
            case 20: {
                this.cpuram.write(8195, 0);
                for (int i = 0; i < 256; ++i) {
                    this.cpuram.write(8196, this.cpuram.read((data << 8) + i));
                }
                this.cpu.cycles += 513;
                break;
            }
            case 21: {
                for (int i = 0; i < 4; ++i) {
                    this.lenCtrEnable[i] = utils.getbit(data, i);
                    if (this.lenCtrEnable[i]) continue;
                    this.lengthctr[i] = 0;
                }
                if (utils.getbit(data, 4)) {
                    if (this.dmcsamplesleft == 0) {
                        this.restartdmc();
                    }
                } else {
                    this.dmcsamplesleft = 0;
                    this.dmcsilence = true;
                }
                if (!this.statusdmcint) break;
                --this.cpu.interrupt;
                this.statusdmcint = false;
                break;
            }
            case 22: {
                this.nes.getcontroller1().output(utils.getbit(data, 0));
                this.nes.getcontroller2().output(utils.getbit(data, 0));
                break;
            }
            case 23: {
                this.ctrmode = utils.getbit(data, 7) ? 5 : 4;
                this.apuintflag = utils.getbit(data, 6);
                this.framectr = 0;
                this.framectrdiv = 7464;
                if (this.apuintflag && this.statusframeint) {
                    this.statusframeint = false;
                    --this.cpu.interrupt;
                }
                if (this.ctrmode != 5) break;
                this.setenvelope();
                this.setlinctr();
                this.setlength();
                this.setsweep();
            }
        }
    }

    public final synchronized void updateto(int cpucycle) {
        if (this.soundFiltering) {
            while (this.apucycle < cpucycle) {
                ++this.remainder;
                this.clockdmc();
                if (--this.framectrdiv <= 0) {
                    this.framectrdiv = 7456;
                    this.clockframecounter();
                }
                this.timers[0].clock();
                this.timers[1].clock();
                if (this.lengthctr[2] > 0 && this.linearctr > 0) {
                    this.timers[2].clock();
                }
                this.timers[3].clock();
                if (this.expnSound != null) {
                    this.expnSound.clock(1);
                }
                this.accum += (long)this.getOutputLevel();
                if ((double)this.apucycle % this.cyclespersample < 1.0) {
                    this.ai.outputSample(this.lowpass_filter(this.highpass_filter((int)(this.accum / (long)this.remainder))));
                    this.remainder = 0;
                    this.accum = 0L;
                }
                ++this.apucycle;
            }
        } else {
            while (this.apucycle < cpucycle) {
                ++this.remainder;
                this.clockdmc();
                if (--this.framectrdiv <= 0) {
                    this.framectrdiv = 7456;
                    this.clockframecounter();
                }
                if ((double)this.apucycle % this.cyclespersample < 1.0) {
                    this.timers[0].clock(this.remainder);
                    this.timers[1].clock(this.remainder);
                    if (this.lengthctr[2] > 0 && this.linearctr > 0) {
                        this.timers[2].clock(this.remainder);
                    }
                    this.timers[3].clock(this.remainder);
                    int mixvol = this.getOutputLevel();
                    if (this.expnSound != null) {
                        this.expnSound.clock(this.remainder);
                    }
                    this.remainder = 0;
                    this.ai.outputSample(this.lowpass_filter(this.highpass_filter(mixvol)));
                }
                ++this.apucycle;
            }
        }
    }

    private int getOutputLevel() {
        int vol = this.square_lookup[this.volume[0] * this.timers[0].getval() + this.volume[1] * this.timers[1].getval()];
        vol += this.tnd_lookup[3 * this.timers[2].getval() + 2 * this.volume[3] * this.timers[3].getval() + this.dmcvalue];
        if (this.expnSound != null) {
            vol = (int)((double)vol * 0.8);
            vol += this.expnSound.getval();
        }
        return vol;
    }

    private int highpass_filter(int sample) {
        this.dckiller -= (sample += this.dckiller) >> 8;
        this.dckiller += sample > 0 ? -1 : 1;
        return sample;
    }

    private int lowpass_filter(int sample) {
        this.lpaccum = (int)((double)this.lpaccum - (double)(sample += this.lpaccum) * 0.99);
        return this.lpaccum;
    }

    public final void finishframe() {
        this.updateto(29781);
        this.apucycle = 0;
        this.ai.flushFrame(this.nes.isFrameLimiterOn());
    }

    private void clockframecounter() {
        if (this.ctrmode == 4 || this.ctrmode == 5 && this.framectr != 3) {
            this.setenvelope();
            this.setlinctr();
        }
        if (this.ctrmode == 4 && (this.framectr == 1 || this.framectr == 3) || this.ctrmode == 5 && (this.framectr == 1 || this.framectr == 4)) {
            this.setlength();
            this.setsweep();
        }
        if (!this.apuintflag && this.framectr == 3 && this.ctrmode == 4 && !this.statusframeint) {
            ++this.cpu.interrupt;
            this.statusframeint = true;
        }
        ++this.framectr;
        this.framectr %= this.ctrmode;
        this.setvolumes();
    }

    private void setvolumes() {
        int n = this.lengthctr[0] <= 0 || this.sweepsilence[0] ? 0 : (this.volume[0] = this.envConstVolume[0] ? this.envelopeValue[0] : this.envelopeCounter[0]);
        int n2 = this.lengthctr[1] <= 0 || this.sweepsilence[1] ? 0 : (this.volume[1] = this.envConstVolume[1] ? this.envelopeValue[1] : this.envelopeCounter[1]);
        this.volume[3] = this.lengthctr[3] <= 0 ? 0 : (this.envConstVolume[3] ? this.envelopeValue[3] : this.envelopeCounter[3]);
    }

    private void clockdmc() {
        if (this.dmcBufferEmpty && this.dmcsamplesleft > 0) {
            this.dmcfillbuffer();
        }
        ++this.dmcpos;
        this.dmcpos %= this.dmcrate;
        if (this.dmcpos == 0) {
            if (this.dmcbitsleft <= 0) {
                this.dmcbitsleft = 8;
                if (this.dmcBufferEmpty) {
                    this.dmcsilence = true;
                } else {
                    this.dmcsilence = false;
                    this.dmcshiftregister = this.dmcbuffer;
                    this.dmcBufferEmpty = true;
                }
            }
            if (!this.dmcsilence) {
                this.dmcvalue += utils.getbit(this.dmcshiftregister, 0) ? 2 : -2;
                if (this.dmcvalue > 127) {
                    this.dmcvalue = 127;
                }
                if (this.dmcvalue < 0) {
                    this.dmcvalue = 0;
                }
                this.dmcshiftregister >>= 1;
                --this.dmcbitsleft;
            }
        }
    }

    private void dmcfillbuffer() {
        if (this.dmcsamplesleft > 0) {
            this.dmcbuffer = this.cpuram.read(this.dmcaddr++);
            this.dmcBufferEmpty = false;
            this.cpu.cycles += 2;
            if (this.dmcaddr > 65535) {
                this.dmcaddr = 32768;
            }
            --this.dmcsamplesleft;
            if (this.dmcsamplesleft == 0) {
                if (this.dmcloop) {
                    this.restartdmc();
                } else if (this.dmcirq && !this.statusdmcint) {
                    ++this.cpu.interrupt;
                    this.statusdmcint = true;
                }
            }
        } else {
            this.dmcsilence = true;
        }
    }

    private void restartdmc() {
        this.dmcaddr = this.dmcstartaddr;
        this.dmcsamplesleft = this.dmcsamplelength;
        this.dmcsilence = false;
    }

    private void setlength() {
        for (int i = 0; i < 4; ++i) {
            if (this.lenctrHalt[i] || this.lengthctr[i] <= 0) continue;
            int n = i;
            this.lengthctr[n] = this.lengthctr[n] - 1;
            if (this.lengthctr[i] != 0) continue;
            this.setvolumes();
        }
    }

    private void setlinctr() {
        if (this.linctrflag) {
            this.linearctr = this.linctrreload;
        } else if (this.linearctr > 0) {
            --this.linearctr;
        }
        if (!this.lenctrHalt[2]) {
            this.linctrflag = false;
        }
    }

    private void setenvelope() {
        for (int i = 0; i < 4; ++i) {
            if (this.envelopeStartFlag[i]) {
                this.envelopeStartFlag[i] = false;
                this.envelopePos[i] = this.envelopeValue[i] + 1;
                this.envelopeCounter[i] = 15;
            } else {
                int n = i;
                this.envelopePos[n] = this.envelopePos[n] - 1;
            }
            if (this.envelopePos[i] > 0) continue;
            this.envelopePos[i] = this.envelopeValue[i] + 1;
            if (this.envelopeCounter[i] > 0) {
                int n = i;
                this.envelopeCounter[n] = this.envelopeCounter[n] - 1;
                continue;
            }
            if (!this.lenctrHalt[i] || this.envelopeCounter[i] > 0) continue;
            this.envelopeCounter[i] = 15;
        }
    }

    private void setsweep() {
        for (int i = 0; i < 2; ++i) {
            this.sweepsilence[i] = false;
            if (this.sweepreload[i]) {
                this.sweepreload[i] = false;
                this.sweeppos[i] = this.sweepperiod[i];
            }
            int n = i;
            this.sweeppos[n] = this.sweeppos[n] + 1;
            int rawperiod = this.timers[i].getperiod() >> 1;
            int shiftedperiod = rawperiod >> this.sweepshift[i];
            if (this.sweepnegate[i]) {
                shiftedperiod = -shiftedperiod + i;
            }
            if (rawperiod < 8 || (shiftedperiod += rawperiod) > 2047) {
                this.sweepsilence[i] = true;
                continue;
            }
            if (!this.sweepenable[i] || this.sweepshift[i] == 0 || this.lengthctr[i] <= 0 || this.sweeppos[i] <= this.sweepperiod[i]) continue;
            this.sweeppos[i] = 0;
            this.timers[i].setperiod(shiftedperiod << 1);
        }
    }
}

