Name{number}
	script - AdvanceMAME Script Machine

	AdvanceMAME support a scripting language to control external
	device like lamps, keyboard leds...
	You can assign a simple script at various events like key press,
	game led state change or others.
	When the event is triggered the script is started.

Grammar
	The scripts use a C like grammar.

Scripts
	These are the available scripts:
		script_video - The video mode is set. It's the first event
			triggered.
		script_emulation - The emulation start. It's triggered after
			the MAME confirmation screens.
		script_play - The game play start. It happens after the
			`sync_startuptime'.
		script_led1,2,3 - The led controlled by the emulated
			game is enabled.
		script_turbo - The turbo button is pressed.
		script_coin1,2,3,4 - A coin button is pressed.
		script_start1,2,3,4 - A start button is pressed.
		script_safequit - The game enter in the safequit status.
		script_event1-14 - The events controlled by the
			event system.

	You can assign a script at every event. The script is started
	when the event is triggered.

Values
	You have two type of values. Numerical integer values and text
	string values.

	The numerical values are expressed with the following formats:
		... - Number in decimal format.
		0x... - Number in hexadecimal format.
		0b... - Number in binary format.

	The text values are expressed with the following formats:
		"..." - String.

	Examples:
		10 - Decimal format of 10.
		0xA - Hexadecimal format of 10.
		0b1010 - Binary format of 10.
		"Text" - Generic string.

Operators
	The values can be combined in expressions using some operators.

	For numerical values the following operators are available:
		+ - Addition.
		- - Subtraction.
		& - Bitwise and.
		| - Bitwise or.
		^ - Bitwise xor.
		~ - Bitwise not.
		&& - Logical and.
		|| - Logical or.
		! - Logical not.
		< - Less.
		> - Greater.
		== - Equal.
		<= - Less or equal.
		>= - Greater or equal.

	For string values the following operators are available:
		+ - Concatenation.

Commands
	These are the available commands:
		while (CONDITION) { ... } - Repeat until CONDITION is not 0.
		if (CONDITION) { ...  } - Execute if CONDITIDION is not 0.
		loop { ... } - Repeat forever.
		repeat (N) { ... } - Repeat N times.
		wait(CONDITION) - Wait until the CONDITION is not 0.
		delay(N) - Wait the specified N milliseconds.

	The 'wait()' and 'delay()' commands are used to maintain the
	synchronization with the game emulation. When these commands
	are executed, the script is temporarily suspended. All others
	commands are executed continuously without any delay.

	The granularity of the delay command is the frame rate period.
	Approx. 16 ms for a 60 Hz game. Delays under this limit may
	don't have the desired effect.

	IT'S VERY IMPORTANT THAT EVERY 'loop', 'while' AND 'repeat'
	COMMANDS CONTAIN A 'delay()' CALL. Otherwise the script may
	loop forever and the executable will lock! For example the
	statement :

		:loop { toggle(0, 1); }

	completely STOP the emulation and you CAN'T EXIT from the program.
	A correct one is :

		:loop { toggle(0, 1); delay(100); }

Functions
	These are the available functions:
		event() - Return 0 if the event that started the
			script is terminated. Return 1 if the event
			is active.
		event(EVENT) - Return 0 if the specified event is
			not active. Return 1 if the event is active.
		simulate_event(EVENT,NUMBER) - Simulate the specified
			event for NUMBER milli seconds.
		simulate_key(KEY,NUMBER) - Simulate the specified key for
			NUMBER milli seconds.
		log(VALUE) - Output a texr or number value in the log file.
		msg(VALUE) - Print on screen a a text or number value.
		system(TEXT) - Execute the specified command TEXT as a
			shell script. Return the exit code.
		lcd(ROW_NUMBER, VALUE) - Display a value on the LCD at the
			specified row. The first row is 0.
		rand(NUMBER) - Generate a random number from 0
			to NUMBER - 1.

	The 'event()' command can be used to determine the end of the event
	that started the script. For example for the 'coin1' event the
	function return 0 when the key is released.

Ports
	External devices can be controlled using the keyboard led
	or the PC ports, like the parallel port.

	Generally the parallel ports are mapped at the addresses
	0x378, 0x278 and 0x3bc. To maintain the same interface the
	keyboard leds are mapped to the virtual port 0 at the
	lower 3 bits. All the other ports are mapped to the PC
	hardware ports.

	These are the available functions to read and write the ports:

		set(ADDRESS, VALUE) - Set the port with the specified value.
		get(ADDRESS) - Return the value of the port
		on(ADDRESS, VALUE) - Enable the active bits in VALUE.
			Like set(ADDRESS, get(ADDRESS) | VALUE).
		off(ADDRESS, VALUE) - Disable the active bits in VALUE.
			Like set(ADDRESS, get(ADDRESS) & ~VALUE).
		toggle(ADDRESS, VALUE) - Toggle the active bits in VALUE.
			Like set(ADDRESS, get(ADDRESS) ^ VALUE).

	In DOS the hardware ports are accessed directly. In Linux 386
	they are directly accessed if you are root, otherwise they
	are accessed using the /dev/port interface. In Windows you
	cannot access the hardware ports. On other systems you can
	access the ports if the inb() and outb() C functions are
	available on your system.

Symbols
	This is the complete list of all the predefinite symbols
	available.

	These are the event symbols available for the
	`simulate_event(EVENT, TIME)' and `event(EVENT)'
	commands :
		EVENT - p1_up, p1_down, p1_left, p1_right, p2_up, p2_down,
			p2_left, p2_right, p1_button1, p1_button2, p1_button3,
			p1_button4, p1_button5, p1_button6, p1_button7,
			p1_button8, p1_button9, p1_button10, p2_button1,
			p2_button2, p2_button3, p2_button4, p2_button5,
			p2_button6, p2_button7, p2_button8, p2_button9,
			p2_button10, start1, start2, start3, start4, coin1,
			coin2, coin3, coin4, service_coin1, service_coin2,
			service_coin3, service_coin4, service, tilt.

	These are the user interface event symbols available for
	the `simulate_event(EVENT, TIME)' and `event(EVENT)'
	commands :
		EVENT - ui_mode_next, ui_mode_pred, ui_record_start,
			ui_record_stop, ui_turbo, ui_cocktail, ui_configure,
			ui_on_screen_display, ui_pause, ui_reset_machine,
			ui_show_gfx, ui_frameskip_dec, ui_frameskip_inc,
			ui_throttle, ui_show_fps, ui_snapshot, ui_toggle_cheat,
			ui_up, ui_down, ui_left, ui_right, ui_select,
			ui_cancel, ui_pan_up, ui_pan_down, ui_pan_left,
			ui_pan_right, ui_show_profiler, ui_show_colors,
			ui_toggle_ui, ui_toggle_debug, ui_save_state,
			ui_load_state, ui_add_cheat, ui_delete_cheat,
			ui_save_cheat, ui_watch_value.

	These are the keyboard symbols available for the
	`simulate_key(EVENT, TIME)' command :
		EVENT - key_a, key_b, key_c, key_d, key_e, key_f, key_g,
			key_h, key_i, key_j, key_k, key_l, key_m, key_n,
			key_o, key_p, key_q, key_r, key_s, key_t, key_u,
			key_v, key_w, key_x, key_y, key_z, key_0, key_1,
			key_2, key_3, key_4, key_5, key_6, key_7, key_8,
			key_9, key_0_pad, key_1_pad, key_2_pad, key_3_pad,
			key_4_pad, key_5_pad, key_6_pad, key_7_pad,
			key_8_pad, key_9_pad, key_f1, key_f2, key_f3,
			key_f4, key_f5, key_f6, key_f7, key_f8, key_f9,
			key_f10, key_f11, key_f12, key_esc, key_backquote,
			key_minus, key_equals, key_backspace, key_tab,
			key_openbrace, key_closebrace, key_enter, key_semicolon,
			key_quote, key_backslash, key_less, key_comma,
			key_period, key_slash, key_space, key_insert, key_del,
			key_home, key_end, key_pgup, key_pgdn, key_left,
			key_right, key_up, key_down, key_slash_pad,
			key_asterisk_pad, key_minus_pad, key_plus_pad,
			key_period_pad, key_enter_pad, key_prtscr, key_pause,
			key_lshift, key_rshift, key_lcontrol, key_rcontrol,
			key_lalt, key_ralt, key_scrlock, key_numlock,
			key_capslock, key_lwin, key_rwin, key_menu.

	These are text symbols containing some game and emulation
	information:
		info_desc - The game title. For example "PacMan".
		info_manufacturer - The game manufacturer. For example "Namco".
		info_year - The game year. For example "1980".
		info_throttle - The current game speed. For example "100%".

Examples
	This script clears all the keyboard leds at the emulation end :

		:script_video wait(!event()); set(0,0);

	Activate all the parallel data bits when the game start, flash
	the bit 0 during the emulation and clear them then the game
	stop :

		:script_start \
		:	set(0x378, 0xff); \
		:	while(event()) { \
		:		toggle(0x378, 1); \
		:		delay(500); \
		:	} \
		:	set(0x378, 0);

	Map the first MAME led to the first keyboard led:

		:script_led1 on(0, 0b1); wait(!event()); off(0, 0b1);

	Map the second MAME led to the first keyboard led:

		:script_led2 on(0, 0b10); wait(!event()); off(0, 0b10);

	Flash the third keyboard led when the 'turbo' is active :

		:script_turbo \
		:	while (event()) { \
		:		toggle(0, 0b100); \
		:		delay(500); \
		:	} \
		:	off(0, 0b100);

	Light the third keyboard led when the 'coin1' key is pressed :

		:script_coin1 on(0, 0b100); delay(500); off(0, 0b100);

	Add 3 coins automatically:

		:script_play \
		:	delay(1000); \
		:	repeat(3) { \
		:		simulate_event(coin1,100); \
		:		delay(200); \
		:	}

	Add a coin when the player start:

		:script_start1 \
		:	wait(!event());
		:	simulate_event(coin1,100); \
		:	delay(500); \
		:	simulate_event(start1,100);

	Display continously the game speed on the LCD:

		:script_video loop { lcd(0,"Speed " + info_throttle); delay(1000); }

Configuration
	The scripts must be inserted in the 'advmame.rc' file. You can split
	complex scripts terminating any splitted row with the `\' char.

	For example:

		:script_video wait(!event()); set(0,0);
		:script_led1 on(0, 0b1); wait(!event()); off(0, 0b1);
		:script_led2 on(0, 0b10); wait(!event()); off(0, 0b10);
		:script_coin1 on(0, 0b100); delay(500); off(0, 0b100);
		:script_turbo \
		:	while (event()) { \
		:		toggle(0, 0b100); \
		:		delay(500); \
		:	} \
		:	off(0, 0b100);
		:script_start1 \
		:	set(0x378, 0xff); \
		:	while(event()) { \
		:		toggle(0x378, 1); \
		:		delay(500); \
		:	} \
		:	set(0x378, 0);
		:script_video loop { \
		:		lcd(0,"Speed " + info_throttle); \
		:		delay(1000); \
		:	}

Copyright
	This file is Copyright (C) 2003, 2004 Andrea Mazzoleni.

