/**
 * Mupen64 - gr4300.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "assemble.h"
#include "../r4300.h"
#include "../macros.h"
#include "../../memory/memory.h"
#include "../interupt.h"
#include "../ops.h"
#include "../recomph.h"

static unsigned long pjump_code = (unsigned long)(jump_code);
static unsigned long pjump_to = (unsigned long)(jump_to);

static unsigned long pgen_vi = (unsigned long)(gen_vi);
//static unsigned long pexrsp = (unsigned long)(exrsp);
static unsigned long pdebug = (unsigned long)(debug);
void genupdate_system(int type)
{  
   if (type) {
      mov_eax_memoffs32((void *)(&Count)); //eax <- Count
      cmp_reg32_m32(EAX, (unsigned long *)(&next_interupt)); //if(next_interupt == Count)
      jb_rj(16);
      mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
      call_m32((unsigned long *)(&pgen_vi));
   }
   
   inc_m32((unsigned long *)&Count); // Count = (++Count) & 0xFFFFFFFF;
   //add_m32_imm32((unsigned long *)&Count, 4);
   
   //cmp_m8_imm8((unsigned char *)(&(sp_register.halt)), 0); //if(!sp_register.halt)
   //jne_rj(0x06);
   //call_m32((unsigned long *)(&pexrsp)); // exrsp();

#ifdef EMU64_DEBUG
   // ****************************debug***********************************
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pdebug));
   // ********************************************************************
#endif
}

static unsigned long pNI = (unsigned long)(NI);
void genni()
{
   dst->local_addr = code_length;
#ifdef EMU64_DEBUG
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pNI));
   genupdate_system(0);
#else
   nop(); nop(); nop(); nop(); nop(); nop(); nop(); nop();
   nop(); nop(); nop(); nop(); nop(); nop(); nop(); nop();
   nop(); nop(); nop(); nop();
#endif
}

static unsigned long pRESERVED = (unsigned long)(RESERVED);
void genreserved()
{
   dst->local_addr = code_length;
#ifdef EMU64_DEBUG
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pRESERVED));
   genupdate_system(0);
#endif
}

static unsigned long pFIN_BLOCK = (unsigned long)(FIN_BLOCK);
void genfin_block()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pFIN_BLOCK));
   genupdate_system(0);
}

void gennop()
{
   /*if (!dst_block->vide[((dst->addr >> 16) & 0xFF)])
     {*/
	dst->local_addr = code_length;
	genupdate_system(0);
//}
}

void genbeql()
{
   unsigned long temp, temp2, temp3;
   recomp_jump=0;
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt));
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs));
   jne_near_rj(0);
   temp=code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs)+1);
   jne_near_rj(0);
   temp2=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp3=code_length;
   code_length=temp-4;
   put32(temp3-temp);
   code_length=temp2-4;
   put32(temp3-temp2);
   code_length=temp3;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}

void genbnel()
{
   unsigned long temp, temp2;
   recomp_jump = 0;
   dst->local_addr = code_length;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt));
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs));
   jne_rj(17);
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs)+1);
   je_near_rj(0);
   
   temp=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp2=code_length;
   code_length = temp-4;
   put32(temp2-temp);
   code_length = temp2;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}

void genblezl()
{
   unsigned long temp, temp2, temp3;
   recomp_jump = 0;
   dst->local_addr = code_length;
   cmp_m32_imm32((unsigned long *)(dst->f.i.rs)+1, 0);
   jl_rj(0x20);
   cmp_m32_imm32((unsigned long *)(dst->f.i.rs)+1, 0);
   jne_near_rj(0);
   
   temp=code_length;
   
   cmp_m32_imm32((unsigned long *)(dst->f.i.rs), 0);
   jne_near_rj(0);
   temp2=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp3=code_length;
   code_length = temp-4;
   put32(temp3-temp);
   code_length = temp2-4;
   put32(temp3-temp2);
   code_length = temp3;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}

void genbgtzl()
{
   unsigned long temp, temp2, temp3;
   recomp_jump = 0;
   dst->local_addr = code_length;
   cmp_m32_imm32((unsigned long *)(dst->f.i.rs)+1, 0);
   jl_near_rj(0);
   
   temp=code_length;
   
   cmp_m32_imm32((unsigned long *)(dst->f.i.rs)+1, 0);
   jg_rj(16);
   cmp_m32_imm32((unsigned long *)(dst->f.i.rs), 0);
   je_near_rj(0);
   temp2=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp3=code_length;
   code_length = temp-4;
   put32(temp3-temp);
   code_length = temp2-4;
   put32(temp3-temp2);
   code_length = temp3;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}

void genlw()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);   
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EAX, 16);
   mov_reg32_preg32x4pimm32(EAX, EAX, (unsigned long)(readmem));
   cmp_eax_imm32((unsigned long)(read_rdram));
   je_rj(35);
   
   mov_m32_reg32((unsigned long *)(&address), EBX);
   mov_m32_imm32((unsigned long *)(&rdword), (unsigned long)dst->f.i.rt);
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EAX);
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt));
   jmp_imm_short(17);
   
   and_reg32_imm32(EBX, 0xFFFFFF);
   mov_reg32_preg32pimm32(EAX, EBX, (unsigned long)(rdram));
   mov_memoffs32_eax((unsigned long *)dst->f.i.rt);
   
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   genupdate_system(0);
}

static unsigned long pLWL = (unsigned long)(LWL);
void genlwl()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pLWL));
   genupdate_system(0);
}

static unsigned long pLWR = (unsigned long)(LWR);
void genlwr()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pLWR));
   genupdate_system(0);
}

static unsigned long pSWL = (unsigned long)(SWL);
void genswl()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pSWL));
   genupdate_system(0);
}

static unsigned long pSWR = (unsigned long)(SWR);
void genswr()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pSWR));
   genupdate_system(0);
}

static unsigned long pSC = (unsigned long)(SC);
void gensc()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pSC));
   genupdate_system(0);
}

void genlb()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EAX, 16);
   mov_reg32_preg32x4pimm32(EAX, EAX, (unsigned long)(readmemb));
   cmp_eax_imm32((unsigned long)(read_rdramb));
   je_rj(37);

   mov_m32_reg32((unsigned long *)(&address), EBX);
   mov_m32_imm32((unsigned long *)(&rdword), (unsigned long)dst->f.i.rt);
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EAX);
   movsx_reg32_m8(EAX, (unsigned char *)dst->f.i.rt);
   jmp_imm_short(18);
   
   and_reg32_imm32(EBX, 0xFFFFFF);
   xor_reg8_imm8(BL, 0x3);
   mov_reg32_preg32pimm32(EAX, EBX, (unsigned long)(rdram));
   movsx_reg32_reg8(EAX, AL);
   
   mov_memoffs32_eax((unsigned long *)dst->f.i.rt);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   genupdate_system(0);
}

void genlh()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EAX, 16);
   mov_reg32_preg32x4pimm32(EAX, EAX, (unsigned long)(readmemh));
   cmp_eax_imm32((unsigned long)(read_rdramh));
   je_rj(37);
   
   mov_m32_reg32((unsigned long *)(&address), EBX);
   mov_m32_imm32((unsigned long *)(&rdword), (unsigned long)dst->f.i.rt);
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EAX);
   movsx_reg32_m16(EAX, (unsigned short *)dst->f.i.rt);
   jmp_imm_short(16);
   
   and_reg32_imm32(EBX, 0xFFFFFF);
   xor_reg8_imm8(BL, 0x2);
   mov_reg32_preg32pimm32(EAX, EBX, (unsigned long)(rdram));
   cwde();
   
   mov_memoffs32_eax((unsigned long *)dst->f.i.rt);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   genupdate_system(0);
}

void genlbu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EAX, 16);
   mov_reg32_preg32x4pimm32(EAX, EAX, (unsigned long)(readmemb));
   cmp_eax_imm32((unsigned long)(read_rdramb));
   je_rj(36);
   
   mov_m32_reg32((unsigned long *)(&address), EBX);
   mov_m32_imm32((unsigned long *)(&rdword), (unsigned long)dst->f.i.rt);
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EAX);
   mov_reg32_m32(EAX, (unsigned long *)dst->f.i.rt);
   jmp_imm_short(15);
   
   and_reg32_imm32(EBX, 0xFFFFFF);
   xor_reg8_imm8(BL, 3);
   mov_reg32_preg32pimm32(EAX, EBX, (unsigned long)(rdram));
   
   and_eax_imm32(0xFF);
   mov_memoffs32_eax((unsigned long *)dst->f.i.rt);
   mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   genupdate_system(0);
}

void genlhu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EAX, 16);
   mov_reg32_preg32x4pimm32(EAX, EAX, (unsigned long)(readmemh));
   cmp_eax_imm32((unsigned long)(read_rdramh));
   je_rj(36);
   
   mov_m32_reg32((unsigned long *)(&address), EBX);
   mov_m32_imm32((unsigned long *)(&rdword), (unsigned long)dst->f.i.rt);
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EAX);
   mov_reg32_m32(EAX, (unsigned long *)dst->f.i.rt);
   jmp_imm_short(15);
   
   and_reg32_imm32(EBX, 0xFFFFFF);
   xor_reg8_imm8(BL, 0x2);
   mov_reg32_preg32pimm32(EAX, EBX, (unsigned long)(rdram));
   
   and_eax_imm32(0xFFFF);
   mov_memoffs32_eax((unsigned long *)dst->f.i.rt);
   mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   genupdate_system(0);
}

void gensb()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EBX, 16);
   mov_reg32_preg32x4pimm32(EBX, EBX, (unsigned long)(writememb));
   cmp_reg32_imm32(EBX, (unsigned long)(write_rdramb));
   je_rj(29);
   
   mov_memoffs32_eax((unsigned long *)(&address));
   mov_al_memoffs8((unsigned char *)dst->f.i.rt);
   mov_memoffs8_al((unsigned char *)(&byte));
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EBX);
   jmp_imm_short(19);
   
   and_eax_imm32(0xFFFFFF);
   xor_al_imm8(0x3);
   mov_reg8_m8(BL, (unsigned char *)dst->f.i.rt);
   mov_preg32pimm32_reg8(EAX, (unsigned long)(rdram), BL);
   
   genupdate_system(0);
}

void gensh()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EBX, 16);
   mov_reg32_preg32x4pimm32(EBX, EBX, (unsigned long)(writememh));
   cmp_reg32_imm32(EBX, (unsigned long)(write_rdramh));
   je_rj(31);
   
   mov_memoffs32_eax((unsigned long *)(&address));
   mov_ax_memoffs16((unsigned short *)dst->f.i.rt);
   mov_memoffs16_ax((unsigned short *)(&hword));
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EBX);
   jmp_imm_short(20);
   
   and_eax_imm32(0xFFFFFF);
   xor_al_imm8(0x2);
   mov_reg32_m32(EBX, (unsigned long *)dst->f.i.rt);
   mov_preg32pimm32_reg16(EAX, (unsigned long)(rdram), BX);
   
   genupdate_system(0);
}

void gensw()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EBX, 16);
   mov_reg32_preg32x4pimm32(EBX, EBX, (unsigned long)(writemem));
   cmp_reg32_imm32(EBX, (unsigned long)(write_rdram));
   je_rj(29);
   
   mov_memoffs32_eax((unsigned long *)(&address));
   mov_eax_memoffs32((unsigned long *)dst->f.i.rt);
   mov_memoffs32_eax((unsigned long *)(&word));
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EBX);
   jmp_imm_short(17);
   
   and_eax_imm32(0xFFFFFF);
   mov_reg32_m32(EBX, (unsigned long *)dst->f.i.rt);
   mov_preg32pimm32_reg32(EAX, (unsigned long)(rdram), EBX);
   
   genupdate_system(0);
}

void genbne()
{
   recomp_jump=0;
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt));
   mov_memoffs32_eax((unsigned long *)(&local_rt));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rt)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_eax_memoffs32((void *)(&local_rt));
   cmp_reg32_m32(EAX, (void *)(&local_rs));
   jne_near(dst->addr + (dst-1)->f.i.immediate*4);
   
   mov_eax_memoffs32((unsigned long *)(&local_rt)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(&local_rs)+1);
   jne_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}

void genblez()
{
   recomp_jump=0;
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   cmp_m32_imm32((unsigned long *)((dst-1)->f.i.rs)+1, 0);
   jl_near(dst->addr + (dst-1)->f.i.immediate*4);
   cmp_m32_imm32((unsigned long *)((dst-1)->f.i.rs)+1, 0);
   jne_rj(0x10);
   cmp_m32_imm32((unsigned long *)((dst-1)->f.i.rs), 0);
   je_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}

static unsigned long pBLEZ_IDLE = (unsigned long)(BLEZ_IDLE);
void genblez_idle()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pBLEZ_IDLE));
   genupdate_system(0);
}

void genaddi()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   add_eax_imm32((unsigned long)(dst->f.i.immediate));
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt));
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   genupdate_system(0);
}

void genaddiu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   add_eax_imm32((unsigned long)(dst->f.i.immediate));
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt));
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   genupdate_system(0);
}

void gendaddiu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   add_eax_imm32((unsigned long)(dst->f.i.immediate));
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt));
   adc_reg32_m32(EAX, (unsigned long *)(dst->f.i.rt)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   genupdate_system(0);
}

void genslti()
{
   dst->local_addr = code_length;
   mov_ax_memoffs16((unsigned short *)(&dst->f.i.immediate));
   cwde();
   cdq();
   cmp_reg32_m32(EDX, (unsigned long *)(dst->f.i.rs)+1);
   je_rj(0x04);
   jl_rj(0x0A);
   jmp_imm_short(0x1E);
   
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs));
   ja_rj(0x16);
   
   mov_m32_imm32((unsigned long *)(dst->f.i.rt), 0);
   mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   jmp_imm_short(0x14);
   
   mov_m32_imm32((unsigned long *)(dst->f.i.rt), 1);
   mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   
   genupdate_system(0);
}

void gensltiu()
{
   dst->local_addr = code_length;
   mov_ax_memoffs16((unsigned short *)(&dst->f.i.immediate));
   cwde();
   cdq();
   cmp_reg32_m32(EDX, (unsigned long *)(dst->f.i.rs)+1);
   je_rj(0x04);
   jb_rj(0x0A);
   jmp_imm_short(0x1E);
   
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs));
   ja_rj(0x16);
   
   mov_m32_imm32((unsigned long *)(dst->f.i.rt), 0);
   mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   jmp_imm_short(0x14);
   
   mov_m32_imm32((unsigned long *)(dst->f.i.rt), 1);
   mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   
   genupdate_system(0);
}

void genandi()
{
   dst->local_addr = code_length;
   mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   mov_ax_memoffs16((unsigned short *)(dst->f.i.rs));
   and_eax_imm32((unsigned long)(dst->f.i.immediate) & 0xFFFF);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt));
   genupdate_system(0);
}

void genori()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   or_ax_imm16(dst->f.i.immediate);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt));
   genupdate_system(0);
}

void genxori()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   xor_ax_imm16(dst->f.i.immediate);
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt));
   genupdate_system(0);
}

void genlui()
{
   dst->local_addr = code_length;
   mov_m32_imm32((unsigned long *)(dst->f.i.rt),dst->f.i.immediate << 16);
   if ((dst->f.i.immediate & 0x8000))
     mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0xFFFFFFFF);
   else
     mov_m32_imm32((unsigned long *)(dst->f.i.rt)+1, 0);
   genupdate_system(0);
}

void genld()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EAX, 16);
   mov_reg32_preg32x4pimm32(EAX, EAX, (unsigned long)(readmemd));
   cmp_eax_imm32((unsigned long)(read_rdramd));
   je_rj(30);
   
   mov_m32_reg32((unsigned long *)(&address), EBX);
   mov_m32_imm32((unsigned long *)(&rdword), (unsigned long)dst->f.i.rt);
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EAX);
   jmp_imm_short(28);
   
   and_reg32_imm32(EBX, 0xFFFFFF);
   mov_reg32_preg32pimm32(EAX, EBX, (unsigned long)(rdram));
   mov_memoffs32_eax((unsigned long *)(dst->f.i.rt)+1);
   mov_reg32_preg32pimm32(EAX, EBX, (unsigned long)(rdram)+4);
   mov_memoffs32_eax((unsigned long *)dst->f.i.rt);
   
   genupdate_system(0);
}

void gensd()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   add_eax_imm32((long)dst->f.i.immediate);
   mov_reg32_reg32(EBX, EAX);
   shr_reg32_imm8(EBX, 16);
   mov_reg32_preg32x4pimm32(EBX, EBX, (unsigned long)(writememd));
   cmp_reg32_imm32(EBX, (unsigned long)(write_rdramd));
   je_rj(39);
   
   mov_memoffs32_eax((unsigned long *)(&address));
   mov_eax_memoffs32((unsigned long *)dst->f.i.rt);
   mov_memoffs32_eax((unsigned long *)(&dword));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt)+1);
   mov_memoffs32_eax((unsigned long *)(&dword)+1);
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst+1));
   
   call_reg32(EAX);
   jmp_imm_short(29);
   
   and_eax_imm32(0xFFFFFF);
   mov_reg32_m32(EBX, (unsigned long *)(dst->f.i.rt)+1);
   mov_preg32pimm32_reg32(EAX, (unsigned long)(rdram), EBX);
   mov_reg32_m32(EBX, (unsigned long *)dst->f.i.rt);
   mov_preg32pimm32_reg32(EAX, (unsigned long)(rdram)+4, EBX);
   
   genupdate_system(0);
}

void genj()
{
   unsigned long naddr;
   recomp_jump=1;
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&delay_slot), 3);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), (dst->f.j.inst_index<<2) 
		 | (dst->addr & 0xF0000000));
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   naddr = ((dst-1)->f.j.inst_index<<2) | (dst->addr & 0xF0000000);
   
   cmp_m32_imm32((unsigned long *)&(actual->start), naddr);
   ja_rj(17);
   cmp_m32_imm32((unsigned long *)&(actual->end), naddr);
   jb_rj(5);
   jmp(naddr);
   push_imm32(naddr);
   call_m32((unsigned long *)(&pjump_to));
   add_reg32_imm8(ESP, 4);
   jmp_m32((unsigned long *)(&pjump_code));

}

void genj_idle()
{
   unsigned long naddr, temp1, temp2, temp3;
   recomp_jump=1;
   dst->local_addr = code_length;
   
   cmp_m32_imm8((unsigned long *)(&sp_register.halt), 0);
   je_near_rj(0);
   
   temp1 = code_length;
   
   mov_eax_memoffs32((unsigned long *)(&next_interupt));
   sub_reg32_m32(EAX, (unsigned long *)(&Count));
   cmp_reg32_imm8(EAX, 3);
   jle_near_rj(0);
   
   temp2 = code_length;
   
   and_eax_imm32(0xFFFFFFFC);
   add_m32_reg32((unsigned long *)(&Count), EAX);
   jmp(dst->addr);
   
   temp3 = code_length;
   code_length = temp1-4;
   put32(temp3 - temp1);
   code_length = temp2-4;
   put32(temp3 - temp2);
   code_length = temp3;
   
   mov_m32_imm32((void *)(&delay_slot), 3);
   genupdate_system(0);
   mov_m32_imm32((void *)(&delay_slot), (dst->f.j.inst_index<<2) 
		 | (dst->addr & 0xF0000000));
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   naddr = ((dst-1)->f.j.inst_index<<2) | (dst->addr & 0xF0000000);
   
   cmp_m32_imm32((unsigned long *)&(actual->start), naddr);
   ja_rj(17);
   cmp_m32_imm32((unsigned long *)&(actual->end), naddr);
   jb_rj(5);
   jmp(naddr);
   push_imm32(naddr);
   call_m32((unsigned long *)(&pjump_to));
   add_reg32_imm8(ESP, 4);
   jmp_m32((unsigned long *)(&pjump_code));

}

void genjal()
{
   unsigned long naddr;
   recomp_jump=1;
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&delay_slot), 3);
   genupdate_system(0);
   mov_m32_imm32((void *)(&delay_slot), (dst->f.j.inst_index<<2) 
		 | (dst->addr & 0xF0000000));
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_m32_imm32((unsigned long *)(reg + 31), dst->addr + 4);
   if (((dst->addr + 4) & 0x80000000))
     mov_m32_imm32((unsigned long *)(&reg[31])+1, 0xFFFFFFFF);
   else
     mov_m32_imm32((unsigned long *)(&reg[31])+1, 0);
   
   naddr = ((dst-1)->f.j.inst_index<<2) | (dst->addr & 0xF0000000);
   
   cmp_m32_imm32((unsigned long *)&(actual->start), naddr);
   ja_rj(17);
   cmp_m32_imm32((unsigned long *)&(actual->end), naddr);
   jb_rj(5);
   jmp(naddr);
   push_imm32(naddr);
   call_m32((unsigned long *)(&pjump_to));
   add_reg32_imm8(ESP, 4);
   jmp_m32((unsigned long *)(&pjump_code));
}

void genbeq()
{
   recomp_jump = 0;
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt));
   mov_memoffs32_eax((unsigned long *)(&local_rt));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rt)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_eax_memoffs32((unsigned long *)(&local_rt));
   cmp_reg32_m32(EAX, (unsigned long *)(&local_rs));
   jne_rj(0x11);
   mov_eax_memoffs32((unsigned long *)(&local_rt)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(&local_rs)+1);
   je_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}

void genbeq_idle()
{
   unsigned long temp1, temp2, temp3, temp4, temp5;
   recomp_jump = 0;
   dst->local_addr = code_length;
   
   cmp_m32_imm8((unsigned long *)(&sp_register.halt), 0);
   je_near_rj(0);
   
   temp1 = code_length;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt));
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs));
   jne_near_rj(0);
   
   temp2 = code_length;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.i.rs)+1);
   jne_near_rj(0);
   
   temp3 = code_length;
   
   mov_eax_memoffs32((unsigned long *)(&next_interupt));
   sub_reg32_m32(EAX, (unsigned long *)(&Count));
   cmp_reg32_imm8(EAX, 3);
   jle_near_rj(0);
   
   temp4 = code_length;
   
   and_eax_imm32(0xFFFFFFFC);
   add_m32_reg32((unsigned long *)(&Count), EAX);
   jmp(dst->addr);
   
   temp5 = code_length;
   code_length = temp1-4;
   put32(temp5 - temp1);
   code_length = temp2-4;
   put32(temp5 - temp2);
   code_length = temp3-4;
   put32(temp5 - temp3);
   code_length = temp4-4;
   put32(temp5 - temp4);
   code_length = temp5;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt));
   mov_memoffs32_eax((unsigned long *)(&local_rt));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rt)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rt)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_eax_memoffs32((unsigned long *)(&local_rt));
   cmp_reg32_m32(EAX, (unsigned long *)(&local_rs));
   jne_rj(0x11);
   mov_eax_memoffs32((unsigned long *)(&local_rt)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(&local_rs)+1);
   je_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}

void genbgtz()
{
   dst->local_addr = code_length;
   recomp_jump=0;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   cmp_m32_imm32((unsigned long *)(&local_rs)+1, 0);
   jg_near(dst->addr + (dst-1)->f.i.immediate*4);
   jl_rj(16);
   cmp_m32_imm32((unsigned long *)(&local_rs),0);
   jg_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}
