/**
 * Mupen64 - recomph.h
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#ifndef RECOMPH_H
#define RECOMPH_H

#include "recomp.h"

extern int code_length;
extern int max_code_length;
extern unsigned char **inst_pointer;
extern precomp_block* dst_block;
extern unsigned char jump_code[10];
extern int jump_marker;
extern int recomp_jump;

void dyna_exception();
void passe2(precomp_instr *dest, int longueur);
void init_assembler();
void free_assembler();
void stop_it();
void check_eret();

void genupdate_system(int type);
void genbnel();
void genblezl();
void genlw();
void genlbu();
void genlhu();
void gensb();
void gensh();
void gensw();
void gencache();
void genlwc1();
void genld();
void gensd();
void genbeq();
void genbne();
void genblez();
void genaddi();
void genaddiu();
void genslti();
void gensltiu();
void genandi();
void genori();
void genxori();
void genlui();
void genbeql();
void genmul_s();
void gendiv_s();
void gencvt_d_s();
void genadd_d();
void gentrunc_w_d();
void gencvt_s_w();
void genmfc1();
void gencfc1();
void genmtc1();
void genctc1();
void genj();
void genjal();
void genslt();
void gensltu();
void gendsll32();
void gendsra32();
void genbgez();
void genbgezl();
void genbgezal();
void gentlbwi();
void generet();
void genmfc0();
void genadd_s();
void genmult();
void genmultu();
void genmflo();
void genmtlo();
void gendiv();
void gendmultu();
void genddivu();
void genadd();
void genaddu();
void gensubu();
void genand();
void genor();
void genxor();
void genreserved();
void gennop();
void gensll();
void gensrl();
void gensra();
void gensllv();
void gensrlv();
void genjr();
void genni();
void genmfhi();
void genmthi();
void genmtc0();
void genbltz();
void genlwl();
void genswl();
void gentlbp();
void gentlbr();
void genswr();
void genlwr();
void gensrav();
void genbgtz();
void genlb();
void genswc1();
void genldc1();
void gencvt_d_w();
void genmul_d();
void gensub_d();
void gendiv_d();
void gencvt_s_d();
void genmov_s();
void genc_le_s();
void genbc1t();
void gentrunc_w_s();
void genbc1tl();
void genc_lt_s();
void genbc1fl();
void genneg_s();
void genc_le_d();
void genbgezal_idle();
void genj_idle();
void genbeq_idle();
void genlh();
void genmov_d();
void genc_lt_d();
void genbc1f();
void gennor();
void genneg_d();
void gensub();
void genblez_idle();
void gendivu();
void gencvt_w_s();
void genbltzl();
void gensdc1();
void genc_eq_s();
void genjalr();
void gensub_s();
void gensqrt_s();
void genc_eq_d();
void gencvt_w_d();
void genfin_block();
void genddiv();
void gendaddiu();
void genbgtzl();
void gendsrav();
void gendsllv();
void gencvt_s_l();
void gendmtc1();
void gendsrlv();
void gendsra();
void gendmult();
void gendsll();
void genabs_s();
void gensc();

#endif
