/***************************************************************************
                          translation.c  -  description
                             -------------------
    copyright            : (C) 2003 by ShadowPrince
    email                : shadow@emulation64.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include <stdlib.h>
#define _WIN32_IE 0x0500
#include <commctrl.h>
#include "translation.h"
#include "../../winproject/resource.h"
#include "main_win.h"

#define LangFileName "Mupen64.lng"
static int LastLang = -1;

char *LngFilePath()
{
   static char *lngpath = NULL;
   if (lngpath == NULL)
     {
       	lngpath = malloc(strlen(AppPath)+1+strlen(LangFileName));
	    strcpy(lngpath, AppPath);
    	strcat(lngpath, LangFileName);
     }
   return lngpath;
}

void SelectLang(HWND hWnd, int LangMenuID) {
	char String[800];
	HMENU hMenu = GetMenu(hWnd);
	MENUITEMINFO menuinfo;

	menuinfo.cbSize = sizeof(MENUITEMINFO);
	menuinfo.fMask = MIIM_TYPE;
	menuinfo.fType = MFT_STRING;
	menuinfo.dwTypeData = String;
	menuinfo.cch = sizeof(String);
	GetMenuItemInfo(hMenu,LangMenuID,FALSE,&menuinfo);

	WritePrivateProfileString("Default","Language",String,LngFilePath());
	if (LastLang != -1) {
		CheckMenuItem( hMenu, LastLang, MF_BYCOMMAND | MFS_UNCHECKED );
	}
	LastLang = LangMenuID;
	CheckMenuItem( hMenu, LastLang, MF_BYCOMMAND | MFS_CHECKED );
}

void SetupLanguages ( HWND hWnd ) {
    char String[800], Language[100], *RP;
	HMENU hMenu = GetMenu(hWnd), hSubMenu,LanguagesPopup;
	MENUITEMINFO menuinfo;
	int count,i;
    
    GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LngFilePath());
	hSubMenu = GetSubMenu(hMenu,0);
	hSubMenu = GetSubMenu(hSubMenu,6);
	menuinfo.cbSize = sizeof(MENUITEMINFO);
	menuinfo.fMask = MIIM_TYPE|MIIM_ID;
	menuinfo.fType = MFT_STRING;
	menuinfo.fState = MFS_ENABLED;
	menuinfo.dwTypeData = String;
	menuinfo.cch = sizeof(hSubMenu);

  	memset(String,0,sizeof(String));
	GetPrivateProfileSectionNames(String,sizeof(String),LngFilePath());
    for (count = 1,RP = String; *RP != 0; RP += strlen(RP) + 1) {
		if (strcmp(RP,"Default") == 0) { continue; }
		if (strcmp(RP,"English") == 0) { 
		    if (strcmp(Language, "English") == 0) {
		  		    CheckMenuItem(hSubMenu, ID_LANG_ENGLISH, MF_BYCOMMAND | MFS_CHECKED );
		            LastLang = ID_LANG_ENGLISH;
        		}
            continue; 
        }
		menuinfo.dwTypeData = RP;
		menuinfo.cch = strlen(RP) + 1;
		menuinfo.wID = ID_LANG_ENGLISH + count;
		InsertMenuItem(hSubMenu, count++, TRUE, &menuinfo);
		if (strcmp(Language, RP) == 0) {
		  CheckMenuItem(hSubMenu, menuinfo.wID, MF_BYCOMMAND | MFS_CHECKED );
		  LastLang = menuinfo.wID;
        }
	}
}	

void Translate(char* GuiWord,char* Ret)
{
   TranslateDefault(GuiWord,"Not Found",Ret);
}

void TranslateDefault(char* GuiWord,char *Default,char* Ret)
{
   char Language[100];
   char Path[200];
   GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LngFilePath());
   sprintf(Path,"%sLang\\english.lng",AppPath);
   GetPrivateProfileString(Language,"Path",Path,Path,200,LngFilePath());
   GetPrivateProfileString(Language,GuiWord,Default,Ret,200,Path); 
   printf("\n");
}

void SetItemTranslatedString(HWND hwnd,int ElementID,char* Str)
{
    char String[800];
    Translate(Str,String);  
    if (strcmp(String,"Not Found")!=0) {
     SetDlgItemText( hwnd, ElementID, String );
    } 
    else {
     SetDlgItemText( hwnd, ElementID, Str ); 
    } 
}
void SetItemTranslatedStringDefault(HWND hwnd,int ElementID,char* Str,char*Def)
{
    char String[800];
    TranslateDefault(Str,Def,String);
    SetDlgItemText( hwnd, ElementID, String );
}


void SetStatusTranslatedString(HWND hStatus,int section,char* Str)
{
    char String[800];
    Translate(Str,String);  
    if (strcmp(String,"Not Found")!=0) {
     SendMessage( hStatus, SB_SETTEXT, section, (LPARAM)String );
    } 
    else {
     SendMessage( hStatus, SB_SETTEXT, section, (LPARAM)Str ); 
    }
}

void SetMenuTranslatedString(HMENU hMenu,int elementID,char* Str,char* Acc)
{
    char Language[100], String[800];
    MENUITEMINFO menuinfo;
    Translate(Str,String);
      if (strcmp(String,"Not Found")!=0) {
            if (strcmp(Acc,"")) sprintf(String, "%s   \t%s", String, Acc);
            
            memset(&menuinfo, 0, sizeof(MENUITEMINFO));
            menuinfo.cbSize = sizeof(MENUITEMINFO);
            menuinfo.fMask = MIIM_TYPE;
	        menuinfo.fType = MFT_STRING;
	        menuinfo.dwTypeData = String;
	        menuinfo.cch = sizeof(String);
            SetMenuItemInfo(hMenu,elementID,TRUE,&menuinfo);
            }
}

void TranslateMenu(HMENU hMenu,HWND mainHWND)
{
    char Language[100], String[800];
	MENUITEMINFO menuinfo;
    int	menuCount,i;
    HMENU submenu,subsubmenu;
    //Main menu
    SetMenuTranslatedString(hMenu,0,"File","");
    SetMenuTranslatedString(hMenu,1,"Run","");
    SetMenuTranslatedString(hMenu,2,"Options","");
    SetMenuTranslatedString(hMenu,3,"Utilities","");
    SetMenuTranslatedString(hMenu,4,"Help","");
    
    //File menu
    submenu = GetSubMenu(hMenu,0) ;
    SetMenuTranslatedString(submenu,0,"Load Rom","");
    SetMenuTranslatedString(submenu,1,"Close Rom","");
    SetMenuTranslatedString(submenu,2,"Refresh Rom List","Ctrl+R");
    SetMenuTranslatedString(submenu,4,"Recent Roms","");
    subsubmenu = GetSubMenu(submenu,4) ;
    SetMenuTranslatedString(subsubmenu,0,"Reset","");
    SetMenuTranslatedString(subsubmenu,1,"Freeze","");
    
    SetMenuTranslatedString(submenu,6,"Language","");
    SetMenuTranslatedString(submenu,7,"Language Information","");
    SetMenuTranslatedString(submenu,9,"Exit","");

    
    //Run menu
    submenu = GetSubMenu(hMenu,1);
    SetMenuTranslatedString(submenu,0,"Reset","F1");
    SetMenuTranslatedString(submenu,1,"Pause","F2");
    SetMenuTranslatedString(submenu,2,"Generate Bitmap","F3");
    SetMenuTranslatedString(submenu,4,"Save State","F5");
    SetMenuTranslatedString(submenu,5,"Save as","Ctrl+A");
    SetMenuTranslatedString(submenu,6,"Restore State","F7");
    SetMenuTranslatedString(submenu,7,"Load","Ctrl+L");
    SetMenuTranslatedString(submenu,9,"Current Save State","");
    
    //Options menu
    submenu = GetSubMenu(hMenu,2);
    SetMenuTranslatedString(submenu,0,"Configure","Ctrl+S");
    SetMenuTranslatedString(submenu,2,"Video Settings","");
    SetMenuTranslatedString(submenu,3,"Input Settings","");
    SetMenuTranslatedString(submenu,4,"Audio Settings","");
    SetMenuTranslatedString(submenu,5,"RSP Settings","");
    SetMenuTranslatedString(submenu,7,"Full Screen","Alt+Enter");

    //Utility menu
    submenu = GetSubMenu(hMenu,3);
    SetMenuTranslatedString(submenu,0,"ROM Properties","Ctrl+P");
    SetMenuTranslatedString(submenu,2,"Audit ROMs","");
    SetMenuTranslatedString(submenu,3,"Generate ROM Info","");
    SetMenuTranslatedString(submenu,4,"Show Log Window","");
            
    //Help menu
    submenu = GetSubMenu(hMenu,4);
    SetMenuTranslatedString(submenu,0,"Contents","");
    SetMenuTranslatedString(submenu,1,"Whats new","");
    SetMenuTranslatedString(submenu,3,"About","");
    DrawMenuBar(mainHWND);
}

void TranslateConfigDialog(HWND hwnd)
{
       
    SetItemTranslatedString(hwnd,IDC_GFXPLUGIN,"GFX Plugin");
    SetItemTranslatedString(hwnd,IDGFXCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDGFXTEST,"Test");
    SetItemTranslatedString(hwnd,IDGFXABOUT,"Plugin About");
    
    SetItemTranslatedString(hwnd,IDC_INPUTPLUGIN,"Input Plugin");
    SetItemTranslatedString(hwnd,IDINPUTCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDINPUTTEST,"Test");
    SetItemTranslatedString(hwnd,IDINPUTABOUT,"Plugin About");
    
    SetItemTranslatedString(hwnd,IDC_SOUNDPLUGIN,"Sound Plugin");
    SetItemTranslatedString(hwnd,IDSOUNDCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDSOUNDTEST,"Test");
    SetItemTranslatedString(hwnd,IDSOUNDABOUT,"Plugin About");
    
    SetItemTranslatedString(hwnd,IDC_RSPPLUGIN,"RSP Plugin");
    SetItemTranslatedString(hwnd,IDRSPCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDRSPTEST,"Test");
    SetItemTranslatedString(hwnd,IDRSPABOUT,"Plugin About");
  
}

void TranslateDirectoriesConfig(HWND hwnd)
{
    SetItemTranslatedString(hwnd,IDC_ROMS_DIRECTORIES,"Roms Directories");
    SetItemTranslatedString(hwnd,IDC_RECURSION,"Use directory recursion");
    SetItemTranslatedString(hwnd,IDC_ADD_BROWSER_DIR,"Add");
    SetItemTranslatedString(hwnd,IDC_REMOVE_BROWSER_DIR,"Remove");
    SetItemTranslatedString(hwnd,IDC_REMOVE_BROWSER_ALL,"Remove All");
    
    SetItemTranslatedString(hwnd,IDC_PLUGINS_GROUP,"Plugins Directory");
    //SetItemTranslatedString(hwnd,IDC_DEFAULT_PLUGINS_CHECK,"Default Plugins Check");
    SetItemTranslatedString(hwnd,IDC_CHOOSE_PLUGINS_DIR, "Choose" );
        
    SetItemTranslatedString(hwnd,IDC_SAVES_GROUP,"Saves Directory");
    //SetItemTranslatedString(hwnd,IDC_DEFAULT_SAVES_CHECK,"Default Saves Check");
    SetItemTranslatedString(hwnd,IDC_CHOOSE_SAVES_DIR,"Choose");
     
    SetItemTranslatedString(hwnd,IDC_SCREENSHOTS_GROUP,"Screenshots Directory");
    //SetItemTranslatedString(hwnd,IDC_DEFAULT_SCREENSHOTS_CHECK,"Default Screenshots Check");
    SetItemTranslatedString(hwnd,IDC_CHOOSE_SCREENSHOTS_DIR,"Choose");
}

void TranslateGeneralDialog(HWND hwnd)
{
    char tmp[200];
    SetItemTranslatedString(hwnd,IDC_MESSAGES,"Alerts");
    SetItemTranslatedString(hwnd,IDC_ALERTBADROM,"Alert Bad rom");
    SetItemTranslatedString(hwnd,IDC_ALERTHACKEDROM,"Alert Hacked rom");
    SetItemTranslatedString(hwnd,IDC_ALERTSAVESERRORS,"Alert Saves errors");

    SetItemTranslatedString(hwnd,IDC_FPSTITLE,"Fps / VIs");

    SetItemTranslatedString(hwnd,IDC_LIMITFPS,"Limit fps (auto)");
    SetItemTranslatedString(hwnd,IDC_SPEEDMODIFIER,"Use Speed Modifier");
    SetItemTranslatedString(hwnd,IDC_SHOWFPS,"Show FPS");
    SetItemTranslatedString(hwnd,IDC_SHOWVIS,"Show VIs");
    
    SetItemTranslatedString(hwnd,IDC_INTERP,"Interpreter");
    SetItemTranslatedString(hwnd,IDC_RECOMP,"Dynamic Recompiler");
    SetItemTranslatedString(hwnd,IDC_PURE_INTERP,"Pure Interpreter");
    SetItemTranslatedString(hwnd,IDC_CPUCORE,"CPU Core");
    SetItemTranslatedString(hwnd,IDC_INIFILE,"Ini File");
    SetItemTranslatedString(hwnd,IDC_INI_COMPRESSED,"Use compressed file");
    
}

void TranslateRomInfoDialog(HWND hwnd)
{
    char tmp[200];
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_HEADER_INFO_TEXT,"RP ROM Information","ROM Information:");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_FULLPATH_TEXT,"RP File Location","File Location:");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_GOODNAME_TEXT,"RP Good Name","Good Name:");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_INTERNAL_NAME_TEXT,"RP Internal Name","Internal Name:");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_SIZE_TEXT,"RP Size","Size:");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_COUNTRY_TEXT,"RP Country","Country:");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_INICODE_TEXT,"RP Ini Code","Ini Code:");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_MD5_TEXT,"RP MD5 Checksum","MD5 Checksum:");
    SetItemTranslatedStringDefault(hwnd,IDC_MD5_CALCULATE,"RP Calculate","Calculate");
    SetItemTranslatedStringDefault(hwnd,IDC_INI_COMMENTS_TEXT,"RP Comments","Comments:");
    SetItemTranslatedString(hwnd,IDC_OK,"Ok");
    SetItemTranslatedString(hwnd,IDC_CANCEL,"Cancel");
    TranslateDefault("ROM Properties","ROM Properties",tmp);
    SetWindowText(hwnd,tmp);
}

void TranslateRomBrowserMenu(HMENU hMenu)
{
    SetMenuTranslatedString(hMenu,0,"Play Game","");
    SetMenuTranslatedString(hMenu,1,"Rom Properties","");
    SetMenuTranslatedString(hMenu,3,"Refresh","");
}

void TranslateAuditDialog(HWND hwnd)
{
    char tmp[200];
    SetItemTranslatedString(hwnd,IDC_TOTAL_ROMS_TEXT,"Audit Total ROMs");
    SetItemTranslatedString(hwnd,IDC_CURRENT_ROM_TEXT,"Audit Current ROM");
    SetItemTranslatedString(hwnd,IDC_ROM_FULLPATH_TEXT,"Audit File Location");
    SetItemTranslatedString(hwnd,IDC_START,"Start");
    SetItemTranslatedString(hwnd,IDC_STOP,"Stop");
    SetItemTranslatedString(hwnd,IDC_CLOSE,"Close");
    TranslateDefault("Audit ROMs","Audit ROMs",tmp);
    SetWindowText(hwnd,tmp);
}

void TranslateLangInfoDialog( HWND hwnd )
{
    char tmp[200];
    SetItemTranslatedString(hwnd,IDC_LANG_AUTHOR_TEXT,"Translation Author TEXT");
    SetItemTranslatedString(hwnd,IDC_LANG_VERSION_TEXT,"Version TEXT");
    SetItemTranslatedString(hwnd,IDC_LANG_DATE_TEXT,"Creation Date TEXT");
    SetItemTranslatedString(hwnd,IDC_LANG_AUTHOR,"Translation Author");
    SetItemTranslatedString(hwnd,IDC_LANG_VERSION,"Version");
    SetItemTranslatedString(hwnd,IDC_LANG_DATE,"Creation Date");
    SetItemTranslatedString(hwnd,IDOK, "OK");
    TranslateDefault("Language Information Dialog","Language Information",tmp);
    SetWindowText(hwnd,tmp);
}

void TranslateAdvancedDialog(HWND hwnd) 
{
    SetItemTranslatedString(hwnd,IDC_STARTFULLSCREEN,"Start game in full screen");
    SetItemTranslatedString(hwnd,IDC_PAUSENOTACTIVE,"Pause when not active");
    SetItemTranslatedString(hwnd,IDC_PLUGIN_OVERWRITE,"Use global plugins settings");
    SetItemTranslatedString(hwnd,IDC_GUI_TOOLBAR,"Use toolbar");
    SetItemTranslatedString(hwnd,IDC_GUI_STATUSBAR,"Use statusbar");
    
    
    SetItemTranslatedString(hwnd,IDC_ROMBROWSERCOLUMNS,"Rombrowser Columns");
    SetItemTranslatedString(hwnd,IDC_COLUMN_GOODNAME,"GoodName");
    SetItemTranslatedString(hwnd,IDC_COLUMN_INTERNALNAME,"Internal Name");
    SetItemTranslatedString(hwnd,IDC_COLUMN_COUNTRY,"Country");
    SetItemTranslatedString(hwnd,IDC_COLUMN_SIZE,"Rom size");
    SetItemTranslatedString(hwnd,IDC_COLUMN_COMMENTS,"Comments");
    SetItemTranslatedString(hwnd,IDC_COLUMN_FILENAME,"File Name");
    SetItemTranslatedString(hwnd,IDC_COLUMN_MD5,"MD5");
         
}

