/***************************************************************************
                          config.c  -  description
                             -------------------
    begin                : Fri Nov 8 2002
    copyright            : (C) 2002 by blight
    email                : blight@Ashitaka
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"
#include "main_gtk.h"

#include "translate.h"

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void
config_read( void )
{
	int romdir = 0;
	FILE *f;
	char filename[PATH_MAX];
	char line[2048];
	char *p;

	memset( &g_Config, 0, sizeof( g_Config ) );
	g_Config.iCore = CORE_INTERPRETER;
	strcpy( g_Config.cLanguage, "English" );
	g_Config.iMainWindowHeight = 400;
	g_Config.iMainWindowWidth = 600;
	g_Config.iRomBrowserColWidth[0] = 200;
	g_Config.iRomBrowserColWidth[1] = 100;
	g_Config.iRomBrowserColWidth[2] = 70;
	g_Config.iRomBrowserColWidth[3] = 400;
	g_Config.iRomBrowserColWidth[4] = 400;

	sprintf( filename, "%sgui_gtk.conf", g_WorkingDir );
	f = fopen( filename, "r" );
	if( f == NULL )
		return;

	while( !feof( f ) )
	{
		if( !fgets( line, 2048, f ) )
			break;

		p = strchr( line, '\n' );
		if( p )
			*p = '\0';

		p = strchr( line, '=' );
		if( !p )
			continue;
		p++;

		if( !strncasecmp( line, "GfxPlugin=", 10 ) )
		{
			strncpy( g_Config.cGfxPlugin, p, PATH_MAX );
			continue;
		}
		if( !strncasecmp( line, "AudioPlugin=", 12 ) )
		{
			strncpy( g_Config.cAudioPlugin, p, PATH_MAX );
			continue;
		}
		if( !strncasecmp( line, "InputPlugin=", 12 ) )
		{
			strncpy( g_Config.cInputPlugin, p, PATH_MAX );
			continue;
		}
	        if( !strncasecmp( line, "RSPPlugin=", 10 ) )
		{
			strncpy( g_Config.cRSPPlugin, p, PATH_MAX );
			continue;
		}
		if( !strncasecmp( line, "Language=", 9 ) )
		{
			strncpy( g_Config.cLanguage, p, 200 );
			tr_set_language( g_Config.cLanguage );
			continue;
		}
		if( !strncasecmp( line, "RomDirsScanRecursive=", 17 ) )
		{
			sscanf( p, "%d", &g_Config.iRomDirsScanRecursive );
			continue;
		}
		if( !strncasecmp( line, "RomDir=", 7 ) )
		{
			strncpy( g_Config.cRomDir[romdir++], p, PATH_MAX );
			continue;
		}
		if( !strncasecmp( line, "Core=", 5 ) )
		{
			if( !strcasecmp( p, "Interpreter" ) )
				g_Config.iCore = CORE_INTERPRETER;
			else if( !strcasecmp( p, "Dynamic Recompiler" ) )
				g_Config.iCore = CORE_DYNAREC;
			else if( !strcasecmp( p, "Pure Interpreter" ) )
				g_Config.iCore = CORE_PURE_INTERPRETER;
			continue;
		}
		if( !strncasecmp( line, "RomBrowser.colWidth[", 20 ) && line[21] == ']' )
		{
			int i = line[20] - '0';
			if( i >= 0 && i < 5 )
			{
				sscanf( p, "%d", g_Config.iRomBrowserColWidth + i );
			}
			continue;
		}
		if( !strncasecmp( line, "MainWindow.width=", 17 ) )
		{
			sscanf( p, "%d", &g_Config.iMainWindowWidth );
			continue;
		}
		if( !strncasecmp( line, "MainWindow.height=", 18 ) )
		{
			sscanf( p, "%d", &g_Config.iMainWindowHeight );
			continue;
		}
	}
	fclose( f );
}

void
config_write( void )
{
	FILE *f;
	char filename[PATH_MAX];
	int i;
	char real_path[PATH_MAX];

	sprintf( filename, "%sgui_gtk.conf", g_WorkingDir );
	f = fopen( filename, "w" );
	if( !f )
		return;

	fprintf( f, "Core=%s\n", (g_Config.iCore == CORE_DYNAREC) ? "Dynamic Recompiler" :
				 ((g_Config.iCore == CORE_PURE_INTERPRETER) ? "Pure Interpreter" : "Interpreter") );

	fprintf( f, "Language=%s\n", g_Config.cLanguage );
	fprintf( f, "MainWindow.width=%d\n", g_Config.iMainWindowWidth );
	fprintf( f, "MainWindow.height=%d\n", g_Config.iMainWindowHeight );

	if( !realpath( g_Config.cGfxPlugin, real_path ) )
		real_path[0] = '\0';
	fprintf( f, "GfxPlugin=%s\n", real_path );

	if( !realpath( g_Config.cAudioPlugin, real_path ) )
		real_path[0] = '\0';
	fprintf( f, "AudioPlugin=%s\n", real_path );

	if( !realpath( g_Config.cInputPlugin, real_path ) )
		real_path[0] = '\0';
	fprintf( f, "InputPlugin=%s\n", real_path );
   
        if( !realpath( g_Config.cRSPPlugin, real_path ) )
		real_path[0] = '\0';
	fprintf( f, "RSPPlugin=%s\n", real_path );

	fprintf( f, "RomDirsScanRecursive=%d\n", g_Config.iRomDirsScanRecursive );
	for( i = 0; i < 5; i++ )
		fprintf( f, "RomBrowser.colWidth[%d]=%d\n", i, g_Config.iRomBrowserColWidth[i] );

	for( i = 0; i < MAX_ROMDIRS && g_Config.cRomDir[i][0]; i++ )
		fprintf( f, "RomDir=%s\n", g_Config.cRomDir[i] );

	fclose( f );
}
