/**
 * Mupen64 - dma.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "dma.h"
#include "memory.h"
#include "../main/rom.h"
#include <stdio.h>
#include "../r4300/r4300.h"
#include "../r4300/interupt.h"
#include "../r4300/macros.h"
#include <malloc.h>
#include "pif.h"
#include "flashram.h"
#include "../main/guifuncs.h"

static unsigned char sram[0x8000];

void dma_pi_read()
{
   int i;
   if (pi_register.pi_cart_addr_reg >= 0x08000000 &&
       pi_register.pi_cart_addr_reg < 0x08010000)
     {
	if (use_flashram != 1)
	  {
	     char *filename;
	     FILE *f;
	     filename = malloc(strlen(get_savespath())+
			       strlen(ROM_SETTINGS.goodname)+4+1);
	     strcpy(filename, get_savespath());
	     strcat(filename, ROM_SETTINGS.goodname);
	     strcat(filename, ".sra");
	     f = fopen(filename, "rb");
	     if (f)
	       {
		  fread(sram, 1, 0x8000, f);
		  fclose(f);
	       }
	     else for (i=0; i<0x8000; i++) sram[i] = 0;
	     for (i=0; i<(pi_register.pi_rd_len_reg & 0xFFFFFF)+1; i++)
	       sram[((pi_register.pi_cart_addr_reg-0x08000000)+i)^S8]=
	       ((unsigned char*)rdram)[(pi_register.pi_dram_addr_reg+i)^S8];
	     f = fopen(filename, "wb");
	     fwrite(sram, 1, 0x8000, f);
	     fclose(f);
	     free(filename);
	     use_flashram = -1;
	  }
	else
	  dma_write_flashram();
     }
   else
     printf("unknown dma read\n");
   if (!dynacore)
     {
	pi_register.read_pi_status_reg |= 1;
	update_count();
	add_interupt_event(PI_INT, pi_register.pi_rd_len_reg);
     }
   else
     {
	MI_register.mi_intr_reg |= 0x10;
	gen_mi();
     }
}

void dma_pi_write()
{
   unsigned long longueur;
   //int i, new_blk = 0;
   
   if (pi_register.pi_cart_addr_reg < 0x10000000)
     {
	if (pi_register.pi_cart_addr_reg >= 0x08000000 &&
	    pi_register.pi_cart_addr_reg < 0x08010000)
	  {
	     if (use_flashram != 1)
	       {
		  char *filename;
		  FILE *f;
		  int i;
		  filename = malloc(strlen(get_savespath())+
				    strlen(ROM_SETTINGS.goodname)+4+1);
		  strcpy(filename, get_savespath());
		  strcat(filename, ROM_SETTINGS.goodname);
		  strcat(filename, ".sra");
		  f = fopen(filename, "rb");
		  if (f)
		    {
		       fread(sram, 1, 0x8000, f);
		       fclose(f);
		    }
		  else for (i=0; i<0x8000; i++) sram[i] = 0;
		  free(filename);
		  for (i=0; i<(pi_register.pi_wr_len_reg & 0xFFFFFF)+1; i++)
		    ((unsigned char*)rdram)[(pi_register.pi_dram_addr_reg+i)^S8]=
		    sram[(((pi_register.pi_cart_addr_reg-0x08000000)&0xFFFF)+i)^S8];
		  use_flashram = -1;
	       }
	     else
	       dma_read_flashram();
	  }
	else if (pi_register.pi_cart_addr_reg >= 0x06000000 &&
		 pi_register.pi_cart_addr_reg < 0x08000000)
	  {
	  }
	else
	  printf("unknown dma write:%x\n", (int)pi_register.pi_cart_addr_reg);
	if (!dynacore)
	  {
	     pi_register.read_pi_status_reg |= 1;
	     update_count();
	     add_interupt_event(PI_INT, pi_register.pi_wr_len_reg);
	  }
	else
	  {
	     MI_register.mi_intr_reg |= 0x10;
	     gen_mi();
	  }
	return;
     }
   if (pi_register.pi_cart_addr_reg >= 0x1fc00000) return; // for paper mario
   if (!dynacore /*&& interpcore*/)
     {
	int i;
	longueur = (pi_register.pi_wr_len_reg & 0xFFFFFF)+1;
	i = (pi_register.pi_cart_addr_reg-0x10000000)&0x3FFFFFFF;
	longueur = (i + longueur) > taille_rom ?
	  (taille_rom - i) : longueur;
	longueur = (pi_register.pi_dram_addr_reg + longueur) > 0x7FFFFF ?
	  (0x7FFFFF - pi_register.pi_dram_addr_reg) : longueur;
	for (i=0; i<longueur; i++)
	  ((unsigned char*)rdram)[(pi_register.pi_dram_addr_reg+i)^S8]=
	  rom[(((pi_register.pi_cart_addr_reg-0x10000000)&0x3FFFFFFF)+i)^S8];
	
	for (i=0; i<=(longueur>>12); i++)
	  invalid_code[(((pi_register.pi_dram_addr_reg&0xFFFFFF)|0x80000000)>>12)+i] = 1;
	
	if ((debug_count+Count) < 0x100000)
	  {
	     switch(CIC_Chip)
	       {
		case 1:
		case 2:
		case 3:
		case 6:
		  rdram[0x318/4] = 0x800000;
		  break;
		case 5:
		  rdram[0x3F0/4] = 0x800000;
		  break;
	       }
	  }
	
	if (!dynacore)
	  {
	     pi_register.read_pi_status_reg |= 3;
	     update_count();
	     add_interupt_event(PI_INT, longueur/8);
	  }
	else
	  {
	     MI_register.mi_intr_reg |= 0x10;
	     gen_mi();
	  }
	return;
     }
#ifdef OLD_CODE   
   if (pi_register.pi_cart_addr_reg < 0x10000000)
     printf("pi dma not in cartridge\n");
   if (pi_register.pi_dram_addr_reg < 0x300)
     int_handler.valid = 0;
   for (i=0; i<0x100000; i++)
     {
	if (actual == &blocks[i])
	  {
	     if ((0x80000000 + pi_register.pi_dram_addr_reg) <= actual->start)
	       {
		  if ((0x80000000 + pi_register.pi_dram_addr_reg +
		      pi_register.pi_wr_len_reg) >= actual->start)
		    {
		       printf("erreur de recompilation dans un dma pi\n");
		       stop=1;
		       return;
		    }
	       }
	     else if ((0x80000000 + pi_register.pi_dram_addr_reg) <= actual->end)
	       {
		  if ((0x80000000 + pi_register.pi_dram_addr_reg) <= PC->addr)
		    {
		       printf("erreur de dma pi\n");
		       stop=1;
		       return;
		    }
		  blocks[i].end = (0x80000000 + pi_register.pi_dram_addr_reg - 4);
		  blocks[i].length = blocks[i].end - blocks[i].start;
	       }
	  }
	if (blocks[i].valid)
	  {
	     if (((0x80000000 + pi_register.pi_dram_addr_reg) <= actual->end)&&
		 ((0x80000000 + pi_register.pi_dram_addr_reg +
		   pi_register.pi_wr_len_reg) >= actual->start))
	       {
		  printf("recouvrement rdram\n");
		  stop=1;
		  return;
	       }
	  }
	if (((0x80000000 + pi_register.pi_dram_addr_reg) <= blocks[i].end)&&
	    ((0x80000000 + pi_register.pi_dram_addr_reg +
	      pi_register.pi_wr_len_reg)>= blocks[i].start)&& !blocks[i].valid) {
	   blocks[i].start = 0;
	   if (blocks[i].code) {
	      free(blocks[i].code);
	      blocks[i].code = NULL;
	   }
	   if (blocks[i].block) {
	      free(blocks[i].block);
	      blocks[i].block = NULL;
	   }
	}
	if (!blocks[i].valid && (0x80000000 + pi_register.pi_dram_addr_reg)
	    == (blocks[i].end + 1)) {
	   blocks[i].end = 0x80000000 + pi_register.pi_dram_addr_reg +
	     pi_register.pi_wr_len_reg;
	   blocks[i].length = blocks[i].end - blocks[i].start;
	}
     }
   if (pi_register.pi_wr_len_reg>taille_rom)
     {
	longueur = taille_rom-((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF);
#ifdef _BIG_ENDIAN
	memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
	       rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
	       pi_register.pi_wr_len_reg+1);
#else
	if ((pi_register.pi_dram_addr_reg % 4) != 0)
	  printf("unaligned PI dma 1\n");
	if ((pi_register.pi_cart_addr_reg % 4) != 0) {
	   if (((longueur+1) % 4) != 0)
	     printf("unaligned PI dma 23\n");
	   if ((pi_register.pi_cart_addr_reg % 4) == 2) {
	      memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg+2,
		     rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)+2,
		     longueur+1);
	      ((unsigned short*)
	       rdram)[(pi_register.pi_dram_addr_reg-2)/2]=
		((unsigned short*)rom)
	       [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		 - 2)/2];
	   }
	   else
	     printf("unaligned PI dma 2\n");
	}
	else if (((longueur+1) % 4) != 0) {
	   if (((longueur+1) % 4) == 2) {
	      memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		     rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		     longueur-1);
	      ((unsigned short*)
	       rdram)[(pi_register.pi_dram_addr_reg+longueur+1)/2]=
		((unsigned short*)rom)
	       [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		 + longueur+1)/2];
	   }
	   else
	     printf("unaligned PI dma 3\n");
	}
	else
	  memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		 rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		 longueur);
#endif
	for (i=0; i<0x100000; i++) {
	   if (!blocks[i].valid && !blocks[i].start) {
	      new_blk=i;
	      break;
	   }
	   if (i==(0x100000-1) && new_blk == 0)
	     printf("erreur d'allocation d'un nouveau block\n");
	}
	blocks[new_blk].valid = 0;
	blocks[new_blk].start = 0x80000000+pi_register.pi_dram_addr_reg;
	blocks[new_blk].end = blocks[new_blk].start + longueur;
	blocks[new_blk].length = longueur;
     }
   else
     {
	if ((pi_register.pi_dram_addr_reg+pi_register.pi_wr_len_reg)<0x400000)
	  {
	     longueur = pi_register.pi_wr_len_reg;
#ifdef _BIG_ENDIAN
	     memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		    rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		    pi_register.pi_wr_len_reg+1);
#else
	     if ((pi_register.pi_dram_addr_reg % 4) != 0)
	       printf("unaligned PI dma 1\n");
	     if ((pi_register.pi_cart_addr_reg % 4) != 0) {
		if (((longueur+1) % 4) != 0)
		  printf("unaligned PI dma 23\n");
		if ((pi_register.pi_cart_addr_reg % 4) == 2) {
		   memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg+2,
			  rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)+2,
			  longueur+1);
		   ((unsigned short*)
		    rdram)[(pi_register.pi_dram_addr_reg-2)/2]=
		     ((unsigned short*)rom)
		    [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		      - 2)/2];
		}
		else
		  printf("unaligned PI dma 2\n");
	     }
	     else if (((longueur+1) % 4) != 0) {
		if (((longueur+1) % 4) == 2) {
		   memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
			  rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
			  longueur-1);
		   ((unsigned short*)
		    rdram)[(pi_register.pi_dram_addr_reg+longueur+1)/2]=
		     ((unsigned short*)rom)
		    [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		      + longueur+1)/2];
		}
		else
		  printf("unaligned PI dma 3\n");
	     }
	     else
	       memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		      rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		      longueur+1);
#endif
	     for (i=0; i<0x100000; i++) {
		if (!blocks[i].valid && !blocks[i].start) {
		   new_blk=i;
		   break;
		}
		if (i==(0x100000-1) && new_blk == 0)
		  printf("erreur d'allocation d'un nouveau block\n");
	     }
	     blocks[new_blk].valid = 0;
	     blocks[new_blk].start = 0x80000000+pi_register.pi_dram_addr_reg;
	     blocks[new_blk].end = blocks[new_blk].start + longueur;
	     blocks[new_blk].length = longueur;
	  }
	else
	  {
	     printf("erreur dma\n");
	     stop=1;
	  }
     }
   if (!dynacore)
     {
	pi_register.read_pi_status_reg |= 3;
	update_count();
	add_interupt_event(PI_INT, pi_register.pi_wr_len_reg*9);
     }
   else
     {
	MI_register.mi_intr_reg |= 0x10;
	gen_mi();
     }
#endif
}

void dma_sp_write()
{
   int i;
   if ((sp_register.sp_mem_addr_reg & 0x1000) > 0)
     {
	for (i=0; i<((sp_register.sp_rd_len_reg & 0xFFF)+1); i++)
	  ((unsigned char *)(SP_IMEM))[((sp_register.sp_mem_addr_reg & 0xFFF)+i)^S8]=
	  ((unsigned char *)(rdram))[((sp_register.sp_dram_addr_reg & 0xFFFFFF)+i)^S8];
     }
   else
     {
	for (i=0; i<((sp_register.sp_rd_len_reg & 0xFFF)+1); i++)
	  ((unsigned char *)(SP_DMEM))[((sp_register.sp_mem_addr_reg & 0xFFF)+i)^S8]=
	  ((unsigned char *)(rdram))[((sp_register.sp_dram_addr_reg & 0xFFFFFF)+i)^S8];
     }
}

void dma_sp_read()
{
   int i;
   if ((sp_register.sp_mem_addr_reg & 0x1000) > 0)
     {
	for (i=0; i<((sp_register.sp_wr_len_reg & 0xFFF)+1); i++)
	  ((unsigned char *)(rdram))[((sp_register.sp_dram_addr_reg & 0xFFFFFF)+i)^S8]=
	  ((unsigned char *)(SP_IMEM))[((sp_register.sp_mem_addr_reg & 0xFFF)+i)^S8];
     }
   else
     {
	for (i=0; i<((sp_register.sp_wr_len_reg & 0xFFF)+1); i++)
	  ((unsigned char *)(rdram))[((sp_register.sp_dram_addr_reg & 0xFFFFFF)+i)^S8]=
	  ((unsigned char *)(SP_DMEM))[((sp_register.sp_mem_addr_reg & 0xFFF)+i)^S8];
     }
}

void dma_si_write()
{
   int i;
   if (si_register.si_pif_addr_wr64b != 0x1FC007C0)
     {
	printf("unknown SI use\n");
	stop=1;
     }
   for (i=0; i<(64/4); i++)
     PIF_RAM[i] = sl(rdram[si_register.si_dram_addr/4+i]);
   update_pif_write();
   update_count();
   if (!dynacore) add_interupt_event(SI_INT, 0x900);
   else
     {
	MI_register.mi_intr_reg |= 0x02;
	si_register.si_status |= 0x1000;
	gen_mi();
     }
}

void dma_si_read()
{
   int i;
   if (si_register.si_pif_addr_rd64b != 0x1FC007C0)
     {
	printf("unknown SI use\n");
	stop=1;
     }
   update_pif_read();
   for (i=0; i<(64/4); i++)
     rdram[si_register.si_dram_addr/4+i] = sl(PIF_RAM[i]);
   update_count();
   if (!dynacore) add_interupt_event(SI_INT, 0x900);
   else
     {
	MI_register.mi_intr_reg |= 0x02;
	si_register.si_status |= 0x1000;
	gen_mi();
     }
}
