#ifndef ROMBROWSER_H
#define ROMBROWSER_H

#include <windows.h>
#define _WIN32_IE 0x0500
#include <commctrl.h>

typedef struct {
	char     szFullFileName[MAX_PATH];
	char     Status[60];
	char     FileName[200];
	char     InternalName[22];
	char     GoodName[200];
	char     CartID[3];
	char     PluginNotes[250];
	char     CoreNotes[250];
	char     UserNotes[250];
	char     Developer[30];
	char     ReleaseDate[30];
	char     Genre[15];
	int      RomSize;
	BYTE     Manufacturer;
	BYTE     Country;
	DWORD    CRC1;
	DWORD    CRC2;
	char     MD5[33];
} ROM_INFO;

typedef struct {
	BYTE     Country;
	DWORD    CRC1;
	DWORD    CRC2;
	long     Fpos;
} ROM_LIST_INFO;

typedef struct {
	int    ListCount;
	int    ListAlloc;
	ROM_LIST_INFO * List;
} ROM_LIST;

typedef struct {
	int    ListCount;
	int    ListAlloc;
	ROM_INFO * List;
} ITEM_LIST;


void AddRomToList (char * RomLocation) ;
void RomList_GetDispInfo(LPNMHDR pnmh) ;
void OpenRomProperties();
int RomList_OpenRom() ;
void RomListNotify(LPNMHDR pnmh) ;
void ResetRomBrowserColomuns (void);
void LoadRomList();
BOOL LoadRomBrowserCache();
void SaveRomBrowserCache();
void saveMD5toCache(char md5str[33]);
void CreateRomListControl (HWND hParent) ;
void ShowRomBrowser(BOOL flag);
void RefreshRomBrowser (void);
void AddDirToList(char RomBrowserDir[MAX_PATH],BOOL sortflag);
void RomList_ColoumnSortList(LPNMLISTVIEW pnmv);
int CALLBACK RomList_CompareItems(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
void ResizeRomListControl ();
static int TOTAL_ROMS_NUMBER = 0;

BOOL addDirectoryToLinkedList(char Dir[MAX_PATH]); 
void removeDirectoryFromLinkedList(char Dir[MAX_PATH]) ;

void FillRomBrowserDirBox(HWND hwnd);
void TranslateBrowserHeader(HWND hwnd);

void freeRomDirList();
void freeRomList();
void getFieldName(int col,char *Name);
void ShowTotalRoms();
void drawSortArrow(int SubItem);

ROM_INFO *getSelectedRom();

extern HWND romInfoHWND ;
extern ITEM_LIST ItemList;
#endif

