#define _WIN32_IE 0x0500
#include <windows.h>
#include <commctrl.h>
#include "../guifuncs.h"
#include "main_win.h"
#include "translation.h"
#include "rombrowser.h"
#include "../../winproject/resource.h"

char *get_currentpath()
{
    return AppPath;
}

char *get_savespath()
{
    static char defDir[MAX_PATH];
    if (Config.DefaultSavesDir) {
        sprintf(defDir,"%sSave\\",AppPath);
        return defDir;
    }
    else return Config.SavesDir;
}

void display_loading_progress(int p)
{
   TranslateDefault("Loading Rom","Loading Rom",TempMessage);
   sprintf(TempMessage,"%s: %d%%",TempMessage,p);
   SendMessage( hStatus, SB_SETTEXT, 1, (LPARAM)TempMessage );  
}

void warn_savestate_not_exist()
{
   if (!Config.savesERRORS) return
   TranslateDefault("Savestates Wrong Slot","You have selected wrong save slot or save doesn't exist",TempMessage);
   sprintf(TempMessage,"%s",TempMessage);
   ShowMessage( TempMessage ); 
}

void warn_savestate_from_another_rom()
{
   if (!Config.savesERRORS) return
   TranslateDefault("Savestates Wrong Region","This savestate from another rom or version",TempMessage);
   sprintf(TempMessage,"%s",TempMessage);
   ShowMessage( TempMessage );
}

void display_MD5calculating_progress(int p )
{
   if (romInfoHWND!=NULL) {
    if (p>0) {
        sprintf(TempMessage,"%d%%",p);
        SetDlgItemText( romInfoHWND, IDC_MD5_PROGRESS, TempMessage );
        SendMessage( GetDlgItem(romInfoHWND, IDC_CURRENT_ROM_PROGRESS), PBM_SETPOS, p+1, 0 );
        }
     else
       {
        SetDlgItemText( romInfoHWND, IDC_MD5_PROGRESS, "" );
        SendMessage( GetDlgItem(romInfoHWND, IDC_CURRENT_ROM_PROGRESS), PBM_SETPOS, 0, 0 );
       }   
   }    
}

int ask_bad()
{
    if (!Config.alertBAD) return 1;
    
    if (MessageBox(NULL,"This rom is a bad dump,do you want to continue?","Bad Dump",MB_YESNO | MB_ICONQUESTION) != IDNO)
            return 1;
    else 
            return 0;            
}

int ask_hack()
{
    if (!Config.alertHACK) return 1;
    
    if (MessageBox(NULL,"This rom is a hacked dump,do you want to continue?","Hacked Dump",MB_YESNO | MB_ICONQUESTION) != IDNO)
            return 1;
    else
            return 0;
}

