#include <windows.h>
#include "config.h"
#include "main_win.h"
#include "rombrowser.h"

#define CfgFileName "mupen64.cfg"

////////////////////// Service functions and structures ////////////////////////

CONFIG Config;

char *CfgFilePath()
{
   static char *cfgpath = NULL;
   if (cfgpath == NULL)
     {
       	cfgpath = malloc(strlen(AppPath)+1+strlen(CfgFileName));
	    strcpy(cfgpath, AppPath);
    	strcat(cfgpath, CfgFileName);
     }
   return cfgpath;
}


void WriteCfgString   (char *Section,char *Key,char *Value) 
{
    WritePrivateProfileString( Section, Key, Value, CfgFilePath());
}


void WriteCfgInt      (char *Section,char *Key,int Value) 
{
    static char TempStr[100];
    sprintf(TempStr,"%d",Value);
    WriteCfgString( Section, Key, TempStr );
}


void ReadCfgString    (char *Section,char *Key,char *DefaultValue,char *retValue) 
{
    GetPrivateProfileString( Section, Key, DefaultValue, retValue, 100, CfgFilePath());
}


int ReadCfgInt        (char *Section,char *Key,int DefaultValue) 
{
    return GetPrivateProfileInt( Section, Key, DefaultValue, CfgFilePath());
}

//////////////////////////// Load and Save Config //////////////////////////////

void LoadConfig()
{
   //Window position and size 
    Config.WindowWidth = ReadCfgInt("Window","Width",640); 
    Config.WindowHeight = ReadCfgInt("Window","Height",480); 
    Config.WindowPosX = ReadCfgInt("Window","X",(GetSystemMetrics( SM_CXSCREEN ) - Config.WindowWidth) / 2);
    Config.WindowPosY = ReadCfgInt("Window","Y",(GetSystemMetrics( SM_CYSCREEN ) - Config.WindowHeight) / 2);
    
    //General Vars
    Config.showFPS = ReadCfgInt("General","Show FPS",1);
    Config.showVIS = ReadCfgInt("General","Show VIS",1);
    Config.alertBAD = ReadCfgInt("General","Alert Bad roms",1);
    Config.alertHACK = ReadCfgInt("General","Alert Hacked roms",1);
    Config.savesERRORS = ReadCfgInt("General","Alert Saves errors",1);
    Config.limitFps = ReadCfgInt("General","Alert Saves errors",1);
    Config.compressedIni = ReadCfgInt("General","Compressed Ini",1);
    Config.guiDynacore = ReadCfgInt("CPU","Core",0);
    
    // Directories
    Config.DefaultPluginsDir = ReadCfgInt("Directories","Default Plugins Directory",1);
    Config.DefaultSavesDir = ReadCfgInt("Directories","Default Saves Directory",1);
    Config.DefaultScreenshotsDir = ReadCfgInt("Directories","Default Screenshots Directory",1);
    
    sprintf(Config.PluginsDir,"%sPlugin\\",AppPath);
    ReadCfgString("Directories","Plugins Directory",Config.PluginsDir, Config.PluginsDir);
    
    sprintf(Config.SavesDir,"%sSave\\",AppPath);
    ReadCfgString("Directories","Saves Directory",Config.SavesDir, Config.SavesDir);
    
    sprintf(Config.ScreenshotsDir,"%sScreenShots\\",AppPath);
    ReadCfgString("Directories","Screenshots Directory",Config.ScreenshotsDir, Config.ScreenshotsDir);    
    
    // Rom Browser
    Config.RomBrowserSortColumn = ReadCfgInt( "Rom Browser", "Sort Column" , 0);
    Config.RomBrowserRecursion = ReadCfgInt("Rom Browser","Recursion",0);
    ReadCfgString("Rom Browser","Sort Method","ASC",Config.RomBrowserSortMethod);
  
}

/////////////////////////////////////////////////////////////////////////////////

void saveWindowSettings()
{
    RECT rcMain;
    GetWindowRect(mainHWND, &rcMain);
	Config.WindowPosX=rcMain.left;
	Config.WindowPosY=rcMain.top;
	Config.WindowWidth = rcMain.right - rcMain.left;
	Config.WindowHeight = rcMain.bottom - rcMain.top;
	WriteCfgInt("Window","Width",Config.WindowWidth); 
    WriteCfgInt("Window","Height",Config.WindowHeight); 
    WriteCfgInt("Window","X",Config.WindowPosX);
    WriteCfgInt("Window","Y",Config.WindowPosY);
}

void saveBrowserSettings()
{
    int Column,ColWidth;
    char FieldName[30];
    for (Column = 0; Column < 4; Column ++) {
        ColWidth = ListView_GetColumnWidth(hRomList,Column);
        getFieldName(Column,FieldName);
        sprintf(TempMessage,"%d",ColWidth);
        WriteCfgString("Rom Browser",FieldName,TempMessage);
    }
    
    WriteCfgInt( "Rom Browser", "Sort Column", Config.RomBrowserSortColumn);
    WriteCfgInt( "Rom Browser", "Recursion", Config.RomBrowserRecursion);
    WriteCfgString("Rom Browser","Sort Method", Config.RomBrowserSortMethod);
}

void SaveConfig()
{
    saveWindowSettings();
    saveBrowserSettings();
    
    //General Vars
    WriteCfgInt( "General", "Show FPS", Config.showFPS);
    WriteCfgInt( "General", "Show VIS", Config.showVIS);
    WriteCfgInt( "General", "Alert Bad roms", Config.alertBAD);
    WriteCfgInt( "General", "Alert Hacked roms", Config.alertHACK);
    WriteCfgInt( "General", "Alert Saves errors", Config.savesERRORS);
    WriteCfgInt( "General", "Alert Saves errors", Config.limitFps);
    WriteCfgInt( "General", "Compressed Ini", Config.compressedIni);
   
    WriteCfgInt( "CPU", "Core", Config.guiDynacore);
    
    // Directories
    WriteCfgInt( "Directories", "Default Plugins Directory", Config.DefaultPluginsDir);
    WriteCfgString("Directories","Plugins Directory",Config.PluginsDir);
    WriteCfgInt( "Directories","Default Saves Directory", Config.DefaultSavesDir);
    WriteCfgString("Directories","Saves Directory",Config.SavesDir);
    WriteCfgInt( "Directories", "Default Screenshots Directory", Config.DefaultScreenshotsDir);
    WriteCfgString("Directories","Screenshots Directory",Config.ScreenshotsDir);    
}


