/**
 * Mupen64 - main.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

/* This is the command line version of the MUPEN64's entry point,
 * if you want to implement an interface, you should look here
 */

// Emulateur Nintendo 64, MUPEN64, Fichier Principal 
// main.c
#define VERSION "0.1\0"

#include <stdlib.h>
#include <unistd.h>

#include "guifuncs.h"
#include "rom.h"
#include "../r4300/r4300.h"
#include "../r4300/recomph.h"
#include "../memory/memory.h"
#include "winlnxdefs.h"
#include "plugin.h"
#include "savestates.h"

#include <SDL/SDL.h>

static char cwd[1024];

char *get_currentpath()
{
   return cwd;
}

char *get_savespath()
{
   static char path[1024];
   strcpy(path, get_currentpath());
   strcat(path, "save/");
   return path;
}

void display_loading_progress(int p)
{
   printf("loading rom : %d%%\r", p);
   fflush(stdout);
   if (p==100) printf("\n");
}

void display_MD5calculating_progress(int p)
{
}

int ask_bad()
{
   char c;
   printf("The rom you are trying to load is probably a bad dump\n");
   printf("Be warned that this will probably give unexpected results.\n");
   printf("Do you still want to run it (y/n) ?");
   c = getchar();
   getchar();
   if (c=='y' || c=='Y') return 1;
   else return 0;
}

int ask_hack()
{
   char c;
   printf("The rom you are trying to load is not a good verified dump\n");
   printf("It can be a hacked dump, trained dump or anything else that \n");
   printf("may work but be warned that it can give unexpected results.\n");
   printf("Do you still want to run it (y/n) ?");
   c = getchar();
   getchar();
   if (c=='y' || c=='Y') return 1;
   else return 0;
}

void warn_savestate_from_another_rom()
{
   printf("Error: You're trying to load a save state from either another rom\n");
   printf("       or another dump.\n");
}

void warn_savestate_not_exist()
{
   printf("Error: The save state you're trying to load doesn't exist\n");
}

void new_frame()
{
}

void new_vi()
{
}

static int filter(const SDL_Event *event)
{
   switch (event->type)
     {
      case SDL_KEYDOWN:
	switch (event->key.keysym.sym)
	  {
	   case SDLK_F5:
	     savestates_job |= SAVESTATE;
	     break;
	   case SDLK_F7:
	     savestates_job |= LOADSTATE;
	     break;
	   case SDLK_ESCAPE:
	     stop_it();
	     break;
	   case SDLK_F1:
	     changeWindow();
	     break;
	   default:
	     switch (event->key.keysym.unicode)
	       {
		case '0':
		  savestates_select_slot(0);
		  break;
		case '1':
		  savestates_select_slot(1);
		  break;
		case '2':
		  savestates_select_slot(2);
		  break;
		case '3':
		  savestates_select_slot(3);
		  break;
		case '4':
		  savestates_select_slot(4);
		  break;
		case '5':
		  savestates_select_slot(5);
		  break;
		case '6':
		  savestates_select_slot(6);
		  break;
		case '7':
		  savestates_select_slot(7);
		  break;
		case '8':
		  savestates_select_slot(8);
		  break;
		case '9':
		  savestates_select_slot(9);
		  break;
		default:
		  keyDown(0, event->key.keysym.sym);
	       }
	  }
	return 0;
	break;
      case SDL_KEYUP:
	switch (event->key.keysym.sym)
	  {
	   case SDLK_ESCAPE:
	     break;
	   case SDLK_F1:
	     break;
	   default:
	     keyUp(0, event->key.keysym.sym);
	  }
	return 0;
	break;
      default:
	return 1;
     }
}

int main (int argc, char *argv[])
{
   char c;
   char plugins[100][100], s[2];
   int old_i, i, i1, i2, i3, i4;
   
   if (argv[0][0] != '/')
     {
	getcwd(cwd, 1024);
	strcat(cwd, "/");
	strcat(cwd, argv[0]);
     }
   else
     strcpy(cwd, argv[0]);
   while(cwd[strlen(cwd)-1] != '/') cwd[strlen(cwd)-1] = '\0';
   
   printf("Mupen64 version : %s\n", VERSION);
   
   if (argc!=2)
     {
	printf("syntax: mupen64_RENDERER rom\n");
	return 0;
     }
   
   if (rom_read(argv[1]))
     {
	if(rom) free(rom);
	if(ROM_HEADER) free(ROM_HEADER);
	return 1;
     }
   printf("Goodname:%s\n", ROM_SETTINGS.goodname);
   printf("16kb eeprom=%d\n", ROM_SETTINGS.eeprom_16kb);
   printf ("emulation mode:\n"
	   "     1. interpreter\n"
	   "     2. dynamic recompiler (default)\n"
           "     3. pure interpreter\n");
   if ((c = getchar()) == '1') dynacore=0;
   else if (c == '3') dynacore=2;
   else dynacore=1;
   
   SDL_Init(SDL_INIT_VIDEO);
   SDL_SetVideoMode(10, 10, 16, 0);
   SDL_ShowCursor(0);
   SDL_EnableKeyRepeat(0, 0);
   SDL_EnableUNICODE(1);
   init_memory();
   // --------------------- loading plugins ----------------------
   plugin_scan_directory(cwd);
   i=1;
   i1=1;
   printf("  Choose your gfx plugin : \n");
   while(plugin_type() != -1)
     {
	if (plugin_type() == PLUGIN_TYPE_GFX)
	  {
	     strcpy(plugins[i], plugin_next());
	     printf("%s\n", plugins[i++]);
	  }
	else
	  plugin_next();
     }
   getchar();
   c = getchar();
   s[0] = c;
   s[1] = 0;
   i1 = atoi(s);
   
   plugin_rewind();
   old_i = i;
   printf("  Choose your audio plugin : \n");
   while(plugin_type() != -1)
     {
	if (plugin_type() == PLUGIN_TYPE_AUDIO)
	  {
	     strcpy(plugins[i], plugin_next());
	     printf("%s\n", plugins[i++]);
	  }
	else
	  plugin_next();
     }
   getchar();
   c = getchar();
   //getchar();
   s[0] = c;
   s[1] = 0;
   i2 = old_i + atoi(s) - 1;
   
   plugin_rewind();
   old_i = i;
   printf("  Choose your input plugin : \n");
   while(plugin_type() != -1)
     {
	if (plugin_type() == PLUGIN_TYPE_CONTROLLER)
	  {
	     strcpy(plugins[i], plugin_next());
	     printf("%s\n", plugins[i++]);
	  }
	else
	  plugin_next();
     }
   getchar();
   c = getchar();
   //getchar();
   s[0] = c;
   s[1] = 0;
   i3 = old_i + atoi(s) - 1;
   
   plugin_rewind();
   old_i = i;
   printf("  Choose your RSP plugin : \n");
   while(plugin_type() != -1)
     {
	if (plugin_type() == PLUGIN_TYPE_RSP)
	  {
	     strcpy(plugins[i], plugin_next());
	     printf("%s\n", plugins[i++]);
	  }
	else
	  plugin_next();
     }
   getchar();
   c = getchar();
   getchar();
   s[0] = c;
   s[1] = 0;
   i4 = old_i + atoi(s) - 1;
   
   plugin_load_plugins(plugins[i1], plugins[i2], plugins[i3], plugins[i4]);
   romOpen_gfx();
   romOpen_audio();
   romOpen_input();
   // ------------------------------------------------------------
   SDL_SetEventFilter(filter);
   go();
   romClosed_RSP();
   romClosed_input();
   romClosed_audio();
   romClosed_gfx();
   closeDLL_RSP();
   closeDLL_input();
   closeDLL_audio();
   closeDLL_gfx();
   free(rom);
   free(ROM_HEADER);
   free_memory();
   return 0;
}
