/**
 * Mupen64 - gregimm.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "../recomp.h"
#include "../r4300.h"
#include "assemble.h"
#include "../ops.h"
#include "../../memory/memory.h"
#include "../macros.h"

void genbgezl()
{
   unsigned long temp, temp2;
   recomp_jump = 0;
   dst->local_addr = code_length;
   cmp_m32_imm8((unsigned long *)(dst->f.i.rs)+1, 0);
   jge_rj(0x05);
   put8(0xE9);
   put32(0);
   temp=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp2=code_length;
   code_length = temp-4;
   put32(temp2-temp);
   code_length = temp2;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}

void genbltzl()
{
   unsigned long temp, temp2;
   recomp_jump = 0;
   dst->local_addr = code_length;
   cmp_m32_imm8((unsigned long *)(dst->f.i.rs)+1, 0);
   jl_rj(0x05);
   put8(0xE9);
   put32(0);
   temp=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp2=code_length;
   code_length = temp-4;
   put32(temp2-temp);
   code_length = temp2;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}

void genbgezal()
{
   recomp_jump = 0;
   dst->local_addr = code_length;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_m32_imm32((unsigned long *)(reg + 31), dst->addr+4);
   cmp_m32_imm8((unsigned long *)(&local_rs)+1, 0);
   jge_near(dst->addr + (dst-1)->f.i.immediate*4);
   
   jmp(dst->addr + 4);
}

void genbgezal_idle()
{
   unsigned long temp1, temp2, temp3, temp4;
   recomp_jump = 0;
   dst->local_addr = code_length;
   if(dst->f.i.rs == (reg+31)) printf("erreur dans bgezal\n");
   
   cmp_m32_imm8((unsigned long *)(&sp_register.halt), 0);
   je_near_rj(0);
   
   temp1 = code_length;
   
   cmp_m32_imm8((unsigned long *)(dst->f.i.rs)+1, 0);
   jl_near_rj(0);
   
   temp2 = code_length;
   
   mov_eax_memoffs32((unsigned long *)(&next_interupt));
   sub_reg32_m32(EAX, (unsigned long *)(&Count));
   cmp_reg32_imm8(EAX, 3);
   jle_near_rj(0);
   
   temp3 = code_length;
   
   and_eax_imm32(0xFFFFFFFC);
   add_m32_reg32((unsigned long *)(&Count), EAX);
   jmp(dst->addr);
   
   temp4 = code_length;
   code_length = temp1-4;
   put32(temp4 - temp1);
   code_length = temp2-4;
   put32(temp4 - temp2);
   code_length = temp3-4;
   put32(temp4 - temp3);
   code_length = temp4;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_m32_imm32((unsigned long *)(reg + 31), dst->addr+4);
   cmp_m32_imm8((unsigned long *)(&local_rs)+1, 0);
   jge_near(dst->addr + (dst-1)->f.i.immediate*4);
   
   jmp(dst->addr + 4);
}

void genbgez()
{
   dst->local_addr = code_length;
   recomp_jump = 0;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   cmp_m32_imm8((unsigned long *)(&local_rs)+1, 0);
   jge_near(dst->addr + (dst-1)->f.i.immediate*4);
   
   jmp(dst->addr + 4);
}

void genbltz()
{
   recomp_jump = 0;
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&local_rs)+1);
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   cmp_m32_imm8((unsigned long *)(&local_rs)+1, 0);
   jl_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}
