/**
 * Mupen64 - tlb.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "r4300.h"
#include "macros.h"
#include "ops.h"
#include "recomph.h"

void TLBWI()
{
   int i;
   if (tlb_e[Index&0x3F].v_even)
     {
	for (i=tlb_e[Index&0x3F].start_even; i<tlb_e[Index&0x3F].end_even; i++)
	  tlb_LUT_r[i] = 0;
	if (tlb_e[Index&0x3F].d_even)
	  for (i=tlb_e[Index&0x3F].start_even; i<tlb_e[Index&0x3F].end_even; i++)
	    tlb_LUT_w[i] = 0;
     }
   if (tlb_e[Index&0x3F].v_odd)
     {
	for (i=tlb_e[Index&0x3F].start_odd; i<tlb_e[Index&0x3F].end_odd; i++)
	  tlb_LUT_r[i] = 0;
	if (tlb_e[Index&0x3F].d_odd)
	  for (i=tlb_e[Index&0x3F].start_odd; i<tlb_e[Index&0x3F].end_odd; i++)
	    tlb_LUT_w[i] = 0;
     }
   
   tlb_e[Index&0x3F].g = (EntryLo0 & EntryLo1 & 1);
   tlb_e[Index&0x3F].pfn_even = (EntryLo0 & 0x3FFFFFC0) >> 6;
   tlb_e[Index&0x3F].pfn_odd = (EntryLo1 & 0x3FFFFFC0) >> 6;
   tlb_e[Index&0x3F].c_even = (EntryLo0 & 0x38) >> 3;
   tlb_e[Index&0x3F].c_odd = (EntryLo1 & 0x38) >> 3;
   tlb_e[Index&0x3F].d_even = (EntryLo0 & 0x4) >> 2;
   tlb_e[Index&0x3F].d_odd = (EntryLo1 & 0x4) >> 2;
   tlb_e[Index&0x3F].v_even = (EntryLo0 & 0x2) >> 1;
   tlb_e[Index&0x3F].v_odd = (EntryLo1 & 0x2) >> 1;
   tlb_e[Index&0x3F].asid = (EntryHi & 0xFF);
   tlb_e[Index&0x3F].vpn2 = (EntryHi & 0xFFFFE000) >> 13;
   tlb_e[Index&0x3F].r = (EntryHi & 0xC000000000000000LL) >> 62;
   tlb_e[Index&0x3F].mask = (PageMask & 0x1FFE000) >> 13;
   /*switch(tlb_e[Index&0x3F].mask)
     {
      case 0x000:
	tlb_e[Index&0x3F].check_parity_mask = 0x00001000;
	break;
      case 0x003:
	tlb_e[Index&0x3F].check_parity_mask = 0x00004000;
	break;
      case 0x00F:
	tlb_e[Index&0x3F].check_parity_mask = 0x00010000;
	break;
      case 0x03F:
	tlb_e[Index&0x3F].check_parity_mask = 0x00040000;
	break;
      case 0x0FF:
	tlb_e[Index&0x3F].check_parity_mask = 0x00100000;
	break;
      case 0x3FF:
	tlb_e[Index&0x3F].check_parity_mask = 0x00400000;
	break;
      case 0xFFF:
	tlb_e[Index&0x3F].check_parity_mask = 0x01000000;
	break;
     }*/
   if (tlb_e[Index&0x3F].v_even)
     {
	tlb_e[Index&0x3F].start_even = tlb_e[Index&0x3F].vpn2 << 13;
	tlb_e[Index&0x3F].end_even = tlb_e[Index&0x3F].start_even+
	  (tlb_e[Index&0x3F].mask << 12) + 0xFFF;
	tlb_e[Index&0x3F].phys_even = tlb_e[Index&0x3F].pfn_even << 12;
	for (i=tlb_e[Index&0x3F].start_even;i<tlb_e[Index&0x3F].end_even;i++)
	  tlb_LUT_r[i] = 0x80000000 | (tlb_e[Index&0x3F].phys_even + i);
	if (tlb_e[Index&0x3F].d_even)
	  for (i=tlb_e[Index&0x3F].start_even;i<tlb_e[Index&0x3F].end_even;i++)
	    tlb_LUT_w[i] = 0x80000000 | (tlb_e[Index&0x3F].phys_even + i);
     }
   if (tlb_e[Index&0x3F].v_odd)
     {
	tlb_e[Index&0x3F].start_odd = tlb_e[Index&0x3F].end_even+1;
	tlb_e[Index&0x3F].end_odd = tlb_e[Index&0x3F].start_odd+
	  (tlb_e[Index&0x3F].mask << 12) + 0xFFF;
	tlb_e[Index&0x3F].phys_odd = tlb_e[Index&0x3F].pfn_odd << 12;
	for (i=tlb_e[Index&0x3F].start_odd;i<tlb_e[Index&0x3F].end_odd;i++)
	  tlb_LUT_r[i] = 0x80000000 | (tlb_e[Index&0x3F].phys_odd + i);
	if (tlb_e[Index&0x3F].d_odd)
	  for (i=tlb_e[Index&0x3F].start_odd;i<tlb_e[Index&0x3F].end_odd;i++)
	    tlb_LUT_w[i] = 0x80000000 | (tlb_e[Index&0x3F].phys_odd + i);
     }
   PC++;
}

void TLBP()
{
   int i;
   Index |= 0x80000000;
   for (i=0; i<32; i++)
     {
	if ((tlb_e[i].vpn2 == ((EntryHi & 0xFFFFE000) >> 13)*2) &&
	    ((tlb_e[i].g) ||
	     (tlb_e[i].asid == (EntryHi & 0xFF))))
	  {
	     Index = i;
	     break;
	  }
     }
   PC++;
}

void TLBR()
{
   int index;
   index = Index & 0x1F;
   PageMask = tlb_e[index].mask << 13;
   EntryHi = ((tlb_e[index].vpn2 << 13) | (tlb_e[index].g << 12)
     | tlb_e[index].asid);
   EntryLo1 = (tlb_e[index].pfn_even << 6) | (tlb_e[index].c_even << 3)
     | (tlb_e[index].d_even << 2) | (tlb_e[index].v_even << 1)
       | tlb_e[index].g;
   EntryLo0 = (tlb_e[index].pfn_odd << 6) | (tlb_e[index].c_odd << 3)
     | (tlb_e[index].d_odd << 2) | (tlb_e[index].v_odd << 1)
       | tlb_e[index].g;
   PC++;
}

int jump_marker = 0;

void ERET()
{
   if (Status & 0x4)
     {
	printf ("erreur dans ERET\n");
	stop=1;
     }
   else
     {
	jump_to((unsigned long)(EPC));
	Status &= 0xFFFFFFFD;
	if (jump_marker)
	  {
	     Count--;
	     jump_marker=0;
	  }
     }
   llbit = 0;
}
