/**
 * Mupen64 - bc.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "r4300.h"
#include "ops.h"
#include "macros.h"

void BC1T()
{
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if ((FCR31 & 0x800000)!=0)
     if (!skip_jump)
       PC += (PC-2)->f.i.immediate-1;
   if (skip_jump) skip_jump=0;
}

void BC1F()
{
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if ((FCR31 & 0x800000)==0)
     if (!skip_jump)
       PC += (PC-2)->f.i.immediate-1;
   if (skip_jump) skip_jump=0;
}

void BC1FL()
{
   if ((FCR31 & 0x800000)==0)
     {
	PC++;
	delay_slot=1;
	update_system();
	PC->ops();
	delay_slot=0;
	if (!skip_jump)
	  PC += (PC-2)->f.i.immediate-1;
	else skip_jump=0;
     }
   else
     PC+=2;
}

void BC1TL()
{
   if ((FCR31 & 0x800000)!=0)
     {
	PC++;
	delay_slot=1;
	update_system();
	PC->ops();
	delay_slot=0;
	if (!skip_jump)
	  PC += (PC-2)->f.i.immediate-1;
	else skip_jump=0;
     }
   else
     PC+=2;
}
